/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen.stubgen;

import com.bea.util.jam.JClass;
import java.io.File;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import weblogic.jws.wlw.UseWLW81BindingTypes;
import weblogic.wsee.tools.ToolsUtil;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.clientgen.ProcessInfo;
import weblogic.wsee.tools.clientgen.jaxrpc.ClientGenProcessor;
import weblogic.wsee.tools.clientgen.stubgen.ServiceBase;
import weblogic.wsee.tools.clientgen.stubgen.StubBase;
import weblogic.wsee.tools.source.JsClass;
import weblogic.wsee.tools.source.JsPort;
import weblogic.wsee.tools.source.JsService;
import weblogic.wsee.util.jspgen.GenFactory;
import weblogic.wsee.util.jspgen.ScriptException;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;

public class StubGenProcessor
implements ClientGenProcessor {
    private File destDir;
    private String packageName;
    private String wsdlLocation;
    ProcessInfo.StubInfo stubInfo;
    private boolean initialized = false;
    private boolean generatePolicyMethods;
    private boolean shouldConvertInnerClassString = false;

    public void process(ProcessInfo processInfo) throws WsBuildException {
        Object object;
        if (processInfo.isPartialWsdl()) {
            return;
        }
        JsService jsService = processInfo.getJsService();
        this.packageName = processInfo.getPackageName();
        this.destDir = processInfo.getDestDir();
        JClass jClass = processInfo.getCallbackJClass();
        if (jClass != null) {
            boolean bl = this.shouldConvertInnerClassString = jClass.getAnnotation(UseWLW81BindingTypes.class) != null;
        }
        if (!this.shouldConvertInnerClassString && (object = processInfo.getWebServiceJClass()) != null) {
            this.shouldConvertInnerClassString = object.getAnnotation(UseWLW81BindingTypes.class) != null;
        }
        System.out.println("Package name is " + this.packageName);
        System.out.println("DestDir is " + this.destDir.toString());
        this.generatePolicyMethods = processInfo.getGeneratePolicyMethods();
        this.init(jsService.getWsdlService());
        processInfo.setStubInfo(this.stubInfo);
        object = processInfo.getPackageName().replace('.', '/');
        this.wsdlLocation = (String)object + "/" + processInfo.getWsdlFileName();
        this.generateServiceInterface(jsService.getWsdlService());
        this.generateServiceImpl(jsService.getWsdlService());
        HashSet<QName> hashSet = new HashSet<QName>();
        Iterator iterator = jsService.getPorts();
        while (iterator.hasNext()) {
            JsPort jsPort = (JsPort)iterator.next();
            WsdlPortType wsdlPortType = jsPort.getWsdlPort().getPortType();
            if (!hashSet.add(wsdlPortType.getName())) continue;
            this.generateStubInterface(wsdlPortType, jsPort.getEndpoint());
            this.generateStubImpl(wsdlPortType, jsPort.getEndpoint(), processInfo.getCallbackJClass());
        }
        this.generateExceptions(jsService);
    }

    private void generateServiceInterface(WsdlService wsdlService) throws WsBuildException {
        PrintStream printStream = ToolsUtil.createJavaSourceStream(this.destDir, this.packageName, this.stubInfo.getServiceName());
        try {
            ServiceBase serviceBase = (ServiceBase)GenFactory.create("weblogic.wsee.tools.clientgen.stubgen.ServiceInterface");
            serviceBase.setService(wsdlService);
            serviceBase.setWSDLLocation(this.wsdlLocation);
            serviceBase.setPackageName(this.packageName);
            serviceBase.setClassName(this.stubInfo.getServiceName());
            serviceBase.setPortNameMap(this.stubInfo.getPortNameMap());
            serviceBase.setPortTypeNameMap(this.stubInfo.getPortTypeNameMap());
            serviceBase.setOutput(printStream);
            serviceBase.setGeneratePolicyMethods(this.generatePolicyMethods);
            serviceBase.setShouldConvertInnerClassString(this.shouldConvertInnerClassString);
            serviceBase.generate();
        }
        catch (ScriptException scriptException) {
            throw new WsBuildException("Service interface generation failed", scriptException);
        }
        finally {
            printStream.close();
        }
    }

    private void generateServiceImpl(WsdlService wsdlService) throws WsBuildException {
        PrintStream printStream = ToolsUtil.createJavaSourceStream(this.destDir, this.packageName, this.stubInfo.getServiceImplName());
        try {
            ServiceBase serviceBase = (ServiceBase)GenFactory.create("weblogic.wsee.tools.clientgen.stubgen.ServiceImpl");
            serviceBase.setService(wsdlService);
            serviceBase.setWSDLLocation(this.wsdlLocation);
            serviceBase.setPackageName(this.packageName);
            serviceBase.setClassName(this.stubInfo.getServiceImplName());
            serviceBase.setServiceName(this.stubInfo.getServiceName());
            serviceBase.setPortNameMap(this.stubInfo.getPortNameMap());
            serviceBase.setPortTypeNameMap(this.stubInfo.getPortTypeNameMap());
            serviceBase.setStubNameMap(this.stubInfo.getStubNameMap());
            serviceBase.setOutput(printStream);
            serviceBase.setGeneratePolicyMethods(this.generatePolicyMethods);
            serviceBase.setShouldConvertInnerClassString(this.shouldConvertInnerClassString);
            serviceBase.generate();
        }
        catch (ScriptException scriptException) {
            throw new WsBuildException("Service interface generation failed", scriptException);
        }
        finally {
            printStream.close();
        }
    }

    private void generateStubInterface(WsdlPortType wsdlPortType, JsClass jsClass) throws WsBuildException {
        String string = this.stubInfo.getPortTypeNameMap().get(wsdlPortType.getName().getLocalPart());
        PrintStream printStream = ToolsUtil.createJavaSourceStream(this.destDir, this.packageName, string);
        try {
            StubBase stubBase = (StubBase)GenFactory.create("weblogic.wsee.tools.clientgen.stubgen.StubInterface");
            stubBase.setPackageName(this.packageName);
            stubBase.setClassName(string);
            stubBase.setEndpoint(jsClass);
            stubBase.setOutput(printStream);
            stubBase.setShouldConvertInnerClassString(this.shouldConvertInnerClassString);
            stubBase.generate();
        }
        catch (ScriptException scriptException) {
            throw new WsBuildException("Service interface generation failed", scriptException);
        }
        finally {
            printStream.close();
        }
    }

    private void generateStubImpl(WsdlPortType wsdlPortType, JsClass jsClass, JClass jClass) throws WsBuildException {
        String string = this.stubInfo.getStubNameMap().get(wsdlPortType.getName().getLocalPart());
        String string2 = this.stubInfo.getPortTypeNameMap().get(wsdlPortType.getName().getLocalPart());
        PrintStream printStream = ToolsUtil.createJavaSourceStream(this.destDir, this.packageName, string);
        try {
            StubBase stubBase = (StubBase)GenFactory.create("weblogic.wsee.tools.clientgen.stubgen.StubImpl");
            System.out.println("class name is " + string);
            System.out.println("service class name is " + this.stubInfo.getServiceName());
            System.out.println("Porttype name is " + string2);
            System.out.println("service impl name is " + this.stubInfo.getServiceImplName());
            stubBase.setPackageName(this.packageName);
            stubBase.setClassName(string);
            stubBase.setEndpoint(jsClass);
            stubBase.setPortTypeName(string2);
            stubBase.setOutput(printStream);
            stubBase.setServiceClassName(this.stubInfo.getServiceName());
            stubBase.setPortNameMap(this.stubInfo.getPortNameMap());
            stubBase.setShouldConvertInnerClassString(this.shouldConvertInnerClassString);
            if (jClass != null) {
                stubBase.setCallbackInterface(jClass.getQualifiedName());
                stubBase.setCallback(jClass);
            }
            stubBase.generate();
        }
        catch (ScriptException scriptException) {
            throw new WsBuildException("Service interface generation failed", scriptException);
        }
        finally {
            printStream.close();
        }
    }

    public void generateExceptions(JsService jsService) throws WsBuildException {
    }

    private void init(WsdlService wsdlService) throws WsBuildException {
        if (this.initialized) {
            return;
        }
        if (this.destDir == null) {
            throw new WsBuildException("Destination directory is not set.");
        }
        if (this.packageName == null) {
            throw new WsBuildException("Package name is not set.");
        }
        this.stubInfo = new ProcessInfo.StubInfo(wsdlService);
        this.initialized = true;
    }
}

