/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.ModuleInfo;
import weblogic.wsee.util.IOUtil;

public class JwsArchiveWriter {
    public void process(ModuleInfo moduleInfo) throws WsBuildException {
        String string = moduleInfo.getJwsBuildContext().getDestEncoding();
        try {
            if (!moduleInfo.isWsdlOnly()) {
                if (moduleInfo.getWebServicesBean() != null) {
                    JwsArchiveWriter.writeBean(moduleInfo.getWebServicesBean(), new File(moduleInfo.getOutputDir(), "webservices.xml"), string);
                }
                if (moduleInfo.getWeblogicWebservicesBean() != null) {
                    JwsArchiveWriter.writeBean(moduleInfo.getWeblogicWebservicesBean(), new File(moduleInfo.getOutputDir(), "weblogic-webservices.xml"), string);
                }
                if (moduleInfo.getWebAppBean() != null) {
                    JwsArchiveWriter.writeBean(moduleInfo.getWebAppBean(), new File(moduleInfo.getOutputDir(), "web.xml"), string);
                    if (moduleInfo.getWeblogicWebAppBean() != null) {
                        JwsArchiveWriter.writeBean(moduleInfo.getWeblogicWebAppBean(), new File(moduleInfo.getOutputDir(), "weblogic.xml"), string);
                    }
                }
                if (moduleInfo.getWebservicePolicyRefBean() != null) {
                    JwsArchiveWriter.writeBean(moduleInfo.getWebservicePolicyRefBean(), new File(moduleInfo.getOutputDir(), "weblogic-webservices-policy.xml"), string);
                }
            }
        }
        catch (Exception exception) {
            throw new WsBuildException("Failed to write wsdl", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBean(Object object, File file, String string) throws IOException {
        assert (file != null);
        assert (object != null);
        DescriptorBean descriptorBean = (DescriptorBean)object;
        OutputStream outputStream = IOUtil.createEncodedFileOutputStream(file, string);
        try {
            new EditableDescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), outputStream, string);
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }
}

