/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws;

import com.bea.util.jam.JElement;
import com.bea.util.jam.JSourcePosition;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import weblogic.wsee.tools.logging.LogEvent;

public class JwsLogEvent
extends LogEvent {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle(JwsLogEvent.class.getPackage().getName() + ".strings", Locale.getDefault());
    private String id = null;
    protected boolean verbose = false;

    public JwsLogEvent(JElement jElement, String string, Object ... objectArray) {
        this.id = string;
        JSourcePosition jSourcePosition = jElement.getSourcePosition();
        if (jSourcePosition != null) {
            this.setLine(jSourcePosition.getLine());
            this.setColumn(jSourcePosition.getColumn());
            this.setSourceURI(jSourcePosition.getSourceURI());
        }
        this.setText(JwsLogEvent.buildMessage(string, objectArray));
    }

    public JwsLogEvent(URI uRI, String string, Object ... objectArray) {
        this.id = string;
        this.setSourceURI(uRI);
        this.setText(JwsLogEvent.buildMessage(string, objectArray));
    }

    private static String buildMessage(String string, Object ... objectArray) {
        String string2 = string;
        String string3 = resourceBundle.getString(string);
        if (string3 != null) {
            string2 = MessageFormat.format(string3, objectArray);
        }
        return string2;
    }

    public String getId() {
        return this.id;
    }
}

