/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws;

import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.util.JamUtil;

public class TypesUtil {
    private static List collectionTypes = new ArrayList();

    public static boolean isCollection(JClass jClass) {
        return collectionTypes.contains(jClass.getQualifiedName());
    }

    public static void processReturnTypes(JClass jClass, WebMethodDecl webMethodDecl, int n, ProcessStrategy processStrategy, ReportStrategy reportStrategy) throws WsBuildException {
        JClass jClass2 = webMethodDecl.getJMethod().getReturnType();
        if (jClass2 != null && !jClass2.isVoidType()) {
            TypesUtil.processType(jClass2, webMethodDecl.getWebResult().getTypeClassNames(), webMethodDecl, jClass, n, processStrategy, reportStrategy);
        }
    }

    public static void processParamTypes(JClass jClass, WebMethodDecl webMethodDecl, int n, ProcessStrategy processStrategy, ReportStrategy reportStrategy) throws WsBuildException {
        Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
        while (iterator.hasNext()) {
            WebParamDecl webParamDecl = iterator.next();
            JParameter jParameter = webParamDecl.getJParameter();
            String[] stringArray = webParamDecl.getTypeClassNames();
            TypesUtil.processType(jParameter.getType(), stringArray, webMethodDecl, jClass, n, processStrategy, reportStrategy);
        }
    }

    private static void processType(JClass jClass, String[] stringArray, WebMethodDecl webMethodDecl, JClass jClass2, int n, ProcessStrategy processStrategy, ReportStrategy reportStrategy) throws WsBuildException {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                JClass jClass3 = JamUtil.loadJClass(stringArray[i], jClass.getClassLoader(), true);
                if (jClass3 == null) continue;
                if (jClass3.isUnresolvedType()) {
                    reportStrategy.report(new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "types.unresolved", stringArray[i], webMethodDecl.getMethodName()));
                }
                if (!(jClass.isAssignableFrom(jClass3) || jClass3.isAssignableFrom(jClass) || TypesUtil.isCollection(jClass))) {
                    reportStrategy.report(new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "types.invalid.noRelationship", webMethodDecl.getMethodName(), jClass.getQualifiedName(), jClass3.getQualifiedName()));
                }
                processStrategy.process(jClass2, jClass3, n);
            }
        }
    }

    static {
        collectionTypes.add(Collection.class.getName());
        collectionTypes.add(List.class.getName());
        collectionTypes.add(ArrayList.class.getName());
        collectionTypes.add(LinkedList.class.getName());
        collectionTypes.add(Vector.class.getName());
        collectionTypes.add(Stack.class.getName());
        collectionTypes.add(Set.class.getName());
        collectionTypes.add(TreeSet.class.getName());
        collectionTypes.add(SortedSet.class.getName());
        collectionTypes.add(HashSet.class.getName());
    }

    public static interface ProcessStrategy {
        public void process(JClass var1, JClass var2, int var3);
    }

    public static interface ReportStrategy {
        public void report(JwsLogEvent var1) throws WsBuildException;
    }
}

