/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws;

import com.bea.util.jam.JClass;
import com.bea.util.jam.xml.JamXmlUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import weblogic.descriptor.DescriptorBean;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.WebServiceInfo;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.util.IOUtil;
import weblogic.wsee.util.NamespaceSpecifyingDescriptorManager;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;

public class WebServiceWriter
extends JAXRPCProcessor {
    private File destDir = null;
    private String destEncoding = null;

    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (jAXRPCWebServiceInfo.getWebService().getType() != null) {
            this.destDir = this.moduleInfo.getOutputDir();
        }
        this.destEncoding = this.moduleInfo.getJwsBuildContext().getDestEncoding();
        try {
            this.writeWsdl(jAXRPCWebServiceInfo);
            if (!this.moduleInfo.isWsdlOnly()) {
                this.writeEndpointInterfaces(jAXRPCWebServiceInfo);
                this.writeJam(jAXRPCWebServiceInfo.getWebService());
                this.writeBean(jAXRPCWebServiceInfo.getJavaWsdlMappingBean(), new File(this.destDir, jAXRPCWebServiceInfo.getWebService().getArtifactName() + ".xml"));
            }
        }
        catch (Exception exception) {
            throw new WsBuildException("Failed to write wsdl", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJam(WebServiceDecl webServiceDecl) throws IOException, XMLStreamException {
        String string = this.destEncoding;
        if (string == null) {
            string = "UTF-8";
        }
        File file = new File(this.destDir, webServiceDecl.getArtifactName() + "-annotation.xml");
        Writer writer = IOUtil.createEncodedFileWriter(file, string);
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"");
            writer.write(string);
            writer.write("\"?>\n");
            JamXmlUtils.getInstance().toXml(new JClass[]{webServiceDecl.getJClass()}, writer);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBean(Object object, File file) throws IOException {
        assert (file != null);
        assert (object != null);
        DescriptorBean descriptorBean = (DescriptorBean)object;
        OutputStream outputStream = IOUtil.createEncodedFileOutputStream(file, this.destEncoding);
        try {
            new NamespaceSpecifyingDescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), outputStream, this.destEncoding);
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }

    private void bytesToFile(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ((OutputStream)fileOutputStream).write(byArray);
        ((OutputStream)fileOutputStream).close();
    }

    private void writeEndpointInterfaces(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws IOException {
        WebServiceSEIDecl webServiceSEIDecl = jAXRPCWebServiceInfo.getWebService();
        String string = webServiceSEIDecl.getEndpointInterfaceName();
        File file = new File(this.destDir, string.replace('.', '/') + ".java");
        file.getParentFile().mkdirs();
        this.bytesToFile(file, jAXRPCWebServiceInfo.getEndpointInterface());
    }

    private void writeWsdl(WebServiceInfo webServiceInfo) throws IOException, WsdlException {
        File file = new File(this.destDir, ((WebServiceDecl)webServiceInfo.getWebService()).getWsdlFile());
        file.getParentFile().mkdirs();
        ((WsdlDefinitionsBuilder)webServiceInfo.getDefinitions()).writeToFile(file, this.destEncoding);
    }
}

