/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.build;

import com.bea.util.jam.JClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.ToolsUtil;
import weblogic.wsee.tools.jws.build.JwsInfo;
import weblogic.wsee.tools.jws.decl.port.HttpPort;
import weblogic.wsee.tools.jws.decl.port.HttpsPort;
import weblogic.wsee.tools.jws.decl.port.JmsPort;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.cow.CowReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jws
implements JwsInfo {
    private String fileName = null;
    private List<PortDecl> ports = new ArrayList<PortDecl>();
    private JClass jClass = null;
    private File cowFile = null;
    private CowReader cowReader = null;
    private File srcDir = null;
    private WebServiceType webServiceType = WebServiceType.JAXRPC;
    private boolean isGenerateWsdl = false;
    private boolean isGenerateDescriptors = false;

    public void srcdir(File file) {
        this.srcDir = file;
    }

    public boolean hasSrcDir() {
        return this.srcDir != null;
    }

    public File getAbsoluteFile() {
        return new File(this.srcDir, this.fileName).getAbsoluteFile();
    }

    public void setFile(String string) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("file must not be null.");
        }
        if (!string.endsWith(".java")) {
            throw new IllegalArgumentException("file must be a java source file.");
        }
        this.fileName = ToolsUtil.normalize(string);
    }

    public String getFile() {
        return this.fileName;
    }

    @Override
    public Iterator<PortDecl> getPorts() {
        return this.ports.iterator();
    }

    public void setJClass(JClass jClass) {
        this.jClass = jClass;
    }

    @Override
    public JClass getJClass() {
        return this.jClass;
    }

    public HttpPort createWLHttpTransport() {
        HttpPort httpPort = new HttpPort();
        this.ports.add(httpPort);
        return httpPort;
    }

    public HttpsPort createWLHttpsTransport() {
        HttpsPort httpsPort = new HttpsPort();
        this.ports.add(httpsPort);
        return httpsPort;
    }

    @Override
    public CowReader getCowReader() {
        if (this.cowFile == null) {
            return null;
        }
        if (this.cowReader == null) {
            this.cowReader = CowReader.Factory.newInstance(this.cowFile);
        }
        return this.cowReader;
    }

    public File getCowFile() {
        return this.cowFile;
    }

    public void setCompiledWsdl(File file) {
        this.cowFile = file;
    }

    public JmsPort createWLJmsTransport() {
        JmsPort jmsPort = new JmsPort();
        this.ports.add(jmsPort);
        return jmsPort;
    }

    @Override
    public WebServiceType getType() {
        return this.webServiceType;
    }

    public void setType(String string) {
        this.webServiceType = WebServiceType.valueOf(string);
    }

    @Override
    public boolean isGenerateWsdl() {
        return this.isGenerateWsdl;
    }

    public void setGenerateWsdl(boolean bl) {
        this.isGenerateWsdl = bl;
    }

    @Override
    public boolean isGenerateDescriptors() {
        return this.isGenerateDescriptors;
    }

    public void setGenerateDescriptors(boolean bl) {
        this.isGenerateDescriptors = bl;
    }
}

