/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.build;

import com.bea.util.jam.JElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.ServletMappingBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.anttasks.JwscTask;
import weblogic.wsee.tools.jws.JWSProcessor;
import weblogic.wsee.tools.jws.JwsArchiveWriter;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.ModuleInfo;
import weblogic.wsee.tools.jws.WebServiceInfo;
import weblogic.wsee.tools.jws.WebServiceInfoFactory;
import weblogic.wsee.tools.jws.build.CompileException;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.jws.ejb.EjbGenInvoker;
import weblogic.wsee.tools.jws.process.JWSProcessorFactory;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.DescriptorBeanUtil;
import weblogic.wsee.util.JAXWSClassLoaderFactory;
import weblogic.wsee.util.UniqueNameSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JwsCompiler
implements ModuleInfo {
    private JwsBuildContext ctx = null;
    private boolean wsdlOnly = false;
    private boolean generateWsdl = false;
    private boolean generateDescriptors = false;
    private File outputDir = null;
    private WebAppBean webAppBean = null;
    private WeblogicWebAppBean weblogicWebAppBean = null;
    private WebservicePolicyRefBean webservicePolicyRefBean = null;
    private WebservicesBean webServicesBean = null;
    private WeblogicWebservicesBean weblogicWebServicesBean = null;
    private List<File> descriptors = new ArrayList<File>();
    private File[] bindingFiles;
    private boolean jaxRPCWrappedArrayStyle;
    private boolean upperCasePropName = true;
    private boolean localElementDefaultRequired = true;
    private boolean localElementDefaultNillable = true;
    private JwscTask owningTask;
    private List<WebServiceDecl> webServices = new ArrayList<WebServiceDecl>();

    public JwsCompiler(JwsBuildContext jwsBuildContext) {
        this(jwsBuildContext, null);
    }

    public JwsCompiler(JwsBuildContext jwsBuildContext, JwscTask jwscTask) {
        if (jwsBuildContext == null) {
            throw new NullPointerException("ctx must not be null");
        }
        this.owningTask = jwscTask;
        this.ctx = jwsBuildContext;
    }

    @Override
    public JwsBuildContext getJwsBuildContext() {
        return this.ctx;
    }

    @Override
    public JwscTask getOwningTask() {
        return this.owningTask;
    }

    @Override
    public boolean isWsdlOnly() {
        return this.wsdlOnly;
    }

    public void setWsdlOnly(boolean bl) {
        this.wsdlOnly = bl;
    }

    @Override
    public boolean isGenerateWsdl() {
        return this.generateWsdl;
    }

    public void setGenerateWsdl(boolean bl) {
        this.generateWsdl = bl;
    }

    @Override
    public boolean isGenerateDescriptors() {
        return this.generateDescriptors;
    }

    @Override
    public void setGenerateDescriptors(boolean bl) {
        this.generateDescriptors = bl;
    }

    @Override
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File file) {
        if (file == null) {
            throw new NullPointerException("outputDir");
        }
        this.outputDir = file;
    }

    @Override
    public List<WebServiceDecl> getWebServices() {
        return Collections.unmodifiableList(this.webServices);
    }

    public void addWebService(WebServiceDecl webServiceDecl) {
        if (webServiceDecl == null) {
            throw new NullPointerException("webService");
        }
        this.webServices.add(webServiceDecl);
    }

    @Override
    public WebservicesBean getWebServicesBean() {
        return this.webServicesBean;
    }

    @Override
    public void setWebServicesBean(WebservicesBean webservicesBean) {
        this.webServicesBean = webservicesBean;
    }

    @Override
    public WeblogicWebservicesBean getWeblogicWebservicesBean() {
        return this.weblogicWebServicesBean;
    }

    @Override
    public void setWeblogicWebservicesBean(WeblogicWebservicesBean weblogicWebservicesBean) {
        this.weblogicWebServicesBean = weblogicWebservicesBean;
    }

    @Override
    public WebAppBean getWebAppBean() {
        return this.webAppBean;
    }

    @Override
    public void setWebAppBean(WebAppBean webAppBean) {
        this.webAppBean = webAppBean;
    }

    @Override
    public WeblogicWebAppBean getWeblogicWebAppBean() {
        return this.weblogicWebAppBean;
    }

    @Override
    public void setWeblogicWebAppBean(WeblogicWebAppBean weblogicWebAppBean) {
        this.weblogicWebAppBean = weblogicWebAppBean;
    }

    @Override
    public WebservicePolicyRefBean getWebservicePolicyRefBean() {
        return this.webservicePolicyRefBean;
    }

    @Override
    public void setWebservicePolicyRefBean(WebservicePolicyRefBean webservicePolicyRefBean) {
        this.webservicePolicyRefBean = webservicePolicyRefBean;
    }

    private void addDescriptor(DescriptorBean descriptorBean) {
        if (descriptorBean == null) {
            throw new NullPointerException("bean");
        }
        if (descriptorBean instanceof WeblogicWebAppBean) {
            this.setWeblogicWebAppBean((WeblogicWebAppBean)descriptorBean);
        } else if (descriptorBean instanceof WebAppBean) {
            this.setWebAppBean((WebAppBean)descriptorBean);
        } else {
            throw new IllegalArgumentException(descriptorBean.getClass().getName() + " not supported");
        }
    }

    public void addDescriptor(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " does not exist");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is a directory");
        }
        this.addDescriptor(DescriptorBeanUtil.loadWebDescriptor(file));
        this.descriptors.add(file);
    }

    public boolean isEjb() {
        if (this.webServices.isEmpty()) {
            return false;
        }
        WebServiceDecl webServiceDecl = this.webServices.get(0);
        if (!(webServiceDecl instanceof WebServiceSEIDecl)) {
            return false;
        }
        return ((WebServiceSEIDecl)webServiceDecl).isEjb();
    }

    public void validate() throws WsBuildException {
        this.validateOutputDir();
        this.validateDescriptors();
        if (!this.webServices.isEmpty()) {
            this.validateBacking();
            this.validateServicesQName();
            this.validatePortTypesQName();
            this.validatePortsQName();
            this.validatePortsName();
            this.validateContextPath();
            this.validateDocWrapped();
        }
        this.validateServiceUris();
        this.validateContextPathAndServiceUris();
    }

    private void validateServicesQName() {
        HashMap<QName, String> hashMap = new HashMap<QName, String>();
        for (WebServiceDecl webServiceDecl : this.webServices) {
            String string;
            if (webServiceDecl.isWlw81UpgradedService()) continue;
            QName qName = webServiceDecl.getServiceQName();
            if (hashMap.containsKey(qName) && ((string = (String)hashMap.get(qName)) == null || !string.equals(webServiceDecl.getWsdlLocation()))) {
                this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webServiceDecl.getJClass(), "unique.qname.service", qName));
            }
            hashMap.put(qName, webServiceDecl.getWsdlLocation());
        }
    }

    private void validatePortTypesQName() {
        HashMap<QName, String> hashMap = new HashMap<QName, String>();
        for (WebServiceDecl webServiceDecl : this.webServices) {
            String string;
            QName qName = webServiceDecl.getPortTypeQName();
            if (hashMap.containsKey(qName) && ((string = (String)hashMap.get(qName)) == null || !string.equals(webServiceDecl.getWsdlLocation()))) {
                this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webServiceDecl.getJClass(), "unique.qname.porttype", qName));
            }
            hashMap.put(qName, webServiceDecl.getWsdlLocation());
        }
    }

    private void validatePortsQName() {
        HashSet<QName> hashSet = new HashSet<QName>();
        for (WebServiceDecl webServiceDecl : this.webServices) {
            String string = webServiceDecl.getTargetNamespace();
            Iterator<PortDecl> iterator = webServiceDecl.getPorts();
            while (iterator.hasNext()) {
                PortDecl portDecl = iterator.next();
                QName qName = new QName(string, portDecl.getPortName());
                if (hashSet.contains(qName)) {
                    this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webServiceDecl.getJClass(), "unique.qname.port", qName));
                }
                hashSet.add(qName);
            }
        }
    }

    private void validatePortsName() {
        HashSet<String> hashSet = new HashSet<String>();
        for (WebServiceDecl webServiceDecl : this.webServices) {
            Iterator<PortDecl> iterator = webServiceDecl.getPorts();
            while (iterator.hasNext()) {
                PortDecl portDecl = iterator.next();
                String string = portDecl.getPortName();
                if (hashSet.contains(string)) {
                    this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webServiceDecl.getJClass(), "unique.name.port", string));
                }
                hashSet.add(string);
            }
        }
    }

    private void validateDescriptors() throws WsBuildException {
        for (File file : this.descriptors) {
            try {
                for (Object e : DescriptorBeanUtil.validateBean(file)) {
                    this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent(file.toURI(), "descriptor.invalid", e));
                }
            }
            catch (IOException iOException) {
                throw new WsBuildException(iOException);
            }
        }
    }

    private void validateOutputDir() throws WsBuildException {
        if (this.outputDir == null) {
            throw new WsBuildException("'outputDir' not specified");
        }
        if (this.outputDir.exists()) {
            this.ctx.getLogger().log(EventLevel.VERBOSE, "JWS output directory " + this.outputDir + " already exists.");
            if (!this.outputDir.isDirectory()) {
                throw new WsBuildException("'outputDir' must be a directory");
            }
        }
    }

    private void validateBacking() {
        boolean bl = this.webServices.get(0).isEjb();
        for (WebServiceDecl webServiceDecl : this.webServices) {
            if (bl == webServiceDecl.isEjb()) continue;
            this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webServiceDecl.getJClass(), "type.backing.mixed", new Object[0]));
        }
    }

    private void validateContextPath() {
        if (!this.webServices.get(0).isEjb()) {
            String string = null;
            for (WebServiceDecl webServiceDecl : this.webServices) {
                Iterator<PortDecl> iterator = webServiceDecl.getPorts();
                while (iterator.hasNext()) {
                    PortDecl portDecl = iterator.next();
                    assert (portDecl.getContextPath() != null) : "Port " + portDecl + " does not have a context path";
                    if (string == null) {
                        string = portDecl.getContextPath();
                        continue;
                    }
                    if (string.equals(portDecl.getContextPath())) continue;
                    this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webServiceDecl.getJClass(), "port.invalidContextPath", webServiceDecl.getServiceQName().getLocalPart(), portDecl.getContextPath(), string));
                }
            }
        }
    }

    private void validateDocWrapped() {
    }

    private void validateContextPathAndServiceUris() {
        HashSet hashSet = new HashSet();
        for (WebServiceDecl webServiceDecl : this.webServices) {
            HashSet<String> hashSet2 = new HashSet<String>();
            Iterator<PortDecl> iterator = webServiceDecl.getPorts();
            while (iterator.hasNext()) {
                PortDecl portDecl = iterator.next();
                String string = portDecl.getNormalizedPath();
                if (hashSet.contains(string)) {
                    this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webServiceDecl.getJClass(), "port.uri.alreadyInUse", portDecl.getContextPath(), portDecl.getServiceUri(), webServiceDecl.getServiceQName().getLocalPart()));
                }
                hashSet2.add(string);
            }
            hashSet.addAll(hashSet2);
        }
    }

    private void validateServiceUris() {
        if (!this.isEjb() && this.getWebAppBean() != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (ServletMappingBean object : this.getWebAppBean().getServletMappings()) {
                String[] stringArray = object.getUrlPatterns();
                if (stringArray == null || stringArray.length <= 0) continue;
                hashSet.addAll(Arrays.asList(stringArray));
            }
            for (WebServiceDecl webServiceDecl : this.webServices) {
                Iterator<PortDecl> iterator = webServiceDecl.getPorts();
                while (iterator.hasNext()) {
                    PortDecl portDecl = iterator.next();
                    if (!hashSet.contains(portDecl.getServiceUri())) continue;
                    this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webServiceDecl.getJClass(), "port.serviceUri.alreadyInUse", portDecl.getServiceUri(), webServiceDecl.getServiceQName().getLocalPart()));
                }
            }
        }
    }

    public void compile() throws WsBuildException {
        if (!this.getOutputDir().exists() && !this.getOutputDir().mkdirs()) {
            throw new WsBuildException("Unable to create JWS output directory " + this.getOutputDir().getAbsolutePath());
        }
        this.validateDescriptors();
        this.buildWebServices();
        this.generateEJBs();
        JwsArchiveWriter jwsArchiveWriter = new JwsArchiveWriter();
        jwsArchiveWriter.process(this);
    }

    private void generateEJBs() throws WsBuildException {
        if (this.isEjb()) {
            if (this.webServices.isEmpty()) {
                return;
            }
            if (this.webServices.get(0).getType() == WebServiceType.JAXRPC) {
                EjbGenInvoker ejbGenInvoker = new EjbGenInvoker();
                ejbGenInvoker.process(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildWebServices() throws CompileException, WsBuildException {
        UniqueNameSet uniqueNameSet = new UniqueNameSet();
        JWSProcessor jWSProcessor = JWSProcessorFactory.createProcessor();
        jWSProcessor.init(this);
        for (WebServiceDecl webServiceDecl : this.webServices) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (WebServiceType.JAXWS.equals((Object)webServiceDecl.getType())) {
                JAXWSClassLoaderFactory.getInstance().setContextLoader(classLoader);
            }
            try {
                webServiceDecl.setArtifactName(uniqueNameSet.add(webServiceDecl.getServiceQName().getLocalPart()));
                try {
                    WebServiceInfo webServiceInfo = WebServiceInfoFactory.newInstance(this, webServiceDecl, this.bindingFiles);
                    jWSProcessor.process(webServiceInfo);
                }
                catch (WsBuildException wsBuildException) {
                    this.ctx.getLogger().log(EventLevel.ERROR, wsBuildException.getMessage());
                    throw new CompileException(webServiceDecl, (Throwable)wsBuildException);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        jWSProcessor.finish();
    }

    public void setBindingFiles(File[] fileArray) {
        this.bindingFiles = fileArray;
    }

    public void setJaxRPCWrappedArrayStyle(boolean bl) {
        this.jaxRPCWrappedArrayStyle = bl;
    }

    @Override
    public boolean isJaxRPCWrappedArrayStyle() {
        return this.jaxRPCWrappedArrayStyle;
    }

    public void cleanup() {
        if (this.webServices != null) {
            this.webServices.clear();
            this.webServices = null;
        }
        this.bindingFiles = null;
        this.descriptors = null;
        this.webAppBean = null;
        this.weblogicWebAppBean = null;
        this.webservicePolicyRefBean = null;
        this.webServicesBean = null;
        this.weblogicWebServicesBean = null;
    }

    public void setUpperCasePropName(boolean bl) {
        this.upperCasePropName = bl;
    }

    @Override
    public boolean isUpperCasePropName() {
        return this.upperCasePropName;
    }

    public void setLocalElementDefaultRequired(boolean bl) {
        this.localElementDefaultRequired = bl;
    }

    @Override
    public boolean isLocalElementDefaultRequired() {
        return this.localElementDefaultRequired;
    }

    public void setLocalElementDefaultNillable(boolean bl) {
        this.localElementDefaultNillable = bl;
    }

    @Override
    public boolean isLocalElementDefaultNillable() {
        return this.localElementDefaultNillable;
    }
}

