/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.callback;

import com.bea.util.jam.JClass;
import javax.xml.namespace.QName;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.bind.TypeFamily;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.clientgen.ClientGenFactory;
import weblogic.wsee.tools.clientgen.jaxrpc.ClientGenImpl;
import weblogic.wsee.tools.clientgen.jaxrpc.Options;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlPartnerLinkType;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;

public class CallbackGenerator
extends JAXRPCProcessor {
    private JAXRPCWebServiceInfo webServiceInfo;

    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (this.moduleInfo.isWsdlOnly()) {
            return;
        }
        if (jAXRPCWebServiceInfo.getWebService().getCallbackService() == null) {
            return;
        }
        this.webServiceInfo = jAXRPCWebServiceInfo;
        JClass jClass = jAXRPCWebServiceInfo.getWebService().getCallbackService().getJClass();
        try {
            WsdlPartnerLinkType wsdlPartnerLinkType = (WsdlPartnerLinkType)jAXRPCWebServiceInfo.getDefinitions().getExtension("PartnerLinkType");
            assert (wsdlPartnerLinkType != null) : "Partner link type not found in wsdl";
            QName qName = wsdlPartnerLinkType.getPortTypeName("Callback");
            this.callbackClientgen(qName, jAXRPCWebServiceInfo.getWebService().getJClass(), jClass);
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException(wsdlException.getMessage(), wsdlException);
        }
    }

    private void callbackClientgen(QName qName, JClass jClass, JClass jClass2) throws WsBuildException {
        WsdlService wsdlService = this.findCallbackService(qName);
        Options options = new Options();
        options.setServiceName(wsdlService.getName().getLocalPart());
        options.setTypeFamily(TypeFamily.getTypeFamilyForClass(jClass2));
        options.setWriteJavaTypes(false);
        options.setJaxRPCWrappedArrayStyle(false);
        options.setGenerateAsyncMethods(false);
        options.setUseJaxRpcRules(false);
        ClientGenImpl clientGenImpl = (ClientGenImpl)ClientGenFactory.newInstance(WebServiceType.JAXRPC);
        clientGenImpl.setWsdlDefinitions(this.webServiceInfo.getDefinitions());
        clientGenImpl.setCallbackJClass(jClass2);
        clientGenImpl.setWebServiceJClass(jClass);
        clientGenImpl.setDestDir(this.moduleInfo.getOutputDir());
        clientGenImpl.setPackageName(this.webServiceInfo.getWebService().getPackageName() + ".callbackclient");
        clientGenImpl.setOptions(options);
        clientGenImpl.execute();
    }

    private WsdlService findCallbackService(QName qName) {
        for (WsdlService wsdlService : this.webServiceInfo.getDefinitions().getServices().values()) {
            for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
                if (!wsdlPort.getPortType().getName().equals(qName)) continue;
                return wsdlService;
            }
        }
        throw new AssertionError((Object)("Service with PortType " + qName + " is " + "not found in wsdl."));
    }
}

