/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.callback;

import java.util.Iterator;
import javax.xml.namespace.QName;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlPartnerLinkType;
import weblogic.wsee.wsdl.WsdlPortType;

public class CallbackReceiveProcessor
extends JAXRPCProcessor {
    private JAXRPCWebServiceInfo webServiceInfo;

    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (jAXRPCWebServiceInfo.getWebService().getCallbackService() == null) {
            return;
        }
        this.webServiceInfo = jAXRPCWebServiceInfo;
        try {
            this.addPartnerLink(jAXRPCWebServiceInfo.getWebService().getCallbackService().getName());
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException(wsdlException.getMessage(), wsdlException);
        }
    }

    private WsdlPartnerLinkType addPartnerLink(String string) throws WsdlException {
        WsdlDefinitions wsdlDefinitions = this.webServiceInfo.getDefinitions();
        WsdlPartnerLinkType wsdlPartnerLinkType = new WsdlPartnerLinkType(new QName(wsdlDefinitions.getTargetNamespace(), string));
        Iterator<? extends WsdlPortType> iterator = wsdlDefinitions.getPortTypes().values().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("There is no portType in wsdl");
        }
        WsdlPortType wsdlPortType = iterator.next();
        wsdlPartnerLinkType.addRole("Service", wsdlPortType.getName());
        if (!iterator.hasNext()) {
            throw new IllegalStateException("There is only one portType in wsdl partnerLinkType needs two portType.");
        }
        wsdlPortType = iterator.next();
        wsdlPartnerLinkType.addRole("Callback", wsdlPortType.getName());
        if (iterator.hasNext()) {
            throw new IllegalStateException("Failed to create a partnerLinkType. There are more than two portTypes in wsdl.");
        }
        wsdlPartnerLinkType.attach(wsdlDefinitions);
        return wsdlPartnerLinkType;
    }
}

