/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.codegen;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.internal.elements.ClassImpl;

public class Annotation2Source {
    private Annotation2Source() {
    }

    public static String getAnnotationsString(JAnnotation[] jAnnotationArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < jAnnotationArray.length; ++i) {
            stringBuffer.append(Annotation2Source.getAnnotationString(jAnnotationArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String getAnnotationString(JAnnotation jAnnotation) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = jAnnotation.getQualifiedName();
        if (string.startsWith("weblogic.") || string.startsWith("com.bea.") || string.startsWith("javax.jws.")) {
            stringBuffer.append("@" + string + "(");
            JAnnotationValue[] jAnnotationValueArray = jAnnotation.getValues();
            for (int i = 0; i < jAnnotationValueArray.length; ++i) {
                stringBuffer.append(jAnnotationValueArray[i].getName());
                stringBuffer.append("=");
                stringBuffer.append(Annotation2Source.getValueString(jAnnotationValueArray[i]));
                if (i >= jAnnotationValueArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")\n");
        }
        return stringBuffer.toString();
    }

    private static String getValueString(JAnnotationValue jAnnotationValue) {
        JClass jClass = jAnnotationValue.getType();
        StringBuffer stringBuffer = new StringBuffer();
        if (jClass.isArrayType()) {
            Annotation2Source.getArrayValueString(stringBuffer, jAnnotationValue);
        } else if (Annotation2Source.isEnumType(jAnnotationValue.getType())) {
            stringBuffer.append(Annotation2Source.getSourceTypeName(jClass) + "." + jAnnotationValue.asString());
        } else {
            if (jClass.isAnnotationType()) {
                throw new Error("NYI - use annotation as annotation value");
            }
            if (String.class.getName().equals(jClass.getQualifiedName())) {
                stringBuffer.append("\"" + jAnnotationValue.asString() + "\"");
            } else {
                stringBuffer.append(jAnnotationValue.asString());
            }
        }
        return stringBuffer.toString();
    }

    private static String getSourceTypeName(JClass jClass) {
        return jClass.getContainingPackage().getQualifiedName() + "." + jClass.getSimpleName().replace("$", ".");
    }

    private static void getArrayValueString(StringBuffer stringBuffer, JAnnotationValue jAnnotationValue) {
        JClass jClass = jAnnotationValue.getType().getArrayComponentType();
        stringBuffer.append("{");
        if (jClass.isAnnotationType()) {
            JAnnotation[] jAnnotationArray = jAnnotationValue.asAnnotationArray();
            if (jAnnotationArray != null) {
                for (int i = 0; i < jAnnotationArray.length; ++i) {
                    JAnnotation jAnnotation = jAnnotationArray[i];
                    stringBuffer.append(Annotation2Source.getAnnotationString(jAnnotation));
                    if (i >= jAnnotationArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            }
        } else {
            if (Annotation2Source.isEnumType(jClass)) {
                throw new Error("NYI, enum array is not suppported");
            }
            if (String.class.getName().equals(jClass.getQualifiedName())) {
                String[] stringArray = jAnnotationValue.asStringArray();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append("\"" + stringArray[i] + "\"");
                    if (i >= stringArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            } else {
                throw new AssertionError((Object)("Annotation array of " + jClass.getQualifiedName() + " is not supported."));
            }
        }
        stringBuffer.append("}");
    }

    private static boolean isEnumType(JClass jClass) {
        if (!(jClass instanceof ClassImpl)) {
            return false;
        }
        return ((ClassImpl)jClass).isEnumType();
    }
}

