/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.context;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.utils.classloaders.ClasspathClassLoader;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.logging.CompositeLogger;
import weblogic.wsee.tools.logging.CountLogger;
import weblogic.wsee.tools.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JwsBuildContextImpl
implements JwsBuildContext {
    public static final String DEFAULT_DEST_ENCODING = "UTF-8";
    public static final String DEFAULT_WSDL_ENCODING = "UTF-8";
    private JwsBuildContext.Task task = JwsBuildContext.Task.JWSC;
    private CompositeLogger loggers = new CompositeLogger();
    private CountLogger countLogger = new CountLogger();
    private String srcInputEncoding = null;
    private String destEncoding = "UTF-8";
    private Map properties = new HashMap();
    private ClassLoader classLoader = null;
    private String[] classpath = null;
    private String[] sourcepath = null;
    private Collection<File> clientGenOutputDirs = new ArrayList<File>();

    public JwsBuildContextImpl() {
        this.loggers.addLogger(this.countLogger);
    }

    @Override
    public Logger getLogger() {
        return this.loggers;
    }

    @Override
    public boolean isInError() {
        return this.countLogger.getErrorCount() > 0;
    }

    @Override
    public List<String> getErrorMsgs() {
        return this.countLogger.getErrorMsgs();
    }

    @Override
    public JwsBuildContext.Task getTask() {
        return this.task;
    }

    @Override
    public String getSrcEncoding() {
        return this.srcInputEncoding;
    }

    @Override
    public String getDestEncoding() {
        return this.destEncoding;
    }

    @Override
    public String getCodegenOutputEncoding() {
        return this.srcInputEncoding;
    }

    public void setSrcEncoding(String string) {
        this.srcInputEncoding = string;
    }

    public void setDestEncoding(String string) {
        this.destEncoding = string == null ? "UTF-8" : string;
    }

    @Override
    public Collection<File> getClientGenOutputDirs() {
        return this.clientGenOutputDirs;
    }

    public void addLogger(Logger logger) {
        this.loggers.addLogger(logger);
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    public void setTask(JwsBuildContext.Task task) {
        this.task = task;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new ClasspathClassLoader();
        }
        return this.classLoader;
    }

    @Override
    public String[] getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String[] stringArray, ClassLoaderFactory classLoaderFactory) {
        this.classpath = stringArray;
        this.classLoader = classLoaderFactory.newInstance(stringArray);
    }

    public void setClasspath(String[] stringArray) {
        this.setClasspath(stringArray, new ClasspathClassLoaderFactory());
    }

    @Override
    public String[] getSourcepath() {
        return this.sourcepath;
    }

    public void setSourcepath(String[] stringArray) {
        this.sourcepath = stringArray;
    }

    public static class ClasspathClassLoaderFactory
    implements ClassLoaderFactory {
        public ClassLoader newInstance(String[] stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(File.pathSeparatorChar);
                }
                stringBuilder.append(string);
            }
            return new ClasspathClassLoader(stringBuilder.toString(), JwsBuildContextImpl.class.getClassLoader());
        }
    }

    public static interface ClassLoaderFactory {
        public ClassLoader newInstance(String[] var1);
    }
}

