/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.conversation;

import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.conversation.wsdl.ConversationWsdlPhase;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;

public class ConversationProcessor
extends JAXRPCProcessor {
    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (!jAXRPCWebServiceInfo.getWebService().isConversational()) {
            return;
        }
        WsdlService wsdlService = jAXRPCWebServiceInfo.getDefinitions().getServices().get(jAXRPCWebServiceInfo.getWebService().getServiceQName());
        if (wsdlService == null) {
            throw new WsBuildException("Wsdl service " + jAXRPCWebServiceInfo.getWebService().getServiceQName() + " not found");
        }
        for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
            Iterator<WebMethodDecl> iterator = jAXRPCWebServiceInfo.getWebService().getWebMethods();
            while (iterator.hasNext()) {
                WebMethodDecl webMethodDecl = iterator.next();
                String string = wsdlPort.getBinding().getPortType().getName().getNamespaceURI();
                WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(new QName(string, webMethodDecl.getName()));
                ConversationPhase conversationPhase = ConversationPhase.valueOf(webMethodDecl.getConverationPhase().toString().toLowerCase(Locale.ENGLISH));
                ConversationWsdlPhase.attach(wsdlBindingOperation, conversationPhase);
            }
        }
    }
}

