/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl;

import com.bea.util.jam.JAnnotation;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import weblogic.jws.Policy;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;

public class PolicyDecl {
    private boolean attachToWsdl = false;
    private String uri = null;
    private URI policyURI = null;
    private Policy.Direction direction = Policy.Direction.both;
    private boolean builtInPolicy = false;
    private String uriError = null;

    PolicyDecl(File file, JAnnotation jAnnotation) {
        this.attachToWsdl = JamUtil.getAnnotationBooleanValue(jAnnotation, "attachToWsdl", false);
        this.uri = JamUtil.getAnnotationStringValue(jAnnotation, "uri");
        this.direction = JamUtil.getAnnotationEnumValue(jAnnotation, "direction", Policy.Direction.class, Policy.Direction.both);
        if (StringUtil.isEmpty(this.uri)) {
            this.uriError = "uri must not be empty.";
        } else {
            if (this.uri.startsWith("policy:")) {
                this.uri = PolicyDecl.baseName(this.uri);
                this.builtInPolicy = true;
            }
            if (this.isRelativeUri()) {
                if (file != null) {
                    File file2 = new File(file, this.uri);
                    this.uri = file2.getName();
                    this.policyURI = file2.toURI();
                } else {
                    this.uriError = "Unable to use relative path with class file.";
                }
            } else {
                try {
                    this.policyURI = new URI(this.uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.uriError = uRISyntaxException.getMessage();
                }
            }
        }
    }

    public boolean isRelativeUri() {
        if (this.uri.indexOf(58) > 0) {
            return false;
        }
        return !this.uri.startsWith("/");
    }

    public boolean isAttachToWsdl() {
        return this.attachToWsdl;
    }

    public String getUri() {
        return this.uri;
    }

    public String getUriWithoutExt() {
        return PolicyDecl.baseName(this.uri);
    }

    public String getBuiltInUriWithoutPrefix() {
        if (this.builtInPolicy) {
            return this.uri.substring("policy:".length());
        }
        throw new RuntimeException("The current PolicyDecl is not a built-in typed!");
    }

    public Policy.Direction getDirection() {
        return this.direction;
    }

    public boolean isBuiltInPolicy() {
        return this.builtInPolicy;
    }

    public URI getPolicyURI() {
        return this.policyURI;
    }

    public String getUriError() {
        return this.uriError;
    }

    private static String baseName(String string) {
        if (string.endsWith(".xml")) {
            string = string.substring(0, string.lastIndexOf(".xml"));
        }
        return string;
    }
}

