/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import javax.jws.soap.SOAPBinding;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.util.JamUtil;

public class SOAPBindingDecl {
    public static final String SOAP_HTTP_TRANSPORT = "http://schemas.xmlsoap.org/soap/http";
    private SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
    private SOAPBinding.Use use = SOAPBinding.Use.LITERAL;
    private SOAPBinding.ParameterStyle parameterStyle = SOAPBinding.ParameterStyle.WRAPPED;

    SOAPBindingDecl(JwsBuildContext jwsBuildContext, JClass jClass) {
        JAnnotation jAnnotation = jClass.getAnnotation(SOAPBinding.class);
        SOAPBinding.Style style = jwsBuildContext.getTask() == JwsBuildContext.Task.JWSC ? SOAPBinding.Style.DOCUMENT : SOAPBinding.Style.RPC;
        SOAPBinding.Use use = jwsBuildContext.getTask() == JwsBuildContext.Task.JWSC ? SOAPBinding.Use.LITERAL : SOAPBinding.Use.ENCODED;
        SOAPBinding.ParameterStyle parameterStyle = jwsBuildContext.getTask() == JwsBuildContext.Task.JWSC ? SOAPBinding.ParameterStyle.WRAPPED : SOAPBinding.ParameterStyle.BARE;
        this.style = style;
        this.use = use;
        this.parameterStyle = parameterStyle;
        if (jAnnotation != null) {
            this.style = JamUtil.getAnnotationEnumValue(jAnnotation, "style", SOAPBinding.Style.class, style);
            this.use = JamUtil.getAnnotationEnumValue(jAnnotation, "use", SOAPBinding.Use.class, use);
            this.parameterStyle = JamUtil.getAnnotationEnumValue(jAnnotation, "parameterStyle", SOAPBinding.ParameterStyle.class, parameterStyle);
        }
        if (this.style == SOAPBinding.Style.RPC) {
            this.parameterStyle = SOAPBinding.ParameterStyle.BARE;
        }
        if (this.parameterStyle == null) {
            this.parameterStyle = this.style == SOAPBinding.Style.DOCUMENT ? parameterStyle : SOAPBinding.ParameterStyle.BARE;
        }
    }

    public SOAPBindingDecl(JAnnotation jAnnotation) {
        this.style = JamUtil.getAnnotationEnumValue(jAnnotation, "style", SOAPBinding.Style.class, this.style);
        this.use = JamUtil.getAnnotationEnumValue(jAnnotation, "use", SOAPBinding.Use.class, this.use);
        this.parameterStyle = JamUtil.getAnnotationEnumValue(jAnnotation, "parameterStyle", SOAPBinding.ParameterStyle.class, this.parameterStyle);
    }

    public SOAPBinding.Style getStyle() {
        return this.style;
    }

    public SOAPBinding.Use getUse() {
        return this.use;
    }

    public SOAPBinding.ParameterStyle getParameterStyle() {
        return this.parameterStyle;
    }

    public boolean isDocumentStyle() {
        return this.style.equals((Object)SOAPBinding.Style.DOCUMENT);
    }

    public boolean isWrapped() {
        return this.parameterStyle.equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
    }

    public boolean isLiteral() {
        return this.use.equals((Object)SOAPBinding.Use.LITERAL);
    }

    public boolean isDocLiteralWrapped() {
        return this.isDocumentStyle() && this.isLiteral() && this.isWrapped();
    }

    public boolean isDocLiteralBare() {
        return this.isDocumentStyle() && this.isLiteral() && !this.isWrapped();
    }
}

