/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import weblogic.jws.Conversation;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.PolicyDecl;
import weblogic.wsee.tools.jws.decl.PolicyDeclBuilder;
import weblogic.wsee.tools.jws.decl.SOAPBindingDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebResultDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMethodDecl {
    private String operationName = null;
    private String methodName = null;
    private String action = null;
    private boolean oneway = false;
    private List<WebParamDecl> webParams = new ArrayList<WebParamDecl>();
    private WebResultDecl webResult = null;
    private WebServiceSEIDecl webService = null;
    private Conversation.Phase converationPhase = null;
    private List<PolicyDecl> poilices = new ArrayList<PolicyDecl>();
    private JMethod sbMethod = null;
    private SOAPBindingDecl soapBinding;
    private JwsBuildContext context;

    public WebMethodDecl(JwsBuildContext jwsBuildContext, WebServiceSEIDecl webServiceSEIDecl, JMethod jMethod, JMethod jMethod2) {
        JAnnotation jAnnotation;
        this.context = jwsBuildContext;
        this.webService = webServiceSEIDecl;
        this.sbMethod = jMethod2;
        JAnnotation jAnnotation2 = jMethod.getAnnotation(WebMethod.class);
        this.methodName = jMethod.getSimpleName();
        this.oneway = jMethod.getAnnotation(Oneway.class) != null;
        this.operationName = JamUtil.getAnnotationStringValue(jAnnotation2, "operationName");
        if (StringUtil.isEmpty(this.operationName)) {
            this.operationName = this.methodName;
        }
        this.action = JamUtil.getAnnotationStringValue(jAnnotation2, "action");
        if (StringUtil.isEmpty(this.action)) {
            this.action = "";
        }
        if ((jAnnotation = this.sbMethod.getAnnotation(Conversation.class)) != null) {
            this.converationPhase = JamUtil.getAnnotationEnumValue(jAnnotation, "value", Conversation.Phase.class, Conversation.Phase.CONTINUE);
        } else if (webServiceSEIDecl.isConversational()) {
            this.converationPhase = Conversation.Phase.CONTINUE;
        }
        this.poilices.addAll(PolicyDeclBuilder.build(webServiceSEIDecl.getSourceFile(), (JAnnotatedElement)jMethod2));
        this.soapBinding = WebMethodDecl.getSoapBinding(jMethod, webServiceSEIDecl);
        this.webResult = new WebResultDecl(jwsBuildContext, jMethod, this);
    }

    private static SOAPBindingDecl getSoapBinding(JMethod jMethod, WebServiceSEIDecl webServiceSEIDecl) {
        JAnnotation jAnnotation = jMethod.getAnnotation(SOAPBinding.class);
        if (jAnnotation == null) {
            jAnnotation = jMethod.getAnnotation(weblogic.jws.soap.SOAPBinding.class);
        }
        SOAPBindingDecl sOAPBindingDecl = null;
        sOAPBindingDecl = jAnnotation != null ? new SOAPBindingDecl(jAnnotation) : webServiceSEIDecl.getSoapBinding();
        return sOAPBindingDecl;
    }

    public JMethod getJMethod() {
        return this.sbMethod;
    }

    public String getName() {
        return this.operationName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void addWebParam(WebParamDecl webParamDecl) {
        if (webParamDecl == null) {
            throw new IllegalArgumentException("webParamaDecl must not be null.");
        }
        this.webParams.add(webParamDecl);
    }

    public Iterator<WebParamDecl> getWebParams() {
        return this.webParams.iterator();
    }

    public Iterator<WebParamDecl> getHeaderParams() {
        return this.getParamsInternal(true);
    }

    public Iterator<WebParamDecl> getNonHeaderParams() {
        return this.getParamsInternal(false);
    }

    public List<WebParamDecl> getParameters(WebParam.Mode mode) {
        ArrayList<WebParamDecl> arrayList = new ArrayList<WebParamDecl>();
        Iterator<WebParamDecl> iterator = this.getNonHeaderParams();
        while (iterator.hasNext()) {
            WebParamDecl webParamDecl = iterator.next();
            if (webParamDecl.getMode() == mode) {
                arrayList.add(webParamDecl);
                continue;
            }
            if (webParamDecl.getMode() != WebParam.Mode.INOUT) continue;
            arrayList.add(webParamDecl);
        }
        return arrayList;
    }

    private Iterator<WebParamDecl> getParamsInternal(boolean bl) {
        ArrayList<WebParamDecl> arrayList = new ArrayList<WebParamDecl>();
        for (WebParamDecl webParamDecl : this.webParams) {
            if (bl != webParamDecl.isHeader()) continue;
            arrayList.add(webParamDecl);
        }
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public WebResultDecl getWebResult() {
        return this.webResult;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public WebServiceSEIDecl getWebService() {
        return this.webService;
    }

    public Conversation.Phase getConverationPhase() {
        return this.converationPhase;
    }

    public Iterator<PolicyDecl> getPoilices() {
        return this.poilices.iterator();
    }

    public SOAPBindingDecl getSoapBinding() {
        return this.soapBinding;
    }

    public QName getSoapDispatchName() {
        QName qName = null;
        if (this.getSoapBinding().isDocLiteralBare()) {
            for (WebParamDecl webParamDecl : this.webParams) {
                if (webParamDecl.isHeader()) continue;
                qName = new QName(webParamDecl.getTargetNamespace(), webParamDecl.getName());
                break;
            }
        } else {
            qName = this.getSoapBinding().isDocLiteralWrapped() ? new QName(this.webService.getTargetNamespace(), this.getName()) : new QName(this.getName());
        }
        return qName;
    }

    public QName getResultElementQName() {
        QName qName = null;
        qName = this.getSoapBinding().isDocLiteralBare() ? new QName(this.webResult.getTargetNamespace(), this.webResult.getName()) : new QName(this.webResult.getTargetNamespace(), this.getName());
        return qName;
    }

    JwsBuildContext getContext() {
        return this.context;
    }
}

