/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JField;
import com.bea.util.jam.JParameter;
import javax.jws.WebParam;
import javax.xml.rpc.holders.Holder;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebTypeDecl;
import weblogic.wsee.util.JamUtil;

public class WebParamDecl
extends WebTypeDecl {
    private final WebParam.Mode mode;
    private final String parameterName;
    private final JParameter jParameter;

    public WebParamDecl(WebMethodDecl webMethodDecl, JParameter jParameter, int n) {
        super(webMethodDecl, (JAnnotatedElement)jParameter, jParameter.getType(), WebParam.class, WebParamDecl.getDefaultName(webMethodDecl, jParameter, n));
        this.jParameter = jParameter;
        this.mode = this.getMode(jParameter);
        this.parameterName = jParameter.getSimpleName();
    }

    private static String getDefaultName(WebMethodDecl webMethodDecl, JParameter jParameter, int n) {
        if (webMethodDecl.getWebService().getType() == WebServiceType.JAXWS) {
            if (webMethodDecl.getSoapBinding().isDocLiteralBare()) {
                return webMethodDecl.getName();
            }
            return "arg" + n;
        }
        return jParameter.getSimpleName();
    }

    private WebParam.Mode getMode(JParameter jParameter) {
        WebParam.Mode mode = WebParam.Mode.IN;
        JAnnotation jAnnotation = jParameter.getAnnotation(WebParam.class);
        if (jAnnotation != null) {
            mode = JamUtil.getAnnotationEnumValue(jAnnotation, "mode", WebParam.Mode.class, WebParam.Mode.IN);
        }
        if (jAnnotation == null && this.isHolderType()) {
            mode = WebParam.Mode.OUT;
        }
        return mode;
    }

    public JParameter getJParameter() {
        return this.jParameter;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public WebParam.Mode getMode() {
        return this.mode;
    }

    String getDefaultPartName() {
        if (this.getWebMethodDecl().getSoapBinding().isDocLiteralBare()) {
            return this.getParameterName();
        }
        return this.getWebTypeDeclName();
    }

    public boolean isHolderType() {
        JClass jClass = this.getWebMethodDecl().getWebService().getType() == WebServiceType.JAXRPC ? this.jParameter.getType().getClassLoader().loadClass(Holder.class.getName()) : this.jParameter.getType().getClassLoader().loadClass(javax.xml.ws.Holder.class.getName());
        return jClass.isAssignableFrom(this.jParameter.getType());
    }

    public JClass getRealType() {
        if (this.isHolderType()) {
            JField[] jFieldArray;
            for (JField jField : jFieldArray = this.jParameter.getType().getFields()) {
                if (!"value".equals(jField.getSimpleName())) continue;
                return jField.getType();
            }
            throw new IllegalStateException("Public field \"value\" is not found in " + this.jParameter.getType().getQualifiedName() + ". It is not a valid JAXRPC holder class.");
        }
        return this.jParameter.getType();
    }
}

