/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JSourcePosition;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.SessionBean;
import javax.ejb.Stateless;
import weblogic.ejbgen.Session;
import weblogic.jws.security.UserDataConstraint;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.jws.HandlerChainDeclFactory;
import weblogic.wsee.jws.WebServiceRuntimeDecl;
import weblogic.wsee.tools.jws.build.JwsInfo;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.WebServiceSecurityDecl;
import weblogic.wsee.tools.jws.decl.port.JmsPort;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.jws.decl.port.PortsBuilder;
import weblogic.wsee.tools.jws.validation.Validator;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.cow.CowReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebServiceDecl
extends WebServiceRuntimeDecl
implements Validator {
    private String artifactName = null;
    private final Set<PortDecl> ports = new HashSet<PortDecl>();
    private final WebServiceSecurityDecl webServiceSecurityDecl;
    final JwsBuildContext ctx;
    private final CowReader cowReader;
    private final boolean isGenerateWsdl;
    private final boolean isGenerateDescriptors;

    WebServiceDecl(JwsBuildContext jwsBuildContext, JwsInfo jwsInfo, String string, WebServiceDecl webServiceDecl) {
        super(jwsInfo.getType(), jwsInfo.getJClass(), webServiceDecl, jwsInfo.getCowReader() == null);
        this.ctx = jwsBuildContext;
        this.webServiceSecurityDecl = new WebServiceSecurityDecl(this.sbClass);
        this.initPorts(jwsInfo, string);
        this.cowReader = jwsInfo.getCowReader();
        this.isGenerateWsdl = jwsInfo.isGenerateWsdl();
        this.isGenerateDescriptors = jwsInfo.isGenerateDescriptors();
        if (jwsInfo.getCowReader() != null) {
            this.handlerChainDecl = HandlerChainDeclFactory.newInstance(this.eiClass, this.sbClass, this.getType(), this.cowReader.getClassLoader());
        }
    }

    private void initPorts(JwsInfo jwsInfo, String string) {
        UserDataConstraint.Transport transport;
        PortsBuilder portsBuilder = new PortsBuilder(this.ctx, jwsInfo, this.getServiceQName(), this.getPortName());
        portsBuilder.setWsdlLocation(this.wsdlLocation);
        portsBuilder.setContextPath(string);
        if (this.parentWebServiceDecl != null) {
            portsBuilder.setParentWebService(this.parentWebServiceDecl);
        }
        if ((transport = this.getWebServiceSecurityDecl().getTransport()) == UserDataConstraint.Transport.INTEGRAL || transport == UserDataConstraint.Transport.CONFIDENTIAL) {
            portsBuilder.setProtocol("https");
        }
        this.ports.addAll(portsBuilder.buildPorts());
    }

    public WebServiceDecl getParentWebService() {
        return this.parentWebServiceDecl;
    }

    public Iterator<PortDecl> getPorts() {
        return this.ports.iterator();
    }

    public Iterator<PortDecl> getDDPorts() {
        HashMap<String, PortDecl> hashMap = new HashMap<String, PortDecl>();
        for (PortDecl portDecl : this.ports) {
            String string = portDecl.getNormalizedPath();
            if (hashMap.containsKey(string)) {
                if (portDecl instanceof JmsPort || !(hashMap.get(string) instanceof JmsPort)) continue;
                hashMap.put(string, portDecl);
                continue;
            }
            hashMap.put(string, portDecl);
        }
        return Collections.unmodifiableCollection(hashMap.values()).iterator();
    }

    public File getSourceFile() {
        URI uRI;
        JSourcePosition jSourcePosition = this.sbClass.getSourcePosition();
        if (jSourcePosition != null && (uRI = jSourcePosition.getSourceURI()) != null) {
            return new File(uRI);
        }
        return null;
    }

    public boolean isEjb() {
        if (this.getType() == WebServiceType.JAXWS) {
            return this.sbClass.getAnnotation(Stateless.class.getName()) != null;
        }
        JClass jClass = this.sbClass.getClassLoader().loadClass(SessionBean.class.getName());
        return jClass.isAssignableFrom(this.sbClass);
    }

    public CowReader getCowReader() {
        return this.cowReader;
    }

    public String getWsdlFile() {
        if (this.getCowReader() == null) {
            return this.getArtifactName() + ".wsdl";
        }
        return this.getWsdlLocation();
    }

    public String getArtifactName() {
        if (StringUtil.isEmpty(this.artifactName)) {
            this.artifactName = this.serviceName;
        }
        return this.artifactName;
    }

    public void setArtifactName(String string) {
        this.artifactName = string;
    }

    public boolean isWlw81UpgradedService() {
        return false;
    }

    public String getDeployedName() {
        String string = null;
        if (this.isEjb()) {
            JAnnotationValue jAnnotationValue;
            string = this.getJClass().getSimpleName();
            JAnnotation jAnnotation = this.getJClass().getAnnotation(Session.class);
            if (jAnnotation != null && (jAnnotationValue = jAnnotation.getValue("ejbName")) != null) {
                string = jAnnotationValue.asString();
            }
        } else {
            string = this.getArtifactName() + "Servlet";
        }
        return string.trim();
    }

    public WebServiceSecurityDecl getWebServiceSecurityDecl() {
        return this.webServiceSecurityDecl;
    }

    public boolean isGenerateWsdl() {
        return this.isGenerateWsdl;
    }

    public boolean isGenerateDescriptors() {
        return this.isGenerateDescriptors;
    }
}

