/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl;

import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.build.JwsInfo;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceProviderDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceDeclFactory {
    private final JwsBuildContext ctx;
    private final String contextPath;

    public WebServiceDeclFactory(JwsBuildContext jwsBuildContext) {
        this(jwsBuildContext, null);
    }

    public WebServiceDeclFactory(JwsBuildContext jwsBuildContext, String string) {
        if (jwsBuildContext == null) {
            throw new IllegalArgumentException("ctx must not be null");
        }
        this.ctx = jwsBuildContext;
        this.contextPath = string;
    }

    public <T extends WebServiceDecl> T newInstance(JwsInfo jwsInfo) throws WsBuildException {
        WebServiceDecl webServiceDecl = null;
        if (jwsInfo.getJClass().getAnnotation(WebService.class) != null) {
            webServiceDecl = new WebServiceSEIDecl(this.ctx, jwsInfo, this.contextPath);
        } else if (jwsInfo.getJClass().getAnnotation(WebServiceProvider.class) != null) {
            webServiceDecl = new WebServiceProviderDecl(this.ctx, jwsInfo, this.contextPath);
        }
        if (webServiceDecl == null) {
            throw new WsBuildException(jwsInfo.getJClass().getQualifiedName() + " is not a known web service type.");
        }
        if (this.ctx.isInError()) {
            throw new WsBuildException("JWS build failed: " + this.ctx.getErrorMsgs());
        }
        return (T)webServiceDecl;
    }
}

