/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JField;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.JParameter;
import com.bea.util.jam.mutable.MAnnotatedElement;
import com.bea.util.jam.mutable.MAnnotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebMethod;
import weblogic.ejbgen.Session;
import weblogic.jws.AsyncResponseBean;
import weblogic.jws.Callback;
import weblogic.jws.Context;
import weblogic.jws.Conversation;
import weblogic.jws.Conversational;
import weblogic.jws.Exclude;
import weblogic.jws.ServiceClient;
import weblogic.jws.WLDeployment;
import weblogic.jws.wlw.UseWLW81BindingTypes;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.clientgen.callback.ClientSideCallbackService;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.build.Jws;
import weblogic.wsee.tools.jws.build.JwsInfo;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.CallbackServiceDecl;
import weblogic.wsee.tools.jws.decl.PolicyDecl;
import weblogic.wsee.tools.jws.decl.PolicyDeclBuilder;
import weblogic.wsee.tools.jws.decl.SOAPBindingDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WildcardBindingsDecl;
import weblogic.wsee.tools.jws.validation.EIValidatorFactory;
import weblogic.wsee.tools.jws.validation.SBValidatorFactory;
import weblogic.wsee.tools.jws.validation.Validator;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceSEIDecl
extends WebServiceDecl {
    private String serviceEndpointInterfaceName = null;
    private boolean serviceClientsPresent = false;
    private boolean complexFieldsPresent = false;
    private final SOAPBindingDecl soapBinding;
    private CallbackServiceDecl callbackService = null;
    private final Set<String> deploymentListeners = new HashSet<String>();
    protected WildcardBindingsDecl wildcardBindings;
    private static final String CONTROL_ANNOTATION = "org.apache.beehive.controls.api.bean.Control";
    private static final String CONTEXT_ANNOTATION = "weblogic.controls.jws.Common.Context";
    private final Map<String, WebMethodDecl> webMethods = new HashMap<String, WebMethodDecl>();
    private final List<PolicyDecl> poilices = new ArrayList<PolicyDecl>();
    private static Set<String> complexAnnotationSet = null;

    public WebServiceSEIDecl(JwsBuildContext jwsBuildContext, JwsInfo jwsInfo, String string) {
        this(jwsBuildContext, jwsInfo, string, null);
    }

    WebServiceSEIDecl(JwsBuildContext jwsBuildContext, JwsInfo jwsInfo, String string, WebServiceDecl webServiceDecl) {
        super(jwsBuildContext, jwsInfo, string, webServiceDecl);
        this.soapBinding = new SOAPBindingDecl(jwsBuildContext, this.eiClass);
        this.initCallbackService(jwsBuildContext);
        this.findDeploymentListeners(this.sbClass);
        this.checkFields();
        this.poilices.addAll(PolicyDeclBuilder.build(this.getSourceFile(), (JAnnotatedElement)this.sbClass));
        this.setServiceEndpointInterfaceName();
        this.wildcardBindings = new WildcardBindingsDecl(this.sbClass);
        this.initMethods();
    }

    private void setServiceEndpointInterfaceName() {
        this.serviceEndpointInterfaceName = this.sbClass.getQualifiedName() + "PortType";
        if (this.isEjb() && this.getType() == WebServiceType.JAXRPC) {
            String string;
            JAnnotation jAnnotation = this.sbClass.getAnnotation(Session.class);
            if (jAnnotation == null) {
                jAnnotation = ((MAnnotatedElement)this.sbClass).addLiteralAnnotation(Session.class.getName());
                string = this.sbClass.getSimpleName();
                if (string.endsWith("Bean") && string.length() > 4) {
                    string = string.substring(0, string.length() - 4);
                }
                ((MAnnotation)jAnnotation).setSimpleValue("ejbName", (Object)string, this.sbClass.forName("java.lang.String"));
            }
            if (StringUtil.isEmpty(string = JamUtil.getAnnotationStringValue(jAnnotation, "serviceEndpoint")) || string.equals("UNSPECIFIED")) {
                ((MAnnotation)jAnnotation).setSimpleValue("serviceEndpoint", (Object)this.serviceEndpointInterfaceName, this.sbClass.forName("java.lang.String"));
            } else {
                this.serviceEndpointInterfaceName = string;
            }
        }
    }

    public String getEndpointInterfaceName() {
        return this.serviceEndpointInterfaceName;
    }

    public SOAPBindingDecl getSoapBinding() {
        return this.soapBinding;
    }

    void addWebMethod(WebMethodDecl webMethodDecl) {
        if (webMethodDecl == null) {
            throw new IllegalArgumentException("webMethodDecl must not be null.");
        }
        this.webMethods.put(webMethodDecl.getJMethod().toString(), webMethodDecl);
    }

    public WebMethodDecl getWebMethod(JMethod jMethod) {
        return this.webMethods.get(jMethod.toString());
    }

    public Iterator<WebMethodDecl> getWebMethods() {
        return this.webMethods.values().iterator();
    }

    public boolean requiresContainer() {
        return this.ctx.getTask() == JwsBuildContext.Task.APT || this.isComplex();
    }

    private void checkFields() {
        JField[] jFieldArray = this.sbClass.getFields();
        for (int i = 0; i < jFieldArray.length; ++i) {
            this.checkField(jFieldArray[i]);
            if (this.complexFieldsPresent && this.serviceClientsPresent) break;
        }
    }

    private void checkField(JField jField) {
        JAnnotation jAnnotation = null;
        if (!this.complexFieldsPresent) {
            for (String string : complexAnnotationSet) {
                jAnnotation = jField.getAnnotation(string);
                if (jAnnotation == null) continue;
                this.complexFieldsPresent = true;
                break;
            }
        }
        if ((jAnnotation = jField.getAnnotation(ServiceClient.class)) != null) {
            this.serviceClientsPresent = true;
            this.complexFieldsPresent = true;
        }
    }

    public boolean isComplex() {
        return this.complexFieldsPresent || this.isConversational();
    }

    private void findDeploymentListeners(JClass jClass) {
        JAnnotationValue jAnnotationValue;
        JAnnotation jAnnotation = jClass.getAnnotation(WLDeployment.class);
        if (jAnnotation != null && (jAnnotationValue = jAnnotation.getValue("deploymentListener")) != null) {
            String[] stringArray;
            for (String string : stringArray = jAnnotationValue.asStringArray()) {
                this.deploymentListeners.add(string);
            }
        }
    }

    public Iterator<String> getDeploymentListeners() {
        return this.deploymentListeners.iterator();
    }

    public Iterator<PolicyDecl> getPoilices() {
        return this.poilices.iterator();
    }

    public boolean isAsyncResponseRequired() {
        return this.serviceClientsPresent || this.sbClass.getAnnotation(AsyncResponseBean.class) != null;
    }

    private void initCallbackService(JwsBuildContext jwsBuildContext) {
        JField[] jFieldArray;
        for (JField jField : jFieldArray = this.sbClass.getFields()) {
            if (jField.getAnnotation(Callback.class) == null) continue;
            if (this.callbackService != null) {
                jwsBuildContext.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)this.sbClass, "type.callback.moreThanOne", this.sbClass.getQualifiedName()));
                continue;
            }
            Jws jws = new Jws();
            jws.setJClass(jField.getType());
            this.callbackService = new CallbackServiceDecl(jwsBuildContext, (JwsInfo)jws, null, this);
        }
    }

    public CallbackServiceDecl getCallbackService() {
        return this.callbackService;
    }

    @Override
    public boolean validate() {
        Validator validator;
        boolean bl = true;
        if (!WebServiceType.JAXWS.equals((Object)this.getType()) || this.getCowReader() == null) {
            validator = EIValidatorFactory.newInstance(this.ctx, this);
            bl = validator.validate();
        }
        validator = SBValidatorFactory.newInstance(this.ctx, this, bl);
        boolean bl2 = validator.validate();
        boolean bl3 = true;
        if (this.callbackService != null) {
            bl3 = this.callbackService.validate();
        }
        return bl && bl2 && bl3;
    }

    public static Set<String> getComplexAnnotations() {
        return complexAnnotationSet;
    }

    @Override
    public boolean isWlw81UpgradedService() {
        return this.getJClass().getAnnotation(UseWLW81BindingTypes.class) != null;
    }

    public boolean isClientSideCallbackService() {
        return this.getJClass().getAnnotation(ClientSideCallbackService.class) != null;
    }

    public WildcardBindingsDecl getWildcardBindings() {
        return this.wildcardBindings;
    }

    private boolean isAllWebMethodsFlag() {
        if (this.getType() == WebServiceType.JAXRPC) {
            if (!StringUtil.isEmpty(this.getEndPointInterface())) {
                return true;
            }
            for (JMethod jMethod : this.getNonExcludedMethods()) {
                if (JamUtil.isObjectMethod(jMethod) || jMethod.getAnnotation(WebMethod.class) == null) continue;
                return false;
            }
        } else {
            return true;
        }
        return true;
    }

    void initMethods() {
        boolean bl = this.isAllWebMethodsFlag();
        for (JMethod jMethod : this.getNonExcludedMethods()) {
            this.buildMethod(jMethod, bl);
        }
    }

    private void buildMethod(JMethod jMethod, boolean bl) {
        if (WebServiceSEIDecl.isWebMethod(jMethod, bl)) {
            WebMethodDecl webMethodDecl;
            JMethod jMethod2 = JamUtil.getOverrideMethod(this.getJClass(), jMethod);
            if (jMethod2 == null) {
                this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)this.getJClass(), "type.ei.MethodNotImplemented", jMethod.getQualifiedName()));
                jMethod2 = jMethod;
            }
            if ((webMethodDecl = new WebMethodDecl(this.ctx, this, jMethod, jMethod2)).getWebResult().hasReturn() && !webMethodDecl.getWebResult().validate()) {
                this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)this.getJClass(), "type.ei.ResultNotSupport", jMethod.getQualifiedName()));
            }
            this.addWebMethod(webMethodDecl);
            JParameter[] jParameterArray = jMethod.getParameters();
            for (int i = 0; i < jParameterArray.length; ++i) {
                WebParamDecl webParamDecl = new WebParamDecl(webMethodDecl, jParameterArray[i], i);
                if (!webParamDecl.validate()) {
                    this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)this.getJClass(), "type.ei.ParameterNotSupport", jMethod.getQualifiedName(), jParameterArray[i].getQualifiedName()));
                }
                webMethodDecl.addWebParam(webParamDecl);
            }
        }
    }

    private static boolean isWebMethod(JMethod jMethod, boolean bl) {
        return jMethod.getAnnotation(WebMethod.class) != null || bl && jMethod.isPublic() && !JamUtil.isObjectMethod(jMethod);
    }

    private static boolean isExcluded(JAnnotatedElement jAnnotatedElement) {
        if (jAnnotatedElement.getAnnotation(Exclude.class) != null) {
            return true;
        }
        JAnnotation jAnnotation = jAnnotatedElement.getAnnotation(WebMethod.class);
        if (jAnnotation != null) {
            return JamUtil.getAnnotationBooleanValue(jAnnotation, "exclude", false);
        }
        return false;
    }

    private List<JMethod> getNonExcludedMethods() {
        ArrayList<JMethod> arrayList = new ArrayList<JMethod>();
        for (JClass jClass = this.getEIClass(); jClass != null && !WebServiceSEIDecl.isExcluded((JAnnotatedElement)jClass); jClass = jClass.getSuperclass()) {
            for (JMethod jMethod : jClass.getDeclaredMethods()) {
                if (WebServiceSEIDecl.isExcluded((JAnnotatedElement)jMethod)) continue;
                arrayList.add(jMethod);
            }
        }
        return arrayList;
    }

    static {
        complexAnnotationSet = new HashSet<String>();
        complexAnnotationSet.add(CONTEXT_ANNOTATION);
        complexAnnotationSet.add(CONTROL_ANNOTATION);
        complexAnnotationSet.add(Context.class.getName());
        complexAnnotationSet.add(Callback.class.getName());
        complexAnnotationSet.add(ServiceClient.class.getName());
        complexAnnotationSet.add(Conversation.class.getName());
        complexAnnotationSet.add(Conversational.class.getName());
    }
}

