/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import java.util.ArrayList;
import java.util.HashMap;
import weblogic.jws.security.RolesAllowed;
import weblogic.jws.security.RolesReferenced;
import weblogic.jws.security.RunAs;
import weblogic.jws.security.UserDataConstraint;
import weblogic.wsee.util.JamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceSecurityDecl {
    private boolean delegate;
    private ArrayList<String> roles = new ArrayList();
    private HashMap<String, String[]> rolesMap = new HashMap();
    private boolean securityRolesDefined = false;
    private HashMap<String, String> roleRefsMap = new HashMap();
    private UserDataConstraint.Transport transport;
    private boolean userDataConstraintDefined = false;
    private boolean isRunAsEnabled = false;
    private String runAsRole;
    private String runAsPrincipal;

    WebServiceSecurityDecl(JClass jClass) {
        this.processUserDataConstraint(jClass);
        this.setDelegate(jClass);
        if (this.delegate) {
            return;
        }
        this.processSecurityRoles(jClass);
        this.processSecurityRoleRefs(jClass);
        this.processRunAs(jClass);
    }

    private void setDelegate(JClass jClass) {
        this.delegate = jClass.getAnnotation(RolesReferenced.class) == null && jClass.getAnnotation(RunAs.class) == null;
        this.securityRolesDefined = jClass.getAnnotation(RolesAllowed.class) != null;
    }

    private void processUserDataConstraint(JClass jClass) {
        JAnnotation jAnnotation = jClass.getAnnotation(UserDataConstraint.class);
        if (jAnnotation != null) {
            this.transport = JamUtil.getAnnotationEnumValue(jAnnotation, "transport", UserDataConstraint.Transport.class, UserDataConstraint.Transport.NONE);
            this.userDataConstraintDefined = true;
        }
    }

    private void processSecurityRoleRefs(JClass jClass) {
        JAnnotationValue[] jAnnotationValueArray;
        JAnnotation jAnnotation = jClass.getAnnotation(RolesReferenced.class);
        if (jAnnotation != null && (jAnnotationValueArray = jAnnotation.getValues()) != null) {
            JAnnotation[] jAnnotationArray = jAnnotationValueArray[0].asAnnotationArray();
            WebServiceSecurityDecl.processSecurityRoleRefs(jAnnotationArray, this.roleRefsMap, this.roles);
            this.securityRolesDefined = true;
        }
    }

    private void processSecurityRoles(JClass jClass) {
        JAnnotationValue[] jAnnotationValueArray;
        JAnnotation jAnnotation = jClass.getAnnotation(RolesAllowed.class);
        if (jAnnotation != null && (jAnnotationValueArray = jAnnotation.getValues()) != null) {
            JAnnotation[] jAnnotationArray = jAnnotationValueArray[0].asAnnotationArray();
            WebServiceSecurityDecl.processSecurityRoles(jAnnotationArray, this.roles, this.rolesMap);
            this.securityRolesDefined = true;
        }
    }

    private void processRunAs(JClass jClass) {
        JAnnotation jAnnotation = jClass.getAnnotation(RunAs.class);
        if (jAnnotation != null) {
            JAnnotationValue jAnnotationValue = jAnnotation.getValue("role");
            JAnnotationValue jAnnotationValue2 = jAnnotation.getValue("mapToPrincipal");
            if (jAnnotationValue != null && jAnnotationValue2 != null) {
                this.isRunAsEnabled = true;
                this.runAsRole = jAnnotationValue.asString();
                this.runAsPrincipal = jAnnotationValue2.asString();
                if (this.runAsPrincipal.length() == 0) {
                    this.runAsPrincipal = this.runAsRole;
                }
                if (!this.roles.contains(this.runAsRole)) {
                    this.roles.add(this.runAsRole);
                }
            }
        }
    }

    private static void processSecurityRoles(JAnnotation[] jAnnotationArray, ArrayList<String> arrayList, HashMap<String, String[]> hashMap) {
        for (JAnnotation jAnnotation : jAnnotationArray) {
            JAnnotationValue jAnnotationValue = jAnnotation.getValue("role");
            if (jAnnotationValue == null) {
                throw new IllegalArgumentException("role must be specified in SecurityRole annotation");
            }
            String string = jAnnotationValue.asString();
            JAnnotationValue jAnnotationValue2 = jAnnotation.getValue("mapToPrincipals");
            String[] stringArray = jAnnotationValue2 == null ? null : jAnnotationValue2.asStringArray();
            boolean bl = false;
            if (hashMap.containsKey(string)) {
                bl = true;
            } else {
                arrayList.add(string);
            }
            if (stringArray == null || stringArray.length <= 0) continue;
            if (bl) {
                String[] stringArray2 = hashMap.get(string);
                String[] stringArray3 = new String[stringArray.length + stringArray2.length];
                System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                System.arraycopy(stringArray, 0, stringArray3, stringArray2.length, stringArray.length);
                stringArray = stringArray3;
            }
            hashMap.put(string, stringArray);
        }
    }

    private static void processSecurityRoleRefs(JAnnotation[] jAnnotationArray, HashMap<String, String> hashMap, ArrayList<String> arrayList) {
        for (JAnnotation jAnnotation : jAnnotationArray) {
            JAnnotationValue jAnnotationValue = jAnnotation.getValue("role");
            JAnnotationValue jAnnotationValue2 = jAnnotation.getValue("link");
            if (jAnnotationValue == null || jAnnotationValue2 == null) continue;
            String string = jAnnotationValue.asString();
            String string2 = jAnnotationValue2.asString();
            if (string2.length() == 0) {
                string2 = string;
            }
            hashMap.put(string, string2);
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
    }

    public ArrayList<String> processSecurityRolesOnMethod(JMethod jMethod) {
        ArrayList<String> arrayList = new ArrayList();
        JAnnotation jAnnotation = jMethod.getAnnotation(RolesAllowed.class);
        if (jAnnotation != null) {
            JAnnotationValue[] jAnnotationValueArray = jAnnotation.getValues();
            if (jAnnotationValueArray != null) {
                JAnnotation[] jAnnotationArray = jAnnotationValueArray[0].asAnnotationArray();
                WebServiceSecurityDecl.processSecurityRoles(jAnnotationArray, arrayList, this.rolesMap);
            }
        } else {
            arrayList = this.roles;
        }
        return arrayList;
    }

    public boolean isUserDataConstraintDefined() {
        return this.userDataConstraintDefined;
    }

    public boolean isSecurityRolesDefined() {
        return this.securityRolesDefined;
    }

    public String[] getPrincipals(String string) {
        return this.rolesMap.get(string);
    }

    public ArrayList<String> getSecurityRoles() {
        return this.roles;
    }

    public UserDataConstraint.Transport getTransport() {
        return this.transport;
    }

    public boolean hasSecurityRoleRefs() {
        return this.roleRefsMap.size() > 0;
    }

    public HashMap<String, String> getSecurityRoleRefs() {
        return this.roleRefsMap;
    }

    public boolean isRunAsEnabled() {
        return this.isRunAsEnabled;
    }

    public String getRunAsRole() {
        return this.runAsRole;
    }

    public String getRunAsPrincipal() {
        return this.runAsPrincipal;
    }

    public boolean delegateToPolicyRoleConsumer() {
        return this.delegate;
    }
}

