/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl;

import com.bea.staxb.buildtime.WildcardUtil;
import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JField;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import weblogic.jws.Types;
import weblogic.jws.WildcardParticle;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WildcardBindingsDecl;
import weblogic.wsee.tools.jws.validation.Validator;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.XBeanUtil;

public abstract class WebTypeDecl
implements Validator {
    private final JClass type;
    private boolean isHolder;
    private JClass heldType;
    private final QName xmlElementOrTypeName;
    private final WebMethodDecl webMethodDecl;
    private final boolean header;
    private final String[] typeClassNames;
    private final TypeFamily typeFamily;
    private boolean isXmlElement;
    private String name = null;
    private String partName = null;
    private boolean annotationSet = false;

    WebTypeDecl(WebMethodDecl webMethodDecl, JAnnotatedElement jAnnotatedElement, JClass jClass, Class clazz, String string) {
        this.webMethodDecl = webMethodDecl;
        this.type = jClass;
        JAnnotation jAnnotation = jAnnotatedElement.getAnnotation(clazz);
        if (jAnnotation != null) {
            this.header = JamUtil.getAnnotationBooleanValue(jAnnotation, "header", false);
            this.partName = JamUtil.getAnnotationStringValue(jAnnotation, "partName");
        } else {
            this.header = false;
        }
        this.typeFamily = this.getTypeFamily(jClass);
        if (StringUtil.isEmpty(this.name) && jAnnotation != null) {
            this.name = JamUtil.getAnnotationStringValue(jAnnotation, "name");
            this.annotationSet = true;
        }
        if (StringUtil.isEmpty(this.name)) {
            this.name = string;
        }
        String string2 = this.getElementOrTypeLocalName();
        if (this.typeFamily == TypeFamily.XML_BEAN_DOCUMENT) {
            this.name = string2;
        }
        String string3 = this.getTargetNamespace(jAnnotation);
        this.xmlElementOrTypeName = string2 != null ? new QName(string3, string2) : null;
        this.typeClassNames = this.getTypeClassNames(jAnnotatedElement.getAnnotation(Types.class));
    }

    public String getWebTypeDeclName() {
        return this.name;
    }

    public String getPartName() {
        if (StringUtil.isEmpty(this.partName)) {
            this.partName = this.getDefaultPartName();
        }
        return this.partName;
    }

    abstract String getDefaultPartName();

    private TypeFamily getTypeFamily(JClass jClass) throws RuntimeException {
        TypeFamily typeFamily = TypeFamily.POJO;
        this.isHolder = false;
        this.isXmlElement = true;
        if (XBeanUtil.isXmlBean(jClass)) {
            if (XBeanUtil.xmlBeanIsDocumentType(this.webMethodDecl.getContext().getClassLoader(), jClass.getQualifiedName(), true)) {
                typeFamily = TypeFamily.XML_BEAN_DOCUMENT;
            } else {
                typeFamily = TypeFamily.XML_BEAN_TYPE;
                this.isXmlElement = false;
            }
        } else {
            JClass jClass2 = this.getHeldTypeFromHolder(jClass);
            this.isHolder = jClass2 != null;
            this.heldType = jClass2;
            if (jClass2 != null && XBeanUtil.isXmlBean(jClass2)) {
                if (XBeanUtil.xmlBeanIsDocumentType(this.webMethodDecl.getContext().getClassLoader(), jClass2.getQualifiedName(), true)) {
                    typeFamily = TypeFamily.XML_BEAN_DOCUMENT;
                } else {
                    typeFamily = TypeFamily.XML_BEAN_TYPE;
                    this.isXmlElement = false;
                }
            }
        }
        return typeFamily;
    }

    private JClass getHeldTypeFromHolder(JClass jClass) {
        JField[] jFieldArray;
        JClass jClass2 = jClass.getClassLoader().loadClass(Holder.class.getName());
        if (jClass2.isAssignableFrom(jClass) && (jFieldArray = jClass.getFields()).length == 1 && jFieldArray[0].getSimpleName().equals("value")) {
            return jFieldArray[0].getType();
        }
        return null;
    }

    private String[] getTypeClassNames(JAnnotation jAnnotation) {
        JAnnotationValue jAnnotationValue;
        String[] stringArray = null;
        if (jAnnotation != null && (jAnnotationValue = jAnnotation.getValue("value")) != null) {
            stringArray = jAnnotationValue.asStringArray();
        }
        return stringArray;
    }

    private String getTargetNamespace(JAnnotation jAnnotation) {
        String string = null;
        if (this.typeFamily == TypeFamily.XML_BEAN_DOCUMENT) {
            QName qName = this.isHolder ? XBeanUtil.getQNameFromXmlBean(this.webMethodDecl.getContext().getClassLoader(), this.heldType.getQualifiedName()) : XBeanUtil.getQNameFromXmlBean(this.webMethodDecl.getContext().getClassLoader(), this.type.getQualifiedName());
            if (qName != null) {
                string = qName.getNamespaceURI();
            }
        } else if (this.typeFamily == TypeFamily.XML_BEAN_TYPE) {
            QName qName = this.isHolder ? XBeanUtil.getQNameFromXmlBean(this.webMethodDecl.getContext().getClassLoader(), this.heldType.getQualifiedName()) : XBeanUtil.getQNameFromXmlBean(this.webMethodDecl.getContext().getClassLoader(), this.type.getQualifiedName());
            if (qName != null) {
                string = qName.getNamespaceURI();
            }
        } else {
            if ((this.webMethodDecl.getSoapBinding().isDocumentStyle() || this.header) && jAnnotation != null) {
                string = JamUtil.getAnnotationStringValue(jAnnotation, "targetNamespace");
            }
            if (StringUtil.isEmpty(string)) {
                string = this.webMethodDecl.getWebService().getTargetNamespace();
            }
        }
        assert (string != null) : "Target namespace not found";
        return string;
    }

    private String getElementOrTypeLocalName() {
        String string = null;
        if (this.typeFamily == TypeFamily.XML_BEAN_DOCUMENT) {
            QName qName = this.isHolder ? XBeanUtil.getQNameFromXmlBean(this.webMethodDecl.getContext().getClassLoader(), this.heldType.getQualifiedName()) : XBeanUtil.getQNameFromXmlBean(this.webMethodDecl.getContext().getClassLoader(), this.type.getQualifiedName());
            if (qName != null) {
                string = qName.getLocalPart();
            }
        } else if (this.typeFamily == TypeFamily.XML_BEAN_TYPE) {
            QName qName = this.isHolder ? XBeanUtil.getQNameFromXmlBean(this.webMethodDecl.getContext().getClassLoader(), this.heldType.getQualifiedName()) : XBeanUtil.getQNameFromXmlBean(this.webMethodDecl.getContext().getClassLoader(), this.type.getQualifiedName());
            if (qName != null) {
                string = qName.getLocalPart();
            }
        } else {
            string = this.name;
        }
        assert (string != null) : "Name not found";
        return string;
    }

    public String getName() {
        if (this.xmlElementOrTypeName == null) {
            return null;
        }
        return this.xmlElementOrTypeName.getLocalPart();
    }

    public String getTargetNamespace() {
        if (this.xmlElementOrTypeName == null) {
            return null;
        }
        return this.xmlElementOrTypeName.getNamespaceURI();
    }

    public QName getElementQName() {
        return this.xmlElementOrTypeName;
    }

    public boolean isXmlElement() {
        return this.isXmlElement;
    }

    public boolean isXmlType() {
        return !this.isXmlElement;
    }

    public String getType() {
        if (this.type.isVoidType()) {
            return null;
        }
        return this.type.getQualifiedName();
    }

    public JClass getJClass() {
        return this.type;
    }

    public boolean isHeader() {
        return this.header;
    }

    public WebMethodDecl getWebMethodDecl() {
        return this.webMethodDecl;
    }

    public String[] getTypeClassNames() {
        return this.typeClassNames;
    }

    public TypeFamily getTypeFamily() {
        return this.typeFamily;
    }

    public boolean isBoundToAnyType() {
        WildcardBindingsDecl wildcardBindingsDecl = this.getWebMethodDecl().getWebService().getWildcardBindings();
        return wildcardBindingsDecl.getBindings().get(this.getType()) == WildcardParticle.ANYTYPE;
    }

    public boolean isWildcardType() {
        return WildcardUtil.WILDCARD_CLASSNAMES.contains(this.getType());
    }

    public boolean isArray() {
        return this.getType().endsWith("[]");
    }

    public boolean isAnnotationSet() {
        return this.annotationSet;
    }

    public boolean validate() {
        boolean bl = true;
        if (this.xmlElementOrTypeName == null) {
            bl = false;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeFamily {
        POJO,
        XML_BEAN_TYPE,
        XML_BEAN_DOCUMENT;

    }
}

