/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.xml.XmlObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.soap.SOAPElement;
import weblogic.jws.WildcardBindings;
import weblogic.jws.WildcardParticle;
import weblogic.wsee.util.JamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardBindingsDecl {
    private static final Map<String, WildcardParticle> DEFAULT_BINDINGS = new HashMap<String, WildcardParticle>();
    private Map<String, WildcardParticle> bindings = new HashMap<String, WildcardParticle>();

    public WildcardBindingsDecl(JClass jClass) {
        JAnnotationValue jAnnotationValue;
        this.bindings.putAll(DEFAULT_BINDINGS);
        JAnnotation jAnnotation = jClass.getAnnotation(WildcardBindings.class);
        if (jAnnotation != null && (jAnnotationValue = jAnnotation.getValue("value")) != null) {
            this.processBindingAnnotations(jAnnotationValue.asAnnotationArray());
        }
    }

    private void processBindingAnnotations(JAnnotation[] jAnnotationArray) {
        if (jAnnotationArray != null) {
            for (JAnnotation jAnnotation : jAnnotationArray) {
                String string = JamUtil.getAnnotationStringValue(jAnnotation, "className");
                WildcardParticle wildcardParticle = JamUtil.getAnnotationEnumValue(jAnnotation, "binding", WildcardParticle.class, WildcardParticle.ANYTYPE);
                this.bindings.put(string, wildcardParticle);
            }
        }
    }

    public Map<String, WildcardParticle> getBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    static {
        DEFAULT_BINDINGS.put(SOAPElement.class.getName(), WildcardParticle.ANY);
        DEFAULT_BINDINGS.put(SOAPElement.class.getName() + "[]", WildcardParticle.ANY);
        DEFAULT_BINDINGS.put(XmlObject.class.getName(), WildcardParticle.ANY);
        DEFAULT_BINDINGS.put(XmlObject.class.getName() + "[]", WildcardParticle.ANYTYPE);
        DEFAULT_BINDINGS.put(org.apache.xmlbeans.XmlObject.class.getName(), WildcardParticle.ANY);
        DEFAULT_BINDINGS.put(org.apache.xmlbeans.XmlObject.class.getName() + "[]", WildcardParticle.ANYTYPE);
    }
}

