/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl.port;

import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.util.PathUtil;

public abstract class Port
implements PortDecl {
    private String contextPath = null;
    private String serviceUri = null;
    private String portName = null;
    private JwsBuildContext ctx = null;
    protected String protocol = "http";

    public Port() {
    }

    public Port(String string, String string2, String string3) {
        this.contextPath = string;
        this.serviceUri = string2;
        this.portName = string3;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String string) {
        this.portName = string;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getNormalizedPath() {
        return PathUtil.normalizePath(this.getContextPath()) + "/" + this.getServiceUri();
    }

    public void setContextPath(String string) {
        this.contextPath = string;
        if (this.ctx != null) {
            this.ctx.getProperties().put("jwsc.contextPathOverride", true);
        }
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    public void setServiceUri(String string) {
        this.serviceUri = string;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getURI() {
        StringBuffer stringBuffer = new StringBuffer(this.getProtocol());
        if ("https".equals(this.getProtocol())) {
            stringBuffer.append("://localhost:7002");
        } else {
            stringBuffer.append("://localhost:7001");
        }
        stringBuffer.append(PathUtil.normalizePath(this.getContextPath()));
        stringBuffer.append(this.getServiceUri());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Port)) {
            return false;
        }
        Port port = (Port)object;
        if (this.contextPath != null ? !this.contextPath.equals(port.contextPath) : port.contextPath != null) {
            return false;
        }
        if (this.portName != null ? !this.portName.equals(port.portName) : port.portName != null) {
            return false;
        }
        return !(this.serviceUri != null ? !this.serviceUri.equals(port.serviceUri) : port.serviceUri != null);
    }

    public int hashCode() {
        int n = this.contextPath != null ? this.contextPath.hashCode() : 0;
        n = 29 * n + (this.serviceUri != null ? this.serviceUri.hashCode() : 0);
        n = 29 * n + (this.portName != null ? this.portName.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "{" + this.getPortName() + "}" + this.getURI();
    }

    public void setBuildContext(JwsBuildContext jwsBuildContext) {
        this.ctx = jwsBuildContext;
    }
}

