/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.decl.port;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.jws.WLHttpTransport;
import weblogic.jws.WLHttpsTransport;
import weblogic.jws.WLJmsTransport;
import weblogic.jws.WLLocalTransport;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.callback.CallbackUtils;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.build.JwsInfo;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.port.HttpPort;
import weblogic.wsee.tools.jws.decl.port.HttpsPort;
import weblogic.wsee.tools.jws.decl.port.JmsPort;
import weblogic.wsee.tools.jws.decl.port.LocalPort;
import weblogic.wsee.tools.jws.decl.port.Port;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.jws.decl.port.PortFactory;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.PathUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.soap11.SoapAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortsBuilder {
    private final JwsBuildContext ctx;
    private final JwsInfo jws;
    private final QName serviceName;
    private String portName = null;
    private String wsdlLocation = null;
    private String contextPath = null;
    private WebServiceDecl parentWebService = null;
    private String protocol = "http";

    public PortsBuilder(JwsBuildContext jwsBuildContext, JwsInfo jwsInfo, QName qName, String string) {
        this.ctx = jwsBuildContext;
        this.jws = jwsInfo;
        this.serviceName = qName;
        this.portName = string;
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    public void setParentWebService(WebServiceDecl webServiceDecl) {
        this.parentWebService = webServiceDecl;
    }

    public void setWsdlLocation(String string) {
        this.wsdlLocation = string;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public Set<PortDecl> buildPorts() {
        Set<PortDecl> set = this.getPorts();
        this.normalizePorts(set);
        return set;
    }

    private void normalizePorts(Set<PortDecl> set) {
        HashSet<Port> hashSet = new HashSet<Port>();
        for (PortDecl portDecl : set) {
            this.normalizePort(portDecl, hashSet);
        }
        this.namePorts(hashSet);
    }

    private void normalizePort(PortDecl portDecl, Set<Port> set) {
        if (portDecl instanceof Port) {
            Port port = (Port)portDecl;
            port.setContextPath(this.normalizeContextPath(port.getPortName(), port.getContextPath()));
            port.setServiceUri(this.normalizeServiceUri(port.getServiceUri()));
            port.setProtocol(this.protocol);
            if (port instanceof JmsPort) {
                ((JmsPort)port).setQueue(((JmsPort)port).getQueue());
                ((JmsPort)port).setFactory(((JmsPort)port).getFactory());
            }
            if (StringUtil.isEmpty(port.getPortName())) {
                set.add(port);
            } else {
                port.setPortName(port.getPortName().trim());
            }
        }
    }

    private void namePorts(Set<Port> set) {
        if (set.size() == 1) {
            Port port = set.iterator().next();
            port.setPortName(this.portName);
        } else {
            Iterator<Port> iterator = set.iterator();
            while (iterator.hasNext()) {
                Port port;
                Port port2 = port = iterator.next();
                port2.setPortName(this.portName + port2.getProtocol());
            }
        }
    }

    private Set<PortDecl> getPorts() {
        HashSet<PortDecl> hashSet = new HashSet<PortDecl>();
        if (!this.jws.getPorts().hasNext()) {
            hashSet.addAll(this.findTransportAnnotations());
        } else {
            Iterator<PortDecl> iterator = this.jws.getPorts();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        if (hashSet.size() == 0 && !StringUtil.isEmpty(this.wsdlLocation) && this.jws.getCowReader() != null) {
            this.loadWsdlPorts(hashSet);
        }
        if (hashSet.size() == 0) {
            this.addDefaultPorts(hashSet);
        }
        return hashSet;
    }

    private void addDefaultPorts(Set<PortDecl> set) {
        if (this.parentWebService == null) {
            set.add(new HttpPort());
        } else if (this.parentWebService instanceof WebServiceSEIDecl) {
            WebServiceSEIDecl webServiceSEIDecl = (WebServiceSEIDecl)this.parentWebService;
            Iterator<PortDecl> iterator = webServiceSEIDecl.getPorts();
            while (iterator.hasNext()) {
                PortDecl portDecl = iterator.next();
                Port port = PortFactory.newPort(portDecl.getProtocol());
                if (port == null) {
                    this.ctx.getLogger().log(EventLevel.WARNING, new JwsLogEvent((JElement)this.jws.getJClass(), "port.protocol.unhandled", portDecl.getProtocol(), portDecl.getPortName(), this.serviceName));
                    continue;
                }
                port.setPortName(CallbackUtils.getCallbackPortName(portDecl.getPortName()));
                set.add(port);
            }
        }
    }

    private void loadWsdlPorts(Set<PortDecl> set) {
        WsdlDefinitions wsdlDefinitions = null;
        try {
            wsdlDefinitions = this.jws.getCowReader().getWsdl(this.wsdlLocation);
        }
        catch (WsdlException wsdlException) {
            this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)this.jws.getJClass(), "cow.wsdl.invalid", this.wsdlLocation, wsdlException.getMessage()));
        }
        WsdlService wsdlService = wsdlDefinitions.getServices().get(this.serviceName);
        if (wsdlService != null) {
            for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
                SoapAddress soapAddress = WsdlUtils.getSoapAddress(wsdlPort);
                if (soapAddress == null) continue;
                String string = soapAddress.getLocation();
                if ("REPLACE_WITH_ACTUAL_URL".equals(string)) {
                    string = this.protocol + "://localhost/" + (this.contextPath != null ? this.contextPath + "/" : "") + this.serviceName.getLocalPart() + "/" + this.portName;
                }
                try {
                    URL uRL = new URL(string);
                    Port port = PortFactory.newPort(uRL, wsdlPort);
                    if (port != null) {
                        set.add(port);
                        continue;
                    }
                    this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)this.jws.getJClass(), "port.cow.invalidAddressLocation", soapAddress.getLocation(), "Unsupported protocol."));
                }
                catch (MalformedURLException malformedURLException) {
                    this.ctx.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)this.jws.getJClass(), "port.cow.invalidAddressLocation", soapAddress.getLocation(), malformedURLException.getMessage()));
                }
            }
        }
    }

    private Set<PortDecl> findTransportAnnotations() {
        Port port;
        HashSet<PortDecl> hashSet = new HashSet<PortDecl>();
        JClass jClass = this.jws.getJClass();
        JAnnotation jAnnotation = jClass.getAnnotation(WLHttpTransport.class);
        if (jAnnotation != null) {
            port = new HttpPort();
            PortsBuilder.setCommonAttributes(port, jAnnotation);
            hashSet.add(port);
        }
        if ((jAnnotation = jClass.getAnnotation(WLHttpsTransport.class)) != null) {
            port = new HttpsPort();
            PortsBuilder.setCommonAttributes(port, jAnnotation);
            hashSet.add(port);
        }
        if ((jAnnotation = jClass.getAnnotation(WLLocalTransport.class)) != null) {
            port = new LocalPort();
            PortsBuilder.setCommonAttributes(port, jAnnotation);
            hashSet.add(port);
        }
        if ((jAnnotation = jClass.getAnnotation(WLJmsTransport.class)) != null) {
            port = new JmsPort();
            PortsBuilder.setCommonAttributes(port, jAnnotation);
            String string = JamUtil.getAnnotationStringValue(jAnnotation, "queue");
            String string2 = JamUtil.getAnnotationStringValue(jAnnotation, "connectionFactory");
            ((JmsPort)port).setQueue(string);
            ((JmsPort)port).setFactory(string2);
            hashSet.add(port);
        }
        return hashSet;
    }

    private static void setCommonAttributes(Port port, JAnnotation jAnnotation) {
        port.setContextPath(JamUtil.getAnnotationStringValue(jAnnotation, "contextPath"));
        port.setServiceUri(JamUtil.getAnnotationStringValue(jAnnotation, "serviceUri"));
        port.setPortName(JamUtil.getAnnotationStringValue(jAnnotation, "portName"));
    }

    private String normalizeServiceUri(String string) {
        String string2 = null;
        string2 = string == null ? (this.ctx.getTask() == JwsBuildContext.Task.APT ? this.jws.getJClass().getQualifiedName().replace('.', '/') + ".jws" : (this.jws.getType() == WebServiceType.JAXWS ? this.serviceName.getLocalPart() : this.jws.getJClass().getSimpleName())) : string;
        return PathUtil.normalizePath(string2);
    }

    private String normalizeContextPath(String string, String string2) {
        String string3 = null;
        if (this.contextPath != null) {
            string3 = this.contextPath;
            if (string2 != null) {
                this.ctx.getLogger().log(EventLevel.WARNING, new JwsLogEvent((JElement)this.jws.getJClass(), "port.overrideContextPath", this.serviceName, string, string2, this.contextPath));
            }
        } else {
            string3 = string2 != null ? string2 : this.jws.getJClass().getSimpleName();
        }
        if ((string3 = string3.replace('\\', '/')).endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }
}

