/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.ejb;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.mutable.MAnnotatedElement;
import com.bea.util.jam.mutable.MAnnotation;
import com.bea.wls.ejbgen.EJBGen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import weblogic.ejbgen.Constants;
import weblogic.ejbgen.RoleMapping;
import weblogic.ejbgen.RoleMappings;
import weblogic.ejbgen.SecurityRoleRef;
import weblogic.ejbgen.SecurityRoleRefs;
import weblogic.ejbgen.ServiceEndpointMethod;
import weblogic.ejbgen.Session;
import weblogic.jws.Transactional;
import weblogic.jws.security.SecurityRoles;
import weblogic.utils.StringUtils;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.ModuleInfo;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSecurityDecl;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.JamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbGenInvoker {
    private Set<String> rolesToMapSet = new HashSet<String>();

    public void process(ModuleInfo moduleInfo) throws WsBuildException {
        String[] stringArray = new String[]{"-d", moduleInfo.getOutputDir().getAbsolutePath(), "-ignorePackage", "-wls9", "-source", "1.5"};
        moduleInfo.getJwsBuildContext().getLogger().log(EventLevel.VERBOSE, "Going to call ejbgen with args " + this.toString(stringArray));
        JClass[] jClassArray = new JClass[moduleInfo.getWebServices().size()];
        int n = 0;
        for (WebServiceDecl webServiceDecl : moduleInfo.getWebServices()) {
            assert (webServiceDecl instanceof WebServiceSEIDecl) : "Only JAX-RPC with EJB2 is supported";
            this.preprocess((WebServiceSEIDecl)webServiceDecl);
            jClassArray[n++] = webServiceDecl.getJClass();
        }
        try {
            EJBGen.main((String[])stringArray, (JClass[])jClassArray);
        }
        catch (Error error) {
            throw new WsBuildException("Failed to run EJB Gen tool using the following args " + this.toString(stringArray) + " due to -- ", error);
        }
    }

    private void preprocess(WebServiceSEIDecl webServiceSEIDecl) {
        this.mapRunAs(webServiceSEIDecl);
        this.mapTransaction(webServiceSEIDecl);
        if (!this.processRolesAllowed(webServiceSEIDecl)) {
            this.mapRoles(webServiceSEIDecl);
            this.createWLRoleMappings(webServiceSEIDecl.getJClass());
        }
    }

    private boolean processRolesAllowed(WebServiceSEIDecl webServiceSEIDecl) {
        MAnnotation[] mAnnotationArray;
        Object object2;
        boolean bl = false;
        WebServiceSecurityDecl webServiceSecurityDecl = webServiceSEIDecl.getWebServiceSecurityDecl();
        if (webServiceSecurityDecl.delegateToPolicyRoleConsumer()) {
            return false;
        }
        JClass jClass = webServiceSEIDecl.getJClass();
        Iterator<WebMethodDecl> iterator = webServiceSEIDecl.getWebMethods();
        ArrayList<String> arrayList = new ArrayList<String>(webServiceSecurityDecl.getSecurityRoles());
        while (iterator.hasNext()) {
            object2 = iterator.next();
            mAnnotationArray = ((WebMethodDecl)object2).getJMethod();
            ArrayList<String> arrayList2 = webServiceSecurityDecl.processSecurityRolesOnMethod((JMethod)mAnnotationArray);
            if (arrayList2.size() <= 0) continue;
            MAnnotation mAnnotation = (MAnnotation)mAnnotationArray.getAnnotation(ServiceEndpointMethod.class);
            String object3 = StringUtils.join((String[])arrayList2.toArray(new String[0]), (String)",");
            mAnnotation.setSimpleValue("roles", (Object)object3, jClass.forName(String.class.getName()));
            if (arrayList2 != webServiceSecurityDecl.getSecurityRoles()) {
                EjbGenInvoker.addRoles(arrayList, arrayList2);
            }
            bl = true;
        }
        if (bl) {
            object2 = ((MAnnotatedElement)jClass).addLiteralAnnotation(RoleMappings.class.getName());
            mAnnotationArray = object2.createNestedValueArray("value", RoleMapping.class.getName(), arrayList.size());
            int n = 0;
            for (String string : arrayList) {
                mAnnotationArray[n].setSimpleValue("roleName", (Object)string, jClass.forName(String.class.getName()));
                String[] stringArray = webServiceSecurityDecl.getPrincipals(string);
                if (stringArray == null) {
                    mAnnotationArray[n].setSimpleValue("externallyDefined", (Object)Constants.Bool.TRUE, jClass.forName(Constants.Bool.class.getName()));
                } else {
                    mAnnotationArray[n].setSimpleValue("principals", (Object)StringUtils.join((String[])stringArray, (String)","), jClass.forName(String.class.getName()));
                }
                ++n;
            }
        }
        if (webServiceSecurityDecl.hasSecurityRoleRefs()) {
            object2 = webServiceSecurityDecl.getSecurityRoleRefs();
            mAnnotationArray = ((MAnnotatedElement)jClass).addLiteralAnnotation(SecurityRoleRefs.class.getName());
            MAnnotation[] mAnnotationArray2 = mAnnotationArray.createNestedValueArray("value", SecurityRoleRef.class.getName(), ((HashMap)object2).size());
            int n = 0;
            Set set = ((HashMap)object2).entrySet();
            for (Map.Entry entry : set) {
                mAnnotationArray2[n].setSimpleValue("roleName", entry.getKey(), jClass.forName(String.class.getName()));
                mAnnotationArray2[n].setSimpleValue("roleLink", entry.getValue(), jClass.forName(String.class.getName()));
                ++n;
            }
            bl = true;
        }
        return bl;
    }

    private static void addRoles(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String string : arrayList2) {
            if (arrayList.contains(string)) continue;
            arrayList3.add(string);
        }
        arrayList.addAll(arrayList3);
    }

    private void createWLRoleMappings(JClass jClass) {
        MAnnotation mAnnotation = ((MAnnotatedElement)jClass).addLiteralAnnotation(RoleMappings.class.getName());
        MAnnotation[] mAnnotationArray = mAnnotation.createNestedValueArray("value", RoleMapping.class.getName(), this.rolesToMapSet.size());
        int n = 0;
        for (String string : this.rolesToMapSet) {
            mAnnotationArray[n].setSimpleValue("roleName", (Object)string, jClass.forName(String.class.getName()));
            mAnnotationArray[n].setSimpleValue("externallyDefined", (Object)Constants.Bool.TRUE, jClass.forName(Constants.Bool.class.getName()));
            ++n;
        }
    }

    private void mapRoles(WebServiceSEIDecl webServiceSEIDecl) {
        Object object;
        JAnnotationValue jAnnotationValue;
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<String> hashSet2 = new HashSet<String>();
        JAnnotation jAnnotation = webServiceSEIDecl.getJClass().getAnnotation(SecurityRoles.class);
        if (jAnnotation != null) {
            jAnnotationValue = jAnnotation.getValue("rolesAllowed");
            if (jAnnotationValue != null) {
                object = jAnnotationValue.asStringArray();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    hashSet.add(object[i]);
                }
            }
            if ((object = jAnnotation.getValue("rolesReferenced")) != null) {
                String[] stringArray = object.asStringArray();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet2.add(stringArray[i]);
                }
            }
        }
        jAnnotationValue = webServiceSEIDecl.getWebMethods();
        while (jAnnotationValue.hasNext()) {
            String[] stringArray;
            JAnnotationValue jAnnotationValue2;
            object = (WebMethodDecl)jAnnotationValue.next();
            JAnnotation jAnnotation2 = ((WebMethodDecl)object).getJMethod().getAnnotation(SecurityRoles.class);
            if (jAnnotation2 == null) continue;
            JAnnotationValue jAnnotationValue3 = jAnnotation2.getValue("rolesAllowed");
            if (jAnnotationValue3 != null) {
                jAnnotationValue2 = jAnnotationValue3.asStringArray();
                stringArray = (String[])((WebMethodDecl)object).getJMethod().getAnnotation(ServiceEndpointMethod.class);
                JAnnotationValue jAnnotationValue4 = stringArray.getValue("roles");
                String string = "";
                if (jAnnotationValue4 != null) {
                    string = jAnnotationValue4.asString();
                }
                String string2 = this.mergeRoles(hashSet, (String[])jAnnotationValue2, string);
                stringArray.setSimpleValue("roles", (Object)string2, webServiceSEIDecl.getJClass().forName(String.class.getName()));
            }
            if ((jAnnotationValue2 = jAnnotation2.getValue("rolesReferenced")) == null) continue;
            stringArray = jAnnotationValue2.asStringArray();
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
                hashSet2.add(stringArray[i]);
            }
        }
        if (hashSet2.size() > 0) {
            this.addRefs(webServiceSEIDecl.getJClass(), hashSet2);
        }
    }

    private void addRefs(JClass jClass, Set<String> set) {
        int n;
        MAnnotation[] mAnnotationArray;
        MAnnotation[] mAnnotationArray2 = new MAnnotation[]{};
        MAnnotation mAnnotation = (MAnnotation)jClass.getAnnotation(SecurityRoleRefs.class);
        if (mAnnotation == null) {
            mAnnotation = ((MAnnotatedElement)jClass).addLiteralAnnotation(SecurityRoleRefs.class.getName());
        } else {
            mAnnotationArray = mAnnotation.getValue("value");
            if (mAnnotationArray != null && (mAnnotationArray2 = (MAnnotation[])mAnnotationArray.asAnnotationArray()) == null) {
                mAnnotationArray2 = new MAnnotation[]{};
            }
        }
        mAnnotationArray = mAnnotation.createNestedValueArray("value", SecurityRoleRef.class.getName(), mAnnotationArray2.length + set.size());
        for (n = 0; n < mAnnotationArray2.length; ++n) {
            mAnnotationArray[n].setSimpleValue("roleName", (Object)mAnnotationArray2[n].getValue("roleName"), jClass.forName(String.class.getName()));
            mAnnotationArray[n].setSimpleValue("roleLink", (Object)mAnnotationArray2[n].getValue("roleLink"), jClass.forName(String.class.getName()));
        }
        for (String string : set) {
            mAnnotationArray[n].setSimpleValue("roleName", (Object)string, jClass.forName(String.class.getName()));
            mAnnotationArray[n].setSimpleValue("roleLink", (Object)string, jClass.forName(String.class.getName()));
            ++n;
        }
        this.rolesToMapSet.addAll(set);
    }

    private String mergeRoles(Set set, String[] stringArray, String string) {
        HashSet<String> hashSet = new HashSet<String>(set);
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        if (!string.equals("UNSPECIFIED")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        this.rolesToMapSet.addAll(hashSet);
        String string2 = "UNSPECIFIED";
        if (hashSet.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(',');
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private void mapTransaction(WebServiceSEIDecl webServiceSEIDecl) {
        boolean bl = false;
        JAnnotation jAnnotation = webServiceSEIDecl.getJClass().getAnnotation(Transactional.class);
        if (jAnnotation != null) {
            bl = JamUtil.getAnnotationBooleanValue(jAnnotation, "value", false);
        }
        Iterator<WebMethodDecl> iterator = webServiceSEIDecl.getWebMethods();
        while (iterator.hasNext()) {
            WebMethodDecl webMethodDecl = iterator.next();
            boolean bl2 = bl;
            jAnnotation = webMethodDecl.getJMethod().getAnnotation(Transactional.class);
            if (jAnnotation != null) {
                bl2 = JamUtil.getAnnotationBooleanValue(jAnnotation, "value", bl);
            }
            MAnnotation mAnnotation = this.findAnnotation((JAnnotatedElement)webMethodDecl.getJMethod(), ServiceEndpointMethod.class);
            Constants.TransactionAttribute transactionAttribute = bl2 ? Constants.TransactionAttribute.REQUIRED : Constants.TransactionAttribute.SUPPORTS;
            Constants.TransactionAttribute transactionAttribute2 = JamUtil.getAnnotationEnumValue((JAnnotation)mAnnotation, "transactionAttribute", Constants.TransactionAttribute.class, transactionAttribute);
            mAnnotation.setSimpleValue("transactionAttribute", (Object)transactionAttribute2, webServiceSEIDecl.getJClass().forName(Constants.TransactionAttribute.class.getName()));
        }
    }

    private MAnnotation findAnnotation(JAnnotatedElement jAnnotatedElement, Class clazz) {
        MAnnotation mAnnotation = (MAnnotation)jAnnotatedElement.getAnnotation(clazz);
        if (mAnnotation == null) {
            mAnnotation = ((MAnnotatedElement)jAnnotatedElement).addLiteralAnnotation(clazz.getName());
        }
        return mAnnotation;
    }

    private void mapRunAs(WebServiceSEIDecl webServiceSEIDecl) {
        WebServiceSecurityDecl webServiceSecurityDecl = webServiceSEIDecl.getWebServiceSecurityDecl();
        if (webServiceSecurityDecl.isRunAsEnabled()) {
            JClass jClass = webServiceSEIDecl.getJClass();
            MAnnotation mAnnotation = this.findAnnotation((JAnnotatedElement)jClass, Session.class);
            mAnnotation.setSimpleValue("runAs", (Object)webServiceSecurityDecl.getRunAsRole(), jClass.forName("java.lang.String"));
            mAnnotation.setSimpleValue("runAsIdentityPrincipal", (Object)webServiceSecurityDecl.getRunAsPrincipal(), jClass.forName("java.lang.String"));
        }
    }

    private String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("([");
            stringBuffer.append(i);
            stringBuffer.append("]");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

