/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.jaxws;

import java.util.Collection;
import java.util.Map;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.wsee.deploy.WSEEAnnotationProcessor;
import weblogic.wsee.deploy.WSEEBaseModule;
import weblogic.wsee.tools.jws.jaxws.WSEEEJBModule;
import weblogic.wsee.tools.jws.jaxws.WSEEWebModule;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXWSAnnotationProcessor {
    private static final boolean verbose = Verbose.isVerbose(JAXWSAnnotationProcessor.class);
    private final WSEEAnnotationProcessor inner_proccessor = new WSEEAnnotationProcessor();

    public void process(Collection<Object> collection, ClassLoader classLoader, Map<String, Class> map, boolean bl) throws WsException {
        if (map == null || map.isEmpty()) {
            return;
        }
        WebservicesBean webservicesBean = JAXWSAnnotationProcessor.getOrCreateWebServicesBean(collection);
        WeblogicWebservicesBean weblogicWebservicesBean = JAXWSAnnotationProcessor.getOrCreateWeblogicWebServicesBean(collection);
        WSEEBaseModule wSEEBaseModule = bl ? new WSEEWebModule(map) : new WSEEEJBModule(map);
        this.inner_proccessor.process(webservicesBean, weblogicWebservicesBean, wSEEBaseModule, classLoader);
    }

    private static final WebservicesBean getOrCreateWebServicesBean(Collection<Object> collection) {
        WebservicesBean webservicesBean = null;
        for (Object object : collection) {
            if (!(object instanceof WebservicesBean)) continue;
            webservicesBean = (WebservicesBean)object;
            break;
        }
        if (webservicesBean == null) {
            if (verbose) {
                Verbose.log("Creating web services bean.");
            }
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            webservicesBean = (WebservicesBean)editableDescriptorManager.createDescriptorRoot(WebservicesBean.class).getRootBean();
            webservicesBean.setVersion("1.2");
            collection.add(webservicesBean);
        }
        return webservicesBean;
    }

    private static WeblogicWebservicesBean getOrCreateWeblogicWebServicesBean(Collection<Object> collection) {
        WeblogicWebservicesBean weblogicWebservicesBean = null;
        for (Object object : collection) {
            if (!(object instanceof WeblogicWebservicesBean)) continue;
            weblogicWebservicesBean = (WeblogicWebservicesBean)object;
            break;
        }
        if (weblogicWebservicesBean == null) {
            if (verbose) {
                Verbose.log("Creating weblogic web services bean.");
            }
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            weblogicWebservicesBean = (WeblogicWebservicesBean)editableDescriptorManager.createDescriptorRoot(WeblogicWebservicesBean.class).getRootBean();
            weblogicWebservicesBean.setVersion("1.2");
            collection.add(weblogicWebservicesBean);
        }
        return weblogicWebservicesBean;
    }

    private static final Class<?> loadJwsClass(ClassLoader classLoader, String string) {
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }
}

