/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.jaxws;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import com.sun.istack.ws.AnnotationProcessorFactoryImpl;
import com.sun.tools.ws.ant.Apt;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.server.ContainerResolver;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.RuntimeModeler;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.writer.WSDLGenerator;
import com.sun.xml.ws.wsdl.writer.WSDLResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebMethod;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Holder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.ServiceImplBeanBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.j2ee.descriptor.wl.WebserviceAddressBean;
import weblogic.j2ee.descriptor.wl.WebserviceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.jws.security.UserDataConstraint;
import weblogic.utils.FileUtils;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.jaxws.spi.WLSProvider;
import weblogic.wsee.jws.WebServiceRuntimeDecl;
import weblogic.wsee.tools.TempDirManager;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.anttasks.AntUtil;
import weblogic.wsee.tools.jws.JWSProcessor;
import weblogic.wsee.tools.jws.ModuleInfo;
import weblogic.wsee.tools.jws.WebServiceInfo;
import weblogic.wsee.tools.jws.decl.PolicyDecl;
import weblogic.wsee.tools.jws.decl.PolicyDeclBuilder;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.logging.BuildListenerLogger;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.JamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSProcessor
implements JWSProcessor {
    private final List<WebServiceDecl> webServices = new ArrayList<WebServiceDecl>();
    private Project project;
    private ModuleInfo moduleInfo;
    private static final String TRANSPORT_GUARANTEE_INTEGRAL = "INTEGRAL";
    private static final String TRANSPORT_GUARANTEE_CONFIDENTIAL = "CONFIDENTIAL";

    @Override
    public void init(ModuleInfo moduleInfo) throws WsBuildException {
        this.moduleInfo = moduleInfo;
        this.project = new Project();
        this.project.setBasedir(moduleInfo.getOutputDir().getAbsolutePath());
        this.project.addBuildListener((BuildListener)new BuildListenerLogger(moduleInfo.getJwsBuildContext().getLogger()));
    }

    private Path createPath(String[] stringArray) {
        Path path = new Path(this.project);
        if (stringArray != null) {
            for (String string : stringArray) {
                path.createPathElement().setPath(string);
            }
        }
        return path;
    }

    @Override
    public void process(WebServiceInfo webServiceInfo) throws WsBuildException {
        if (((WebServiceRuntimeDecl)webServiceInfo.getWebService()).getType() != WebServiceType.JAXWS) {
            return;
        }
        this.webServices.add((WebServiceDecl)webServiceInfo.getWebService());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void finish() throws WsBuildException {
        block22: {
            if (this.webServices.isEmpty()) {
                return;
            }
            this.moduleInfo.getJwsBuildContext().getLogger().log(EventLevel.INFO, "Processing " + this.webServices.size() + " JAX-WS web services...");
            TempDirManager tempDirManager = new TempDirManager(this.project);
            try {
                WebserviceDescriptionBean webserviceDescriptionBean;
                if (this.moduleInfo.isWsdlOnly()) {
                    File file = tempDirManager.createTempDir("apt", this.moduleInfo.getOutputDir());
                    this.runApt(file, true);
                    for (WebServiceDecl webServiceDecl : this.webServices) {
                        this.generateWsdl(this.moduleInfo.getOutputDir(), file, webServiceDecl);
                    }
                    break block22;
                }
                boolean bl = this.moduleInfo.isGenerateWsdl();
                for (WebServiceDecl object2 : this.webServices) {
                    if (!object2.isGenerateWsdl()) continue;
                    bl = true;
                }
                this.runApt(this.moduleInfo.getOutputDir(), bl);
                boolean bl2 = this.moduleInfo.isGenerateDescriptors();
                for (WebServiceDecl webServiceDecl : this.webServices) {
                    if (webServiceDecl.isGenerateDescriptors()) {
                        bl2 = true;
                    }
                    if (!webServiceDecl.isEjb() || this.moduleInfo.getJwsBuildContext().getProperties().get("jwsc.contextPathOverride") == null) continue;
                    bl2 = true;
                    this.moduleInfo.setGenerateDescriptors(true);
                }
                if (bl2) {
                    void var4_14;
                    WebservicesBean webservicesBean = this.moduleInfo.getWebServicesBean();
                    if (webservicesBean == null) {
                        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
                        WebservicesBean webservicesBean2 = (WebservicesBean)editableDescriptorManager.createDescriptorRoot(WebservicesBean.class).getRootBean();
                        this.moduleInfo.setWebServicesBean(webservicesBean2);
                    }
                    var4_14.setVersion("1.2");
                    for (WebServiceDecl webServiceDecl : this.webServices) {
                        if (!this.moduleInfo.isGenerateDescriptors() && !webServiceDecl.isGenerateDescriptors()) continue;
                        JAXWSProcessor.fillWebservice(webServiceDecl, (WebservicesBean)var4_14);
                    }
                    WeblogicWebservicesBean weblogicWebservicesBean = this.moduleInfo.getWeblogicWebservicesBean();
                    if (weblogicWebservicesBean == null) {
                        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
                        WeblogicWebservicesBean weblogicWebservicesBean2 = (WeblogicWebservicesBean)editableDescriptorManager.createDescriptorRoot(WeblogicWebservicesBean.class).getRootBean();
                        this.moduleInfo.setWeblogicWebservicesBean(weblogicWebservicesBean2);
                    }
                    for (WebServiceDecl webServiceDecl : this.webServices) {
                        void var5_23;
                        if (!this.moduleInfo.isGenerateDescriptors() && !webServiceDecl.isGenerateDescriptors()) continue;
                        webserviceDescriptionBean = var5_23.createWebserviceDescription();
                        JAXWSProcessor.fillWebservice(webServiceDecl, webserviceDescriptionBean);
                    }
                    WebservicePolicyRefBean webservicePolicyRefBean = this.moduleInfo.getWebservicePolicyRefBean();
                    if (webservicePolicyRefBean == null) {
                        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
                        WebservicePolicyRefBean webservicePolicyRefBean2 = (WebservicePolicyRefBean)editableDescriptorManager.createDescriptorRoot(WebservicePolicyRefBean.class).getRootBean();
                        this.moduleInfo.setWebservicePolicyRefBean(webservicePolicyRefBean2);
                    }
                }
                for (WebServiceDecl webServiceDecl : this.webServices) {
                    File file = new File(this.moduleInfo.getOutputDir(), "policies");
                    file.mkdirs();
                    try {
                        List<PolicyDecl> list = PolicyDeclBuilder.build(webServiceDecl.getSourceFile(), (JAnnotatedElement)webServiceDecl.getJClass());
                        JAXWSProcessor.copyPolicies(webServiceDecl, file, list.iterator());
                        webserviceDescriptionBean = JAXWSProcessor.getWebMethods(webServiceDecl.getJClass());
                        for (JMethod jMethod : webserviceDescriptionBean) {
                            List<PolicyDecl> list2 = PolicyDeclBuilder.build(webServiceDecl.getSourceFile(), (JAnnotatedElement)jMethod);
                            JAXWSProcessor.copyPolicies(webServiceDecl, file, list2.iterator());
                        }
                    }
                    catch (IOException iOException) {
                        throw new WsBuildException(iOException);
                    }
                    if (!this.moduleInfo.isGenerateWsdl() && !webServiceDecl.isGenerateWsdl()) continue;
                    this.generateWsdl(this.moduleInfo.getOutputDir(), webServiceDecl);
                }
            }
            catch (IOException iOException) {
                throw new WsBuildException("Error creating temp directory", iOException);
            }
            catch (Throwable throwable) {
                throw new WsBuildException("Error processing JAX-WS web services", throwable);
            }
            finally {
                tempDirManager.cleanup();
            }
        }
    }

    private void generateWsdl(File file, WebServiceDecl webServiceDecl) {
        this.generateWsdl(file, null, webServiceDecl);
    }

    private void generateWsdl(final File file, File file2, WebServiceDecl webServiceDecl) {
        Path path = this.createClassPath(file, null);
        if (file2 != null) {
            path.createPathElement().setLocation(file2);
        }
        ClassLoader classLoader = this.createClassLoader(path);
        final ArrayList arrayList = new ArrayList();
        try {
            Class<?> clazz = Class.forName(webServiceDecl.getJClass().getQualifiedName(), true, classLoader);
            BindingID bindingID = BindingID.parse((String)webServiceDecl.getProtocolBinding());
            RuntimeModeler runtimeModeler = new RuntimeModeler(clazz, webServiceDecl.getServiceQName(), bindingID);
            runtimeModeler.setClassLoader(classLoader);
            if (webServiceDecl.getPortQName() != null) {
                runtimeModeler.setPortName(webServiceDecl.getPortQName());
            }
            AbstractSEIModelImpl abstractSEIModelImpl = runtimeModeler.buildRuntimeModel();
            WebServiceFeatureList webServiceFeatureList = new WebServiceFeatureList(clazz);
            WLSProvider.parseAnnotations(webServiceFeatureList, clazz, true);
            WSDLGenerator wSDLGenerator = new WSDLGenerator(abstractSEIModelImpl, new WSDLResolver(){

                private File toFile(String string) {
                    return new File(file, string);
                }

                private Result toResult(File file2) {
                    StreamResult streamResult;
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file2);
                        arrayList.add(fileOutputStream);
                        streamResult = new StreamResult(fileOutputStream);
                        streamResult.setSystemId(file2.getPath().replace('\\', '/'));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new BuildException((Throwable)fileNotFoundException);
                    }
                    return streamResult;
                }

                public Result getWSDL(String string) {
                    File file2 = this.toFile(string);
                    return this.toResult(file2);
                }

                public Result getSchemaOutput(String string, String string2) {
                    if (string == null) {
                        return null;
                    }
                    File file2 = this.toFile(string2);
                    return this.toResult(file2);
                }

                public Result getAbstractWSDL(Holder<String> holder) {
                    return this.toResult(this.toFile((String)holder.value));
                }

                public Result getSchemaOutput(String string, Holder<String> holder) {
                    return this.getSchemaOutput(string, (String)holder.value);
                }
            }, bindingID.createBinding(webServiceFeatureList.toArray()), ContainerResolver.getInstance().getContainer(), clazz, (WSDLGeneratorExtension[])ServiceFinder.find(WSDLGeneratorExtension.class).toArray()){

                protected String mangleName(String string) {
                    return string;
                }
            };
            wSDLGenerator.doGeneration();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException((Throwable)classNotFoundException);
        }
        finally {
            for (FileOutputStream fileOutputStream : arrayList) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ClassLoader createClassLoader(Path path) throws BuildException {
        try {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (String string : path.list()) {
                arrayList.add(this.project.resolveFile(string).toURI().toURL());
            }
            return new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), JAXWSProcessor.class.getClassLoader());
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException((Throwable)malformedURLException);
        }
    }

    private Path createClassPath(File file, Holder<Boolean> holder) {
        Path path = this.createPath(this.moduleInfo.getJwsBuildContext().getClasspath());
        path = path.concatSystemClasspath();
        path.createPathElement().setLocation(file);
        for (File object : this.moduleInfo.getJwsBuildContext().getClientGenOutputDirs()) {
            path.createPathElement().setLocation(object);
        }
        for (WebServiceDecl webServiceDecl : this.webServices) {
            if (webServiceDecl.getCowReader() != null) {
                path.createPathElement().setLocation(webServiceDecl.getCowReader().getCowFile());
                continue;
            }
            if (holder == null) continue;
            holder.value = true;
        }
        return path;
    }

    private void runApt(File file, boolean bl) {
        Path path = this.createPath(this.moduleInfo.getJwsBuildContext().getSourcepath());
        path.createPathElement().setLocation(this.moduleInfo.getOutputDir());
        Holder holder = new Holder();
        holder.value = false;
        Path path2 = this.createClassPath(file, (Holder<Boolean>)holder);
        if (((Boolean)holder.value).booleanValue()) {
            Object object;
            Apt apt = new Apt();
            apt.setProject(this.project);
            apt.setClasspath(path2);
            apt.setDestdir(file);
            apt.setSourcedestdir(file);
            apt.setFactory(AnnotationProcessorFactoryImpl.class.getName());
            apt.setNocompile(!bl);
            apt.setSourcepath(path);
            apt.setEncoding(this.moduleInfo.getJwsBuildContext().getSrcEncoding());
            if (this.moduleInfo.getOwningTask() != null) {
                object = this.moduleInfo.getOwningTask();
                if (object.getFork()) {
                    String string;
                    String string3 = object.getMemoryInitialSize();
                    if (string3 != null) {
                        apt.createJvmarg().setValue("-Xms" + string3);
                    }
                    if ((string = object.getMemoryMaximumSize()) != null) {
                        apt.createJvmarg().setValue("-Xmx" + string);
                    }
                }
                apt.setVerbose(object.getVerbose());
                apt.setDebug(object.getDebug());
                if (object.getDebugLevel() != null) {
                    apt.setDebuglevel(object.getDebugLevel());
                }
            }
            apt.setFork(true);
            for (FileSet fileSet : AntUtil.getFileSets(this.getSourceFiles(), this.project)) {
                apt.addConfiguredSource(fileSet);
            }
            object = apt.createOption();
            object.setKey("doNotOverWrite");
            object.setValue("true");
            Apt.Option option = apt.createOption();
            option.setKey("ignoreNoWebServiceFoundWarning");
            option.setValue("true");
            apt.execute();
        }
    }

    private File[] getSourceFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (WebServiceDecl webServiceDecl : this.webServices) {
            arrayList.add(webServiceDecl.getSourceFile());
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static void fillWebservice(WebServiceDecl webServiceDecl, WebservicesBean webservicesBean) {
        weblogic.j2ee.descriptor.WebserviceDescriptionBean webserviceDescriptionBean = webservicesBean.createWebserviceDescription();
        webserviceDescriptionBean.setWebserviceDescriptionName(webServiceDecl.getServiceName() == null ? webServiceDecl.getJClass().getQualifiedName() : webServiceDecl.getServiceName());
        String string = JAXWSProcessor.getWsdlFile(webServiceDecl);
        if (string != null && string.length() > 0 && (webServiceDecl.isGenerateWsdl() || webServiceDecl.getCowReader() != null)) {
            webserviceDescriptionBean.setWsdlFile(string);
        }
        Iterator<PortDecl> iterator = webServiceDecl.getDDPorts();
        while (iterator.hasNext()) {
            PortDecl portDecl = iterator.next();
            weblogic.j2ee.descriptor.PortComponentBean portComponentBean = webserviceDescriptionBean.createPortComponent();
            portComponentBean.setPortComponentName(portDecl.getPortName());
            portComponentBean.setWsdlPort(new QName(webServiceDecl.getTargetNamespace(), portDecl.getPortName()));
            String string2 = webServiceDecl.getEndPointInterface();
            if (string2 != null && string2.length() > 0) {
                portComponentBean.setServiceEndpointInterface(string2);
            }
            ServiceImplBeanBean serviceImplBeanBean = portComponentBean.createServiceImplBean();
            if (webServiceDecl.isEjb()) {
                serviceImplBeanBean.setEjbLink(webServiceDecl.getDeployedName());
                continue;
            }
            serviceImplBeanBean.setServletLink(webServiceDecl.getDeployedName() + portDecl.getProtocol());
        }
    }

    private static String getRoot(WebServiceDecl webServiceDecl) {
        return webServiceDecl.isEjb() ? "META-INF/" : "WEB-INF/";
    }

    private static String getWsdlFile(WebServiceDecl webServiceDecl) {
        if (webServiceDecl.getCowReader() == null) {
            return JAXWSProcessor.getRoot(webServiceDecl) + webServiceDecl.getWsdlFile();
        }
        String string = webServiceDecl.getWsdlLocation();
        if (string != null && webServiceDecl.isEjb() && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }

    private static void fillWebservice(WebServiceDecl webServiceDecl, WebserviceDescriptionBean webserviceDescriptionBean) {
        Iterator<PortDecl> iterator = webServiceDecl.getDDPorts();
        while (iterator.hasNext()) {
            PortDecl portDecl = iterator.next();
            PortComponentBean portComponentBean = webserviceDescriptionBean.createPortComponent();
            webserviceDescriptionBean.setWebserviceDescriptionName(webServiceDecl.getServiceName() != null ? webServiceDecl.getServiceName() : webServiceDecl.getJClass().getQualifiedName());
            webserviceDescriptionBean.setWebserviceType(webServiceDecl.getType().toString());
            JAXWSProcessor.fillPortComponent(webServiceDecl, portDecl, portComponentBean);
        }
    }

    private static void fillPortComponent(WebServiceDecl webServiceDecl, PortDecl portDecl, PortComponentBean portComponentBean) {
        UserDataConstraint.Transport transport = webServiceDecl.getWebServiceSecurityDecl().getTransport();
        if (transport == UserDataConstraint.Transport.INTEGRAL) {
            portComponentBean.setTransportGuarantee(TRANSPORT_GUARANTEE_INTEGRAL);
        } else if (transport == UserDataConstraint.Transport.CONFIDENTIAL) {
            portComponentBean.setTransportGuarantee(TRANSPORT_GUARANTEE_CONFIDENTIAL);
        }
        portComponentBean.setPortComponentName(portDecl.getPortName());
        WebserviceAddressBean webserviceAddressBean = portComponentBean.createServiceEndpointAddress();
        webserviceAddressBean.setWebserviceContextpath(portDecl.getContextPath());
        webserviceAddressBean.setWebserviceServiceuri(portDecl.getServiceUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyPolicies(WebServiceDecl webServiceDecl, File file, Iterator<PolicyDecl> iterator) throws IOException, WsBuildException {
        while (iterator.hasNext()) {
            PolicyDecl policyDecl = iterator.next();
            if (policyDecl.isBuiltInPolicy() || policyDecl.isAttachToWsdl() || !policyDecl.isRelativeUri()) continue;
            URL uRL = policyDecl.getPolicyURI().toURL();
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                FileUtils.writeToFile((InputStream)inputStream, (File)new File(file, policyDecl.getUri()));
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
    }

    private static boolean isWebMethod(JMethod jMethod) {
        return jMethod.getAnnotation(WebMethod.class) != null;
    }

    private static boolean isExcluded(JAnnotatedElement jAnnotatedElement) {
        JAnnotation jAnnotation = jAnnotatedElement.getAnnotation(WebMethod.class);
        if (jAnnotation != null) {
            return JamUtil.getAnnotationBooleanValue(jAnnotation, "exclude", false);
        }
        return false;
    }

    private static List<JMethod> getWebMethods(JClass jClass) {
        ArrayList<JMethod> arrayList = new ArrayList<JMethod>();
        while (jClass != null && !JAXWSProcessor.isExcluded((JAnnotatedElement)jClass)) {
            for (JMethod jMethod : jClass.getDeclaredMethods()) {
                if (!JAXWSProcessor.isWebMethod(jMethod) || JAXWSProcessor.isExcluded((JAnnotatedElement)jMethod)) continue;
                arrayList.add(jMethod);
            }
            jClass = jClass.getSuperclass();
        }
        return arrayList;
    }

    static {
        System.setProperty(XMLStreamWriterFactory.class.getName() + ".woodstox", "true");
        System.setProperty(XMLStreamReaderFactory.class.getName() + ".woodstox", "true");
    }
}

