/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.mapping;

import com.bea.staxb.buildtime.WildcardUtil;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.xml.SchemaGlobalElement;
import com.bea.xml.SchemaParticle;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.XmlBeans;
import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.xml.namespace.QName;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.ConstructorParameterOrderBean;
import weblogic.j2ee.descriptor.ExceptionMappingBean;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.PackageMappingBean;
import weblogic.j2ee.descriptor.PortMappingBean;
import weblogic.j2ee.descriptor.ServiceEndpointInterfaceMappingBean;
import weblogic.j2ee.descriptor.ServiceEndpointMethodMappingBean;
import weblogic.j2ee.descriptor.ServiceInterfaceMappingBean;
import weblogic.j2ee.descriptor.WsdlReturnValueMappingBean;
import weblogic.jws.WildcardBindings;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebTypeDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.util.ExceptionInfo;
import weblogic.wsee.util.ExceptionUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlParameter;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.WsdlTypes;
import weblogic.wsee.wsdl.WsdlUtils;

public class JaxrpcMappingBuilder
extends JAXRPCProcessor {
    private static final boolean VERBOSE = Verbose.isVerbose(JaxrpcMappingBuilder.class);
    private static final boolean IGNORE_WEBRESULT = Boolean.getBoolean("weblogic.wsee.jaxrpc.ignore.webresult");
    private static final int NOT_BOUND_TO_WILDCARD = 0;
    private static final int BOUND_TO_ANY = 1;
    private static final int BOUND_TO_ANYTYPE = 2;

    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (this.moduleInfo.isWsdlOnly()) {
            return;
        }
        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
        JavaWsdlMappingBean javaWsdlMappingBean = (JavaWsdlMappingBean)editableDescriptorManager.createDescriptorRoot(JavaWsdlMappingBean.class).getRootBean();
        jAXRPCWebServiceInfo.createBindings().generate109Descriptor(javaWsdlMappingBean);
        this.addPackageMapping(javaWsdlMappingBean, jAXRPCWebServiceInfo.getWebService());
        this.addServiceInterfaceMapping(javaWsdlMappingBean, jAXRPCWebServiceInfo.getWebService(), jAXRPCWebServiceInfo.getDefinitions());
        this.addServiceEndpointInterfaceMapping(javaWsdlMappingBean, jAXRPCWebServiceInfo);
        jAXRPCWebServiceInfo.setJavaWsdlMappingBean(javaWsdlMappingBean);
    }

    private void addJWSExceptionMapping(JavaWsdlMappingBean javaWsdlMappingBean, JAXRPCWebServiceInfo jAXRPCWebServiceInfo, WebMethodDecl webMethodDecl) throws WsBuildException {
        JClass[] jClassArray;
        for (JClass jClass : jClassArray = webMethodDecl.getJMethod().getExceptionTypes()) {
            if (!ExceptionUtil.isUserException(jClass)) continue;
            this.createExceptionMapping(javaWsdlMappingBean, jClass, new QName(webMethodDecl.getWebService().getTargetNamespace(), jClass.getSimpleName()), jAXRPCWebServiceInfo);
        }
    }

    private void addWSDLExceptionMapping(JavaWsdlMappingBean javaWsdlMappingBean, JAXRPCWebServiceInfo jAXRPCWebServiceInfo, WebMethodDecl webMethodDecl, WsdlOperation wsdlOperation) throws WsBuildException {
        Map<String, ? extends WsdlMessage> map = wsdlOperation.getFaults();
        for (WsdlMessage wsdlMessage : map.values()) {
            ExceptionInfo exceptionInfo = ExceptionUtil.getExceptionInfo(jAXRPCWebServiceInfo.createBindings(), wsdlMessage);
            if (VERBOSE) {
                Verbose.log(exceptionInfo.toString());
            }
            String string = exceptionInfo.getJsr109ExceptionClassName();
            JClass jClass = webMethodDecl.getWebService().getJClass().getClassLoader().loadClass(string);
            this.createExceptionMapping(javaWsdlMappingBean, jClass, wsdlMessage.getName(), jAXRPCWebServiceInfo);
        }
    }

    private void createExceptionMapping(JavaWsdlMappingBean javaWsdlMappingBean, JClass jClass, QName qName, JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        ExceptionMappingBean exceptionMappingBean = javaWsdlMappingBean.createExceptionMapping();
        exceptionMappingBean.setExceptionType(jClass.getQualifiedName());
        exceptionMappingBean.setWsdlMessage(qName);
        List list = jAXRPCWebServiceInfo.createBindings().getElementNamesCtorOrderFromException(jClass);
        if (VERBOSE) {
            Verbose.log(" for exception " + jClass.getQualifiedName() + ", got back ordered list of " + list.size() + " elements.");
        }
        if (list.size() > 1) {
            ConstructorParameterOrderBean constructorParameterOrderBean = exceptionMappingBean.createConstructorParameterOrder();
            for (QName qName2 : list) {
                if (VERBOSE) {
                    Verbose.log(" element name " + qName2.getLocalPart() + " add to ConstructorParameterOrderBean");
                }
                constructorParameterOrderBean.addElementName(qName2.getLocalPart());
            }
        }
    }

    private void addServiceInterfaceMapping(JavaWsdlMappingBean javaWsdlMappingBean, WebServiceDecl webServiceDecl, WsdlDefinitions wsdlDefinitions) throws WsBuildException {
        ServiceInterfaceMappingBean serviceInterfaceMappingBean = javaWsdlMappingBean.createServiceInterfaceMapping();
        serviceInterfaceMappingBean.setServiceInterface("javax.xml.rpc.Service");
        WsdlService wsdlService = wsdlDefinitions.getServices().get(webServiceDecl.getServiceQName());
        if (wsdlService == null) {
            throw new WsBuildException("service: " + webServiceDecl.getServiceQName() + " was not found in wsdl.");
        }
        serviceInterfaceMappingBean.setWsdlServiceName(wsdlService.getName());
        for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
            PortMappingBean portMappingBean = serviceInterfaceMappingBean.createPortMapping();
            portMappingBean.setPortName(wsdlPort.getName().getLocalPart());
            portMappingBean.setJavaPortName("get" + wsdlPort.getName().getLocalPart());
        }
    }

    private void addServiceEndpointInterfaceMapping(JavaWsdlMappingBean javaWsdlMappingBean, JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        Iterator<PortDecl> iterator = jAXRPCWebServiceInfo.getWebService().getDDPorts();
        assert (iterator.hasNext()) : "Web service has no ports";
        while (iterator.hasNext()) {
            PortDecl portDecl = iterator.next();
            this.addServiceEndpointInterfaceMapping(javaWsdlMappingBean, jAXRPCWebServiceInfo, portDecl);
        }
    }

    private void addServiceEndpointInterfaceMapping(JavaWsdlMappingBean javaWsdlMappingBean, JAXRPCWebServiceInfo jAXRPCWebServiceInfo, PortDecl portDecl) throws WsBuildException {
        ServiceEndpointInterfaceMappingBean serviceEndpointInterfaceMappingBean = javaWsdlMappingBean.createServiceEndpointInterfaceMapping();
        serviceEndpointInterfaceMappingBean.setServiceEndpointInterface(jAXRPCWebServiceInfo.getWebService().getEndpointInterfaceName());
        WsdlPortType wsdlPortType = jAXRPCWebServiceInfo.getDefinitions().getPortTypes().get(jAXRPCWebServiceInfo.getWebService().getPortTypeQName());
        serviceEndpointInterfaceMappingBean.setWsdlPortType(wsdlPortType.getName());
        WsdlPort wsdlPort = jAXRPCWebServiceInfo.getDefinitions().getPorts().get(new QName(jAXRPCWebServiceInfo.getWebService().getTargetNamespace(), portDecl.getPortName()));
        if (wsdlPort == null) {
            throw new WsBuildException("port: " + portDecl.getPortName() + " was not found in wsdl.");
        }
        serviceEndpointInterfaceMappingBean.setWsdlBinding(wsdlPort.getBinding().getName());
        Iterator<WebMethodDecl> iterator = jAXRPCWebServiceInfo.getWebService().getWebMethods();
        while (iterator.hasNext()) {
            WebMethodDecl webMethodDecl = iterator.next();
            WsdlOperation wsdlOperation = wsdlPortType.getOperations().get(new QName(wsdlPortType.getName().getNamespaceURI(), webMethodDecl.getName()));
            this.addMethodMapping(serviceEndpointInterfaceMappingBean, webMethodDecl, wsdlOperation, jAXRPCWebServiceInfo.getDefinitions().getTypes());
            if (jAXRPCWebServiceInfo.getWebService().getCowReader() != null) {
                this.addWSDLExceptionMapping(javaWsdlMappingBean, jAXRPCWebServiceInfo, webMethodDecl, wsdlOperation);
                continue;
            }
            this.addJWSExceptionMapping(javaWsdlMappingBean, jAXRPCWebServiceInfo, webMethodDecl);
        }
    }

    private void addMethodMapping(ServiceEndpointInterfaceMappingBean serviceEndpointInterfaceMappingBean, WebMethodDecl webMethodDecl, WsdlOperation wsdlOperation, WsdlTypes wsdlTypes) {
        ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean = serviceEndpointInterfaceMappingBean.createServiceEndpointMethodMapping();
        serviceEndpointMethodMappingBean.setJavaMethodName(webMethodDecl.getMethodName());
        serviceEndpointMethodMappingBean.setWsdlOperation(wsdlOperation.getName().getLocalPart());
        if (webMethodDecl.getSoapBinding().isDocLiteralWrapped()) {
            serviceEndpointMethodMappingBean.createWrappedElement();
        }
        if (webMethodDecl.getSoapBinding().isDocumentStyle()) {
            this.addDocumentParams(webMethodDecl, wsdlOperation, serviceEndpointMethodMappingBean, wsdlTypes);
        } else {
            this.addRPCParams(webMethodDecl, wsdlOperation, serviceEndpointMethodMappingBean, wsdlTypes);
        }
    }

    private void addDocumentParams(WebMethodDecl webMethodDecl, WsdlOperation wsdlOperation, ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean, WsdlTypes wsdlTypes) {
        if (webMethodDecl.getWebResult().hasReturn()) {
            String string = null;
            if (webMethodDecl.getSoapBinding().isDocLiteralWrapped()) {
                String string2 = webMethodDecl.getWebResult().getType();
                if (!WildcardUtil.WILDCARD_CLASSNAMES.contains(string2)) {
                    string = webMethodDecl.getWebResult().getName();
                    if (!IGNORE_WEBRESULT && webMethodDecl.getWebResult().isAnnotationSet()) {
                        string = webMethodDecl.getWebResult().getWebTypeDeclName();
                    }
                } else {
                    WsdlPart wsdlPart;
                    if (!this.useWildcardBindingsAnnotation(webMethodDecl.getWebResult()) && (wsdlPart = wsdlOperation.getWsdlMethod().getResultPart()) != null) {
                        XmlTypeName xmlTypeName = this.getPartXmlTypeName(wsdlPart);
                        SchemaTypeLoader schemaTypeLoader = null;
                        try {
                            schemaTypeLoader = XmlBeans.loadXsd((XmlObject[])wsdlTypes.getSchemaArray());
                        }
                        catch (XmlException xmlException) {
                            // empty catch block
                        }
                        if (schemaTypeLoader != null) {
                            if (this.isBoundToAnyType(schemaTypeLoader, xmlTypeName, 0)) {
                                string = webMethodDecl.getWebResult().getName();
                                if (!IGNORE_WEBRESULT && webMethodDecl.getWebResult().isAnnotationSet()) {
                                    string = webMethodDecl.getWebResult().getWebTypeDeclName();
                                }
                            } else {
                                string = "";
                            }
                        }
                    }
                    if (string == null) {
                        if (webMethodDecl.getWebResult().isBoundToAnyType()) {
                            string = webMethodDecl.getWebResult().getName();
                            if (!IGNORE_WEBRESULT && webMethodDecl.getWebResult().isAnnotationSet()) {
                                string = webMethodDecl.getWebResult().getWebTypeDeclName();
                            }
                        } else {
                            string = "";
                        }
                    }
                }
            } else {
                WsdlPart wsdlPart = wsdlOperation.getOutput().getParts().values().iterator().next();
                string = wsdlPart.getName();
            }
            this.addReturnTypeMapping(serviceEndpointMethodMappingBean, webMethodDecl, wsdlOperation, string);
        }
        this.addParams(webMethodDecl, wsdlOperation, serviceEndpointMethodMappingBean, wsdlTypes);
    }

    private void addRPCParams(WebMethodDecl webMethodDecl, WsdlOperation wsdlOperation, ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean, WsdlTypes wsdlTypes) {
        if (webMethodDecl.getWebResult().hasReturn()) {
            WsdlPart wsdlPart = wsdlOperation.getOutput().getParts().get(WsdlUtils.findReturnPart(wsdlOperation));
            this.addReturnTypeMapping(serviceEndpointMethodMappingBean, webMethodDecl, wsdlOperation, wsdlPart.getName());
        }
        this.addParams(webMethodDecl, wsdlOperation, serviceEndpointMethodMappingBean, wsdlTypes);
    }

    private void addParams(WebMethodDecl webMethodDecl, WsdlOperation wsdlOperation, ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean, WsdlTypes wsdlTypes) {
        int n = 0;
        int n2 = -1;
        SchemaTypeLoader schemaTypeLoader = null;
        Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            ++n2;
            WebParamDecl webParamDecl = iterator.next();
            WsdlMessage wsdlMessage = webParamDecl.getMode() == WebParam.Mode.OUT ? wsdlOperation.getOutput() : wsdlOperation.getInput();
            String string = null;
            String string2 = webParamDecl.getType();
            if (!WildcardUtil.WILDCARD_CLASSNAMES.contains(string2)) {
                string = webParamDecl.getPartName();
            } else {
                if (!this.useWildcardBindingsAnnotation(webParamDecl)) {
                    if (webMethodDecl.getSoapBinding().isDocLiteralWrapped()) {
                        if (webParamDecl.isHeader()) {
                            --n2;
                            if (VERBOSE) {
                                Verbose.log("  for doclitwrapped anyType set partName = '" + webParamDecl.getPartName() + "'");
                            }
                            string = webParamDecl.getPartName();
                        } else {
                            object2 = null;
                            for (WsdlParameter xmlException : wsdlOperation.getWsdlMethod().getParameters()) {
                                boolean bl = true;
                                Iterator<WebParamDecl> iterator2 = webMethodDecl.getHeaderParams();
                                while (iterator2.hasNext()) {
                                    WebParamDecl webParamDecl2 = iterator2.next();
                                    if (!xmlException.getPrimaryPart().getName().equals(webParamDecl2.getPartName())) continue;
                                    bl = false;
                                    break;
                                }
                                if (!bl) continue;
                                object2 = xmlException.getPrimaryPart();
                                break;
                            }
                            if (object2 != null) {
                                object = this.getPartXmlTypeName((WsdlPart)object2);
                                if (schemaTypeLoader == null) {
                                    try {
                                        schemaTypeLoader = XmlBeans.loadXsd((XmlObject[])wsdlTypes.getSchemaArray());
                                    }
                                    catch (XmlException xmlException) {
                                        // empty catch block
                                    }
                                }
                                if (schemaTypeLoader != null) {
                                    if (this.isBoundToAnyType(schemaTypeLoader, (XmlTypeName)object, n2)) {
                                        if (VERBOSE) {
                                            Verbose.log("  for doclitwrapped anyType set partName = '" + webParamDecl.getPartName() + "'");
                                        }
                                        string = webParamDecl.getPartName();
                                    } else {
                                        if (VERBOSE) {
                                            Verbose.log("  for doclitwrapped <any/>set  partName to empty");
                                        }
                                        string = "";
                                    }
                                }
                            }
                        }
                    } else {
                        if (VERBOSE) {
                            Verbose.log("  for doc-lit-bare or rpc anyType set partName = '" + webParamDecl.getName() + "'");
                        }
                        string = webParamDecl.getPartName();
                    }
                }
                if (string == null) {
                    if (webParamDecl.isBoundToAnyType()) {
                        if (VERBOSE) {
                            Verbose.log("  for doclitwrapped anyType set partName = '" + webParamDecl.getName() + "'");
                        }
                        string = webParamDecl.getPartName();
                    } else {
                        if (VERBOSE) {
                            Verbose.log("  for doclitwrapped <any/>set  partName to empty");
                        }
                        string = "";
                    }
                }
            }
            object2 = serviceEndpointMethodMappingBean.createMethodParamPartsMapping();
            object2.setParamPosition(n);
            object2.setParamType(webParamDecl.getRealType().getQualifiedName());
            object = object2.createWsdlMessageMapping();
            object.setParameterMode(webParamDecl.getMode().toString());
            if (webParamDecl.isHeader()) {
                object.createSoapHeader();
            }
            object.setWsdlMessage(wsdlMessage.getName());
            object.setWsdlMessagePartName(string);
            ++n;
        }
    }

    private void addReturnTypeMapping(ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean, WebMethodDecl webMethodDecl, WsdlOperation wsdlOperation, String string) {
        WsdlReturnValueMappingBean wsdlReturnValueMappingBean = serviceEndpointMethodMappingBean.createWsdlReturnValueMapping();
        wsdlReturnValueMappingBean.setMethodReturnValue(webMethodDecl.getWebResult().getType());
        WsdlMessage wsdlMessage = wsdlOperation.getOutput();
        wsdlReturnValueMappingBean.setWsdlMessage(wsdlMessage.getName());
        wsdlReturnValueMappingBean.setWsdlMessagePartName(string);
    }

    private void addPackageMapping(JavaWsdlMappingBean javaWsdlMappingBean, WebServiceDecl webServiceDecl) {
        PackageMappingBean packageMappingBean = javaWsdlMappingBean.createPackageMapping();
        packageMappingBean.setPackageType(webServiceDecl.getPackageName());
        packageMappingBean.setNamespaceURI(webServiceDecl.getTargetNamespace());
    }

    private XmlTypeName getPartXmlTypeName(WsdlPart wsdlPart) {
        XmlTypeName xmlTypeName = wsdlPart.getType() != null ? XmlTypeName.forGlobalName((char)'t', (QName)wsdlPart.getType()) : XmlTypeName.forGlobalName((char)'e', (QName)wsdlPart.getElement());
        return xmlTypeName;
    }

    private boolean useWildcardBindingsAnnotation(WebTypeDecl webTypeDecl) {
        JClass jClass = webTypeDecl.getWebMethodDecl().getWebService().getJClass();
        if (jClass != null) {
            JAnnotation jAnnotation = jClass.getAnnotation(WildcardBindings.class);
            return jAnnotation != null;
        }
        return false;
    }

    private boolean isBoundToAnyType(SchemaTypeLoader schemaTypeLoader, XmlTypeName xmlTypeName, int n) {
        SchemaGlobalElement schemaGlobalElement;
        SchemaType schemaType = null;
        if (xmlTypeName.isElement()) {
            schemaGlobalElement = schemaTypeLoader.findElement(xmlTypeName.getQName());
            if (schemaGlobalElement == null) {
                throw new IllegalArgumentException("GlobalElement " + xmlTypeName + " doesn't exist in the schema.");
            }
            schemaType = schemaGlobalElement.getType();
        } else if (xmlTypeName.isType() && (schemaType = schemaTypeLoader.findType(xmlTypeName.getQName())) == null) {
            throw new IllegalArgumentException("GlobalType " + xmlTypeName + " doesn't exist int the schema.");
        }
        schemaGlobalElement = schemaType.getContentModel();
        if (schemaGlobalElement != null) {
            SchemaParticle[] schemaParticleArray = schemaGlobalElement.getParticleChildren();
            if (schemaGlobalElement.getParticleType() == 4 || schemaGlobalElement.getParticleType() == 5) {
                schemaParticleArray = new SchemaParticle[]{schemaGlobalElement};
            }
            if (schemaParticleArray != null && schemaParticleArray.length > n) {
                return this.getWildcardBoundType(schemaParticleArray[n]) == 2;
            }
        }
        return false;
    }

    private int getWildcardBoundType(SchemaParticle schemaParticle) {
        switch (schemaParticle.getParticleType()) {
            case 5: {
                return 1;
            }
            case 4: {
                if (schemaParticle.getType().getBuiltinTypeCode() == 1) {
                    return 2;
                }
                SchemaType schemaType = schemaParticle.getType();
                SchemaParticle schemaParticle2 = schemaType.getContentModel();
                if (schemaParticle2 == null || schemaParticle2.getParticleType() != 4 || schemaParticle2.getType().getBuiltinTypeCode() != 1 || BigInteger.ZERO.equals(schemaParticle2.getMaxOccurs()) || BigInteger.ONE.equals(schemaParticle2.getMaxOccurs())) break;
                return 2;
            }
        }
        return 0;
    }
}

