/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.policy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import weblogic.utils.FileUtils;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.decl.PolicyDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyProcessor
extends JAXRPCProcessor {
    @Override
    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (this.moduleInfo.isWsdlOnly()) {
            return;
        }
        File file = new File(this.moduleInfo.getOutputDir(), "policies");
        file.mkdirs();
        try {
            Iterator<PolicyDecl> iterator = jAXRPCWebServiceInfo.getWebService().getPoilices();
            PolicyProcessor.copyPolicies(jAXRPCWebServiceInfo.getWebService(), file, iterator);
            Iterator<WebMethodDecl> iterator2 = jAXRPCWebServiceInfo.getWebService().getWebMethods();
            while (iterator2.hasNext()) {
                WebMethodDecl webMethodDecl = iterator2.next();
                PolicyProcessor.copyPolicies(jAXRPCWebServiceInfo.getWebService(), file, webMethodDecl.getPoilices());
            }
        }
        catch (IOException iOException) {
            throw new WsBuildException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyPolicies(WebServiceSEIDecl webServiceSEIDecl, File file, Iterator<PolicyDecl> iterator) throws IOException, WsBuildException {
        while (iterator.hasNext()) {
            PolicyDecl policyDecl = iterator.next();
            if (policyDecl.isBuiltInPolicy() || policyDecl.isAttachToWsdl() || !policyDecl.isRelativeUri()) continue;
            if (webServiceSEIDecl.isAsyncResponseRequired()) {
                throw new WsBuildException("attribute \"attachToWsdl\" of @Policy must be true for async call");
            }
            URL uRL = policyDecl.getPolicyURI().toURL();
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                FileUtils.writeToFile((InputStream)inputStream, (File)new File(file, policyDecl.getUri()));
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
    }
}

