/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.process;

import java.util.ArrayList;
import java.util.List;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.JWSProcessor;
import weblogic.wsee.tools.jws.ModuleInfo;
import weblogic.wsee.tools.jws.WebServiceInfo;
import weblogic.wsee.util.Verbose;

class CompositeProcessor
implements JWSProcessor {
    private static final boolean verbose = Verbose.isVerbose(CompositeProcessor.class);
    private List<JWSProcessor> processors = new ArrayList<JWSProcessor>();

    CompositeProcessor() {
    }

    public void init(ModuleInfo moduleInfo) throws WsBuildException {
        for (JWSProcessor jWSProcessor : this.processors) {
            if (verbose) {
                Verbose.log("Initialzing..." + jWSProcessor.getClass().getName());
            }
            jWSProcessor.init(moduleInfo);
        }
    }

    void addProcessor(JWSProcessor jWSProcessor) {
        this.processors.add(jWSProcessor);
    }

    public void process(WebServiceInfo webServiceInfo) throws WsBuildException {
        for (JWSProcessor jWSProcessor : this.processors) {
            if (verbose) {
                Verbose.log("Processing..." + jWSProcessor.getClass().getName());
            }
            jWSProcessor.process(webServiceInfo);
        }
    }

    public void finish() throws WsBuildException {
        for (JWSProcessor jWSProcessor : this.processors) {
            if (verbose) {
                Verbose.log("Finishing..." + jWSProcessor.getClass().getName());
            }
            jWSProcessor.finish();
        }
    }
}

