/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.sei;

import com.bea.util.jam.JClass;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.jws.WebServiceRuntimeDecl;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.JWSProcessor;
import weblogic.wsee.tools.jws.ModuleInfo;
import weblogic.wsee.tools.jws.WebServiceInfo;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.jspgen.JspGenBase;
import weblogic.wsee.util.jspgen.ScriptException;

public abstract class EndpointInterface
extends JspGenBase
implements JWSProcessor {
    private WebServiceSEIDecl webServiceDecl = null;
    private ModuleInfo moduleInfo = null;

    WebServiceSEIDecl getWebService() {
        return this.webServiceDecl;
    }

    String pkgName() {
        return StringUtil.getPackage(this.webServiceDecl.getEndpointInterfaceName());
    }

    String interfaceName() {
        return StringUtil.getSimpleClassName(this.webServiceDecl.getEndpointInterfaceName());
    }

    String exceptions(WebMethodDecl webMethodDecl) {
        StringBuffer stringBuffer = new StringBuffer();
        JClass[] jClassArray = webMethodDecl.getJMethod().getExceptionTypes();
        for (int i = 0; i < jClassArray.length; ++i) {
            JClass jClass = jClassArray[i];
            String string = jClass.getQualifiedName();
            if (RemoteException.class.getName().equals(string)) continue;
            stringBuffer.append(", " + string);
        }
        return stringBuffer.toString();
    }

    String parameters(WebMethodDecl webMethodDecl) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
        while (iterator.hasNext()) {
            WebParamDecl webParamDecl = iterator.next();
            stringBuffer.append(this.convertInnerClassString(webParamDecl.getType()));
            stringBuffer.append(" ");
            stringBuffer.append(webParamDecl.getParameterName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    String returnType(WebMethodDecl webMethodDecl) {
        return this.convertInnerClassString(webMethodDecl.getJMethod().getReturnType().getQualifiedName());
    }

    public void init(ModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public void finish() {
    }

    public void process(WebServiceInfo webServiceInfo) throws WsBuildException {
        if (((WebServiceRuntimeDecl)webServiceInfo.getWebService()).getType() != WebServiceType.JAXRPC) {
            return;
        }
        if (this.moduleInfo.isWsdlOnly()) {
            return;
        }
        JAXRPCWebServiceInfo jAXRPCWebServiceInfo = (JAXRPCWebServiceInfo)webServiceInfo;
        this.webServiceDecl = jAXRPCWebServiceInfo.getWebService();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = this.moduleInfo.getJwsBuildContext().getCodegenOutputEncoding();
            PrintStream printStream = string == null ? new PrintStream(byteArrayOutputStream, true) : new PrintStream((OutputStream)byteArrayOutputStream, true, string);
            this.setOutput(printStream);
            this.generate();
            jAXRPCWebServiceInfo.setEndpointInterface(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.close();
        }
        catch (ScriptException scriptException) {
            throw new WsBuildException("Failed to generate endpoint interface java file", scriptException);
        }
        catch (IOException iOException) {
            throw new WsBuildException("Failed to generate endpoint interface java file", iOException);
        }
    }

    String convertInnerClassString(String string) {
        return string.replace('$', '.');
    }
}

