/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.type;

import com.bea.staxb.buildtime.WildcardUtil;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.util.jam.JClass;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import weblogic.wsee.bind.buildtime.J2SBindingsBuilder;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.tools.jws.type.MethodProcessor;
import weblogic.wsee.util.Verbose;

public class DocLiteralWrapProcessor
extends MethodProcessor {
    private static final boolean IGNORE_WEBRESULT = Boolean.getBoolean("weblogic.wsee.jaxrpc.ignore.webresult");
    private static final boolean VERBOSE = Verbose.isVerbose(DocLiteralWrapProcessor.class);

    public DocLiteralWrapProcessor(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) {
        super(jAXRPCWebServiceInfo);
    }

    public void processMethod(WebMethodDecl webMethodDecl) throws WsBuildException {
        String string;
        Object object;
        WebParamDecl webParamDecl;
        int n = 73;
        J2SBindingsBuilder j2SBindingsBuilder = this.webServiceInfo.getBindingsBuilder();
        ArrayList<JClass> arrayList = new ArrayList<JClass>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
        JClass jClass = (JClass)webMethodDecl.getJMethod().getParent();
        while (iterator.hasNext()) {
            webParamDecl = iterator.next();
            if (webParamDecl.isHeader()) {
                j2SBindingsBuilder.javaTypeToSchemaElement(jClass, webParamDecl.getRealType(), webParamDecl.getElementQName(), 137);
                continue;
            }
            object = webParamDecl.getJParameter().getType();
            arrayList.add((JClass)object);
            string = object.getQualifiedName();
            if (!WildcardUtil.WILDCARD_CLASSNAMES.contains(string)) {
                if (VERBOSE) {
                    Verbose.log(" add actual message name for non-SOAPElement/XmlObject ->  any = '" + webParamDecl.getName() + "'");
                }
                arrayList2.add(webParamDecl.getWebTypeDeclName());
                continue;
            }
            if (webParamDecl.isBoundToAnyType()) {
                if (VERBOSE) {
                    Verbose.log(" add actual message name for SOAPElement/XmlObject ->  anyType = '" + webParamDecl.getName() + "'");
                }
                arrayList2.add(webParamDecl.getWebTypeDeclName());
                continue;
            }
            if (object.isArrayType()) {
                if (VERBOSE) {
                    Verbose.log(" add pseudo name for SOAPElement[]/XmlObject[] -> any ='" + XmlTypeName.forElementWildCardArrayElement().getQName().getLocalPart() + "'");
                }
                arrayList2.add(XmlTypeName.forElementWildCardArrayElement().getQName().getLocalPart());
                continue;
            }
            if (VERBOSE) {
                Verbose.log(" add pseudo name for SOAPElement/XmlObject -> any ='" + XmlTypeName.forElementWildCardElement().getQName().getLocalPart() + "'");
            }
            arrayList2.add(XmlTypeName.forElementWildCardElement().getQName().getLocalPart());
        }
        j2SBindingsBuilder.wrapJavaTypeToSchemaElement(jClass, arrayList.toArray(new JClass[0]), arrayList2.toArray(new String[0]), new QName(webMethodDecl.getWebService().getTargetNamespace(), webMethodDecl.getName()));
        this.registerParamTypes(jClass, webMethodDecl, n);
        if (!webMethodDecl.isOneway()) {
            webParamDecl = webMethodDecl.getJMethod().getReturnType();
            object = new QName(webMethodDecl.getWebService().getTargetNamespace(), webMethodDecl.getName() + "Response");
            if (webParamDecl != null && !webParamDecl.isVoidType()) {
                string = webMethodDecl.getWebResult().getName();
                if (!IGNORE_WEBRESULT && webMethodDecl.getWebResult().isAnnotationSet()) {
                    string = webMethodDecl.getWebResult().getWebTypeDeclName();
                }
                j2SBindingsBuilder.wrapJavaTypeToSchemaElement(jClass, new JClass[]{webParamDecl}, new String[]{string}, (QName)object);
                this.registerReturnTypes(jClass, webMethodDecl, n);
            } else {
                j2SBindingsBuilder.wrapJavaTypeToSchemaElement(jClass, new JClass[0], new String[0], (QName)object);
            }
        }
        this.processExceptionAsElement(webMethodDecl, n);
    }
}

