/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.type;

import java.util.Iterator;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.decl.CallbackServiceDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.tools.jws.type.DocLiteralBareProcessor;
import weblogic.wsee.tools.jws.type.DocLiteralWrapProcessor;
import weblogic.wsee.tools.jws.type.RpcProcessor;
import weblogic.wsee.tools.jws.type.SOAPBindingProcessor;

public class Java2SchemaProcessor
extends JAXRPCProcessor {
    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (jAXRPCWebServiceInfo.getWebService().getCowReader() != null) {
            return;
        }
        Java2SchemaDriver java2SchemaDriver = new Java2SchemaDriver(jAXRPCWebServiceInfo);
        java2SchemaDriver.drive(jAXRPCWebServiceInfo.getWebService());
        CallbackServiceDecl callbackServiceDecl = jAXRPCWebServiceInfo.getWebService().getCallbackService();
        if (callbackServiceDecl != null) {
            java2SchemaDriver.drive(callbackServiceDecl);
        }
    }

    private class Java2SchemaDriver {
        SOAPBindingProcessor doclitBare;
        SOAPBindingProcessor doclitWrap;
        SOAPBindingProcessor rpc;

        public Java2SchemaDriver(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) {
            this.doclitBare = new DocLiteralBareProcessor(jAXRPCWebServiceInfo);
            this.doclitWrap = new DocLiteralWrapProcessor(jAXRPCWebServiceInfo);
            this.rpc = new RpcProcessor(jAXRPCWebServiceInfo);
        }

        private void drive(WebServiceSEIDecl webServiceSEIDecl) throws WsBuildException {
            Iterator<WebMethodDecl> iterator = webServiceSEIDecl.getWebMethods();
            while (iterator.hasNext()) {
                WebMethodDecl webMethodDecl = iterator.next();
                if (webMethodDecl.getSoapBinding().isDocLiteralWrapped()) {
                    this.doclitWrap.processMethod(webMethodDecl);
                    continue;
                }
                if (webMethodDecl.getSoapBinding().isDocLiteralBare()) {
                    this.doclitBare.processMethod(webMethodDecl);
                    continue;
                }
                this.rpc.processMethod(webMethodDecl);
            }
        }
    }
}

