/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.type;

import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import javax.xml.namespace.QName;
import weblogic.wsee.bind.buildtime.J2SBindingsBuilder;
import weblogic.wsee.bind.buildtime.internal.WLW81TylarJ2SBindingsBuilderImpl;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.TypesUtil;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;
import weblogic.wsee.tools.jws.type.Java2SchemaProcessor;
import weblogic.wsee.tools.jws.type.SOAPBindingProcessor;
import weblogic.wsee.util.ExceptionUtil;
import weblogic.wsee.util.Verbose;

abstract class MethodProcessor
implements SOAPBindingProcessor {
    private static final boolean verbose = Verbose.isVerbose(Java2SchemaProcessor.class);
    JAXRPCWebServiceInfo webServiceInfo;

    public MethodProcessor(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) {
        this.webServiceInfo = jAXRPCWebServiceInfo;
    }

    void registerReturnTypes(JClass jClass, WebMethodDecl webMethodDecl, int n) throws WsBuildException {
        final J2SBindingsBuilder j2SBindingsBuilder = this.webServiceInfo.getBindingsBuilder();
        TypesUtil.ProcessStrategy processStrategy = new TypesUtil.ProcessStrategy(){

            public void process(JClass jClass, JClass jClass2, int n) {
                j2SBindingsBuilder.javaTypeToSchemaType(jClass, jClass2, n);
            }
        };
        TypesUtil.ReportStrategy reportStrategy = new TypesUtil.ReportStrategy(){

            public void report(JwsLogEvent jwsLogEvent) throws WsBuildException {
                if (!MethodProcessor.this.webServiceInfo.getWebService().isWlw81UpgradedService()) {
                    throw new WsBuildException(jwsLogEvent.toString());
                }
            }
        };
        TypesUtil.processReturnTypes(jClass, webMethodDecl, n, processStrategy, reportStrategy);
    }

    void registerParamTypes(JClass jClass, WebMethodDecl webMethodDecl, int n) throws WsBuildException {
        final J2SBindingsBuilder j2SBindingsBuilder = this.webServiceInfo.getBindingsBuilder();
        TypesUtil.ProcessStrategy processStrategy = new TypesUtil.ProcessStrategy(){

            public void process(JClass jClass, JClass jClass2, int n) {
                j2SBindingsBuilder.javaTypeToSchemaType(jClass, jClass2, n);
            }
        };
        TypesUtil.ReportStrategy reportStrategy = new TypesUtil.ReportStrategy(){

            public void report(JwsLogEvent jwsLogEvent) throws WsBuildException {
                if (!MethodProcessor.this.webServiceInfo.getWebService().isWlw81UpgradedService()) {
                    throw new WsBuildException(jwsLogEvent.toString());
                }
            }
        };
        TypesUtil.processParamTypes(jClass, webMethodDecl, n, processStrategy, reportStrategy);
    }

    void processExceptionAsType(WebMethodDecl webMethodDecl, int n) {
        this.processException(webMethodDecl, 5, true);
    }

    void processExceptionAsElement(WebMethodDecl webMethodDecl, int n) {
        this.processException(webMethodDecl, n, true);
    }

    void processException(WebMethodDecl webMethodDecl, int n, boolean bl) {
        J2SBindingsBuilder j2SBindingsBuilder = this.webServiceInfo.getBindingsBuilder();
        JClass[] jClassArray = webMethodDecl.getJMethod().getExceptionTypes();
        JMethod jMethod = webMethodDecl.getJMethod();
        JClass jClass = (JClass)jMethod.getParent();
        String string = null;
        if (j2SBindingsBuilder instanceof WLW81TylarJ2SBindingsBuilderImpl) {
            string = ((WLW81TylarJ2SBindingsBuilderImpl)j2SBindingsBuilder).getNamespaceFromServiceClass(jClass);
        }
        for (JClass jClass2 : jClassArray) {
            if (verbose) {
                Verbose.log("++++  processException " + jClass2);
            }
            if (ExceptionUtil.isUserException(jClass2)) {
                if (!bl) continue;
                QName qName = ExceptionUtil.getDefaultExceptionElement(jClass2, string);
                if (verbose) {
                    Verbose.log("++++  setting exception element name to " + qName);
                }
                j2SBindingsBuilder.javaTypeToSchemaElement(jClass, jClass2, qName, n);
                if (ExceptionUtil.isMarshalPropertyException(jClass2)) {
                    if (verbose) {
                        Verbose.log("++++ " + jClass2 + " is a MarshalPropertyException  ");
                    }
                    QName qName2 = ExceptionUtil.exceptionMarshalPropertyElementName(jClass, jClass2);
                    JClass jClass3 = ExceptionUtil.getMarshalPropertyJClass(jClass2);
                    if (verbose) {
                        Verbose.log("++++  setting singleBuiltin element name to " + qName2 + ", for marshalPropertyJClass '" + jClass3 + "'");
                    }
                    j2SBindingsBuilder.javaTypeToSchemaElement(jClass, jClass3, qName2, n);
                    continue;
                }
                if (!verbose) continue;
                Verbose.log("++++ exception '" + jClass2 + "'  is NOT a marshalPropertyException.");
                continue;
            }
            if (!verbose) continue;
            Verbose.log("++++ exception '" + jClass2 + "'  is NOT a ServiceSpecificException.");
        }
    }
}

