/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JMethod;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.Oneway;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import weblogic.jws.CallbackService;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.WebTypeDecl;
import weblogic.wsee.tools.jws.validation.BaseValidator;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.XBeanUtil;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEIValidator
extends BaseValidator<WebServiceSEIDecl> {
    private static final Class[] orphanAnns = new Class[]{Oneway.class, WebResult.class};
    protected Map<String, HashSet<QName>> soapDispatchNames = new HashMap<String, HashSet<QName>>();
    protected Map<QName, String> resultElementNames = new HashMap<QName, String>();
    private Set<WebMethodDecl> visitedWebMethods = new HashSet<WebMethodDecl>();
    private boolean strict = false;
    protected static final String SOAPELEMENT_CLASSNAME = SOAPElement.class.getName();

    protected BaseEIValidator(JwsBuildContext jwsBuildContext, WebServiceSEIDecl webServiceSEIDecl) {
        super(jwsBuildContext, webServiceSEIDecl);
        this.strict = jwsBuildContext.getTask() == JwsBuildContext.Task.JWSC;
    }

    public final void visit(JClass jClass) {
        if (jClass == null || jClass.isUnresolvedType()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.class.unknown", jClass.getQualifiedName()));
        } else {
            this.checkPackageName(jClass);
            this.checkTypeAnnotation(jClass);
            this.checkHandlerChain(jClass);
            this.checkDuplicateOperations(jClass);
            this.visitImpl(jClass);
        }
    }

    protected abstract void visitImpl(JClass var1);

    protected boolean isSeparateEI() {
        if (!StringUtil.isEmpty(((WebServiceSEIDecl)this.webService).getEndPointInterface())) {
            return true;
        }
        return ((WebServiceSEIDecl)this.webService).getJClass() == ((WebServiceSEIDecl)this.webService).getEIClass() && ((WebServiceSEIDecl)this.webService).getJClass().isInterface();
    }

    protected void checkTypeAnnotation(JClass jClass) {
        JAnnotation jAnnotation;
        if (this.isSeparateEI()) {
            if (!jClass.isInterface()) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ei.EINotInterface", jClass.getQualifiedName()));
            }
            if ((jAnnotation = jClass.getAnnotation(WebService.class)) == null) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ei.noWebService", jClass.getQualifiedName()));
            } else {
                String string;
                String string2 = JamUtil.getAnnotationStringValue(jAnnotation, "endpointInterface");
                if (!StringUtil.isEmpty(string2)) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ei.EIDeclaresEI", jClass.getQualifiedName()));
                }
                if (!StringUtil.isEmpty(string = JamUtil.getAnnotationStringValue(jAnnotation, "serviceName"))) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ei.EIDeclaresServiceName", jClass.getQualifiedName()));
                }
            }
        }
        if ((jAnnotation = jClass.getAnnotation(CallbackService.class)) != null) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ei.declaresCallbackService", jClass.getQualifiedName()));
        }
    }

    private void checkDuplicateOperations(JClass jClass) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<WebMethodDecl> iterator = ((WebServiceSEIDecl)this.webService).getWebMethods();
        while (iterator.hasNext()) {
            WebMethodDecl webMethodDecl = iterator.next();
            if (hashSet.contains(webMethodDecl.getName())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.operationName.duplicate", webMethodDecl.getName()));
            }
            hashSet.add(webMethodDecl.getName());
        }
    }

    private void checkPackageName(JClass jClass) {
        if (!StringUtil.isLowerCase(jClass.getContainingPackage().getQualifiedName())) {
            this.getLogger().log(EventLevel.WARNING, new JwsLogEvent((JElement)jClass, "type.pkg.upperCasedPackage", jClass.getQualifiedName()));
        }
        if (StringUtil.isEmpty(((WebServiceSEIDecl)this.webService).getPackageName())) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.package.missing", new Object[0]));
        }
    }

    private void checkResult(JMethod jMethod, WebMethodDecl webMethodDecl) {
        this.checkResultName(jMethod, webMethodDecl);
    }

    public final void visit(JMethod jMethod) {
        WebMethodDecl webMethodDecl = ((WebServiceSEIDecl)this.webService).getWebMethod(jMethod);
        if (this.visitedWebMethods.contains(webMethodDecl)) {
            return;
        }
        if (webMethodDecl == null) {
            this.chceckForOrphans(jMethod);
        } else {
            this.checkPublic(jMethod);
            this.checkOneway(jMethod, webMethodDecl);
            this.checkSoapDispatchName(jMethod, webMethodDecl);
            this.checkSoapBinding(jMethod);
            this.checkParams(jMethod, webMethodDecl);
            if (this.strict) {
                this.checkBareParam(jMethod, webMethodDecl);
                this.checkResult(jMethod, webMethodDecl);
            }
            this.visitImpl(webMethodDecl);
            Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
            while (iterator.hasNext()) {
                WebParamDecl webParamDecl = iterator.next();
                this.checkParam(webParamDecl, jMethod, webMethodDecl);
                this.visitImpl(webParamDecl);
            }
            this.visitedWebMethods.add(webMethodDecl);
        }
    }

    protected abstract void visitImpl(WebMethodDecl var1);

    protected abstract void visitImpl(WebParamDecl var1);

    private void checkSoapBinding(JMethod jMethod) {
        JAnnotation jAnnotation;
        JAnnotation jAnnotation2 = jMethod.getAnnotation(SOAPBinding.class);
        if (jAnnotation2 != null && (jAnnotation = jMethod.getAnnotation(weblogic.jws.soap.SOAPBinding.class)) != null) {
            if (JamUtil.equals(jAnnotation2, jAnnotation)) {
                this.getLogger().log(EventLevel.WARNING, new JwsLogEvent((JElement)jMethod, "method.soapBinding.duplicate", jMethod.getQualifiedName(), SOAPBinding.class.getName(), weblogic.jws.soap.SOAPBinding.class.getName()));
            } else {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.soapBinding.different", jMethod.getQualifiedName(), SOAPBinding.class.getName(), weblogic.jws.soap.SOAPBinding.class.getName()));
            }
        }
    }

    private void chceckForOrphans(JMethod jMethod) {
        for (Class clazz : orphanAnns) {
            if (jMethod.getAnnotation(clazz) == null) continue;
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.noWebMethod", clazz.getName()));
        }
    }

    private void checkParams(JMethod jMethod, WebMethodDecl webMethodDecl) {
        if (webMethodDecl.getSoapBinding().isDocLiteralWrapped()) {
            this.checkUniqueParamElementQNames(jMethod, webMethodDecl);
        }
    }

    private void checkUniqueParamElementQNames(JMethod jMethod, WebMethodDecl webMethodDecl) {
        HashSet<QName> hashSet = new HashSet<QName>();
        Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
        while (iterator.hasNext()) {
            WebParamDecl webParamDecl = iterator.next();
            if (hashSet.contains(webParamDecl.getElementQName())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "parameter.binding.nonUniqueParameterElementName", webParamDecl.getName(), webParamDecl.getElementQName(), jMethod.getSimpleName()));
            }
            hashSet.add(webParamDecl.getElementQName());
        }
    }

    protected void checkParam(WebParamDecl webParamDecl, JMethod jMethod, WebMethodDecl webMethodDecl) {
        if (webParamDecl.getTypeFamily() != WebTypeDecl.TypeFamily.POJO) {
            if (((WebServiceSEIDecl)this.webService).getType() == WebServiceType.JAXWS) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.jaxws.xmlBeanNotSupported", new Object[0]));
            } else if (!webMethodDecl.getSoapBinding().isDocumentStyle() && webMethodDecl.getSoapBinding().isLiteral()) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.rpc.xmlBeanNotSupported", new Object[0]));
            } else {
                JAnnotation jAnnotation = webParamDecl.getJParameter().getAnnotation(WebParam.class);
                if (webParamDecl.getTypeFamily() == WebTypeDecl.TypeFamily.XML_BEAN_DOCUMENT && jAnnotation != null) {
                    this.checkXmlBeanDocument((JAnnotatedElement)jMethod, webParamDecl.getJParameter().getType(), jAnnotation);
                }
            }
        }
        if (webParamDecl.getMode() != WebParam.Mode.IN) {
            this.checkOutParam(webParamDecl, webMethodDecl);
        }
    }

    private void checkSoapDispatchName(JMethod jMethod, WebMethodDecl webMethodDecl) {
        QName qName = webMethodDecl.getSoapDispatchName();
        if (qName != null) {
            String string = webMethodDecl.getAction();
            HashSet<QName> hashSet = this.soapDispatchNames.get(string);
            if (hashSet == null) {
                hashSet = new HashSet();
                this.soapDispatchNames.put(string, hashSet);
            }
            if (hashSet.contains(qName)) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "type.soapDispatchName.duplicate", qName));
            }
            hashSet.add(qName);
        }
    }

    private void checkResultName(JMethod jMethod, WebMethodDecl webMethodDecl) {
        if (webMethodDecl.getSoapBinding().isDocumentStyle() && webMethodDecl.getWebResult().hasReturn()) {
            String string;
            QName qName = webMethodDecl.getResultElementQName();
            String string2 = webMethodDecl.getWebResult().getType();
            if (this.resultElementNames.containsKey(qName) && !(string = this.resultElementNames.get(qName)).equals(string2)) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "result.elementName.duplicate", qName));
            }
            this.resultElementNames.put(qName, string2);
        }
    }

    private void checkOutParam(WebParamDecl webParamDecl, WebMethodDecl webMethodDecl) {
        if (webMethodDecl.isOneway()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "parameter.oneway.invalidMode", new Object[0]));
        } else if (!webParamDecl.isHolderType()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "parameter.binding.holderRequired", webParamDecl.getParameterName()));
        }
    }

    private void checkXmlBeanDocument(JAnnotatedElement jAnnotatedElement, JClass jClass, JAnnotation jAnnotation) {
        QName qName = XBeanUtil.getQNameFromXmlBean(this.getClassLoader(), jClass.getQualifiedName());
        if (qName != null) {
            String string = JamUtil.getAnnotationStringValue(jAnnotation, "name");
            String string2 = JamUtil.getAnnotationStringValue(jAnnotation, "targetNamespace");
            if (!StringUtil.isEmpty(string) && !string.equals(qName.getLocalPart())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "parameter.xmlbean.invalidName", jAnnotation.getQualifiedName(), string, qName.getLocalPart()));
            }
            if (!StringUtil.isEmpty(string2) && !string2.equals(qName.getNamespaceURI())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "parameter.xmlbean.invalidNamespace", jAnnotation.getQualifiedName(), string2, qName.getNamespaceURI()));
            }
        }
    }

    private void checkPublic(JMethod jMethod) {
        if (!jMethod.isPublic()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.notPublic", jMethod.getSimpleName()));
        }
    }

    private void checkBareParam(JMethod jMethod, WebMethodDecl webMethodDecl) {
        if (webMethodDecl.getSoapBinding().isDocumentStyle() && !webMethodDecl.getSoapBinding().isWrapped()) {
            List<WebParamDecl> list = webMethodDecl.getParameters(WebParam.Mode.IN);
            int n = webMethodDecl.getParameters(WebParam.Mode.OUT).size();
            if (webMethodDecl.getWebResult().hasReturn()) {
                ++n;
            }
            if (list.size() > 1) {
                int n2 = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (this.isAttachmentParam(list.get(i))) continue;
                    ++n2;
                }
                if (n2 > 1) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.bare.invalidNumberOfParameters", new Object[0]));
                }
            }
            if (n > 1) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.bare.invalidNumberOfResults", new Object[0]));
            }
        }
    }

    private boolean isAttachmentParam(WebParamDecl webParamDecl) {
        String string = webParamDecl.getRealType().getQualifiedName();
        return "javax.activation.DataHandler".equals(string) || "javax.activation.DataHandler[]".equals(string) || "javax.xml.transform.Source".equals(string) || "javax.xml.transform.Source[]".equals(string) || "javax.mail.internet.MimeMultipart".equals(string) || "javax.mail.internet.MimeMultipart[]".equals(string) || "java.awt.Image".equals(string) || "java.awt.Image[]".equals(string);
    }

    private void checkOneway(JMethod jMethod, WebMethodDecl webMethodDecl) {
        boolean bl = jMethod.getReturnType().isVoidType();
        if (webMethodDecl.isOneway()) {
            if (!bl) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.oneway.mustReturnVoid", new Object[0]));
            } else if (webMethodDecl.getParameters(WebParam.Mode.OUT).size() != 0) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.oneway.noOutputAllowed", new Object[0]));
            }
            if (this.strict) {
                this.checkCheckedExceptions(jMethod);
            }
        } else if (webMethodDecl.getSoapBinding().isDocLiteralBare() && webMethodDecl.getParameters(WebParam.Mode.OUT).size() == 0 && bl && (((WebServiceSEIDecl)this.webService).getCowReader() == null || !this.hasEmptyOutput(webMethodDecl))) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.bare.mustBeOneway", new Object[0]));
        }
    }

    private boolean hasEmptyOutput(WebMethodDecl webMethodDecl) {
        WsdlDefinitions wsdlDefinitions = this.getDefinitions();
        if (wsdlDefinitions != null) {
            WsdlPortType wsdlPortType = wsdlDefinitions.getPortTypes().get(((WebServiceSEIDecl)this.webService).getPortTypeQName());
            assert (wsdlPortType != null) : "Port type " + ((WebServiceSEIDecl)this.webService).getPortType() + " not found";
            WsdlOperation wsdlOperation = wsdlPortType.getOperations().get(new QName(((WebServiceSEIDecl)this.webService).getPortTypeNamespaceURI(), webMethodDecl.getName()));
            assert (wsdlOperation != null) : "Operation " + webMethodDecl.getName() + " not found";
            WsdlMessage wsdlMessage = wsdlOperation.getOutput();
            if (wsdlMessage != null && !wsdlMessage.getParts().values().iterator().hasNext()) {
                return true;
            }
        }
        return false;
    }

    private WsdlDefinitions getDefinitions() {
        WsdlDefinitions wsdlDefinitions = null;
        try {
            wsdlDefinitions = ((WebServiceSEIDecl)this.webService).getCowReader().getWsdl(((WebServiceSEIDecl)this.webService).getWsdlLocation());
        }
        catch (WsdlException wsdlException) {
            // empty catch block
        }
        return wsdlDefinitions;
    }

    private void checkCheckedExceptions(JMethod jMethod) {
        JClass[] jClassArray = jMethod.getExceptionTypes();
        if (jClassArray.length > 0) {
            JClass jClass = jMethod.getContainingClass().getClassLoader().loadClass(Error.class.getName());
            JClass jClass2 = jMethod.getContainingClass().getClassLoader().loadClass(RuntimeException.class.getName());
            JClass jClass3 = jMethod.getContainingClass().getClassLoader().loadClass(RemoteException.class.getName());
            for (int i = 0; i < jClassArray.length; ++i) {
                JClass jClass4 = jClassArray[i];
                if (jClass.isAssignableFrom(jClass4) || jClass2.isAssignableFrom(jClass4) || jClass3.isAssignableFrom(jClass4)) continue;
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.exception.onewayDeclaresChecked", new Object[0]));
                return;
            }
        }
    }

    @Override
    protected JClass getVisitee() {
        return ((WebServiceSEIDecl)this.webService).getEIClass();
    }
}

