/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JConstructor;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JField;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.JParameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPMessageHandlers;
import weblogic.jws.Binding;
import weblogic.jws.Conversation;
import weblogic.jws.MessageBuffer;
import weblogic.jws.Policies;
import weblogic.jws.Policy;
import weblogic.wsee.conversation.ConversationUtils;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.jws.validation.BaseValidator;
import weblogic.wsee.tools.jws.validation.annotation.NoAnnotationValidator;
import weblogic.wsee.tools.jws.validation.annotation.PackageMatchingRule;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.LogEvent;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSBValidator
extends BaseValidator<WebServiceSEIDecl> {
    private static final Class[] orphanAnns = new Class[]{MessageBuffer.class, Conversation.class, Policy.class, Policies.class};
    private boolean eiValid = true;

    protected BaseSBValidator(JwsBuildContext jwsBuildContext, WebServiceSEIDecl webServiceSEIDecl, boolean bl) {
        super(jwsBuildContext, webServiceSEIDecl);
        this.eiValid = bl;
    }

    public final void visit(JClass jClass) {
        if (jClass == null || jClass.isUnresolvedType()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.class.unknown", jClass.getQualifiedName()));
        } else {
            this.checkClass(jClass);
            this.checkPackage(jClass);
            this.validateJwsAnnotations(jClass);
            this.checkPorts(jClass);
            this.checkEI(jClass);
            this.checkHandlerChain(jClass);
            this.visitImpl(jClass);
        }
    }

    protected abstract void visitImpl(JClass var1);

    @Override
    protected NoAnnotationValidator getNoAnnotationValidator(Logger logger) {
        NoAnnotationValidator noAnnotationValidator = new NoAnnotationValidator(logger);
        if (!StringUtil.isEmpty(((WebServiceSEIDecl)this.webService).getEndPointInterface())) {
            noAnnotationValidator.addMatchingRule(new PackageMatchingRule(WebService.class.getPackage().getName(), new Class[]{WebService.class, HandlerChain.class}));
            noAnnotationValidator.addMatchingRule(new PackageMatchingRule(SOAPBinding.class.getPackage().getName(), new Class[]{SOAPBinding.class, SOAPMessageHandlers.class}));
            noAnnotationValidator.addExcludeClass(((WebServiceSEIDecl)this.webService).getEIClass());
        }
        return noAnnotationValidator;
    }

    public final void visit(JField jField) {
        this.visitImpl(jField);
    }

    protected abstract void visitImpl(JField var1);

    public final void visit(JMethod jMethod) {
        WebMethodDecl webMethodDecl = ((WebServiceSEIDecl)this.webService).getWebMethod(jMethod);
        if (webMethodDecl == null) {
            this.chceckForOrphans(jMethod);
        } else {
            this.visitImpl(webMethodDecl);
        }
    }

    protected abstract void visitImpl(WebMethodDecl var1);

    private void validateJwsAnnotations(JClass jClass) {
        JAnnotation jAnnotation;
        Object object;
        Object object2;
        String string;
        JAnnotation jAnnotation2 = jClass.getAnnotation(WebService.class);
        if (jAnnotation2 == null) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.sb.noWebService", jClass.getQualifiedName()));
        }
        if (((WebServiceSEIDecl)this.webService).getCowReader() != null) {
            if (this.isAnnotationPresent(jClass, Conversation.class)) {
                boolean bl = true;
                string = ((WebServiceSEIDecl)this.webService).getWsdlLocation();
                if (!StringUtil.isEmpty(string)) {
                    try {
                        object2 = ((WebServiceSEIDecl)this.webService).getCowReader().getWsdl(string).getPorts().get(((WebServiceSEIDecl)this.webService).getPortQName()).getBinding();
                        bl = ConversationUtils.isConversational((WsdlBinding)object2);
                    }
                    catch (WsdlException wsdlException) {
                        object = new JwsLogEvent((JElement)jClass, "annotation.Conversation.check.wsdl", new Object[0]);
                        ((LogEvent)object).setException(wsdlException);
                        this.getLogger().log(EventLevel.VERBOSE, (LogEvent)object);
                    }
                }
                if (bl) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "annotation.Conversation.notAllowed", new Object[0]));
                }
            }
            if (this.isAnnotationPresent(jClass, Policy.class) || this.isAnnotationPresent(jClass, Policies.class)) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "annotation.Policy.notAllowed", new Object[0]));
            }
        }
        if ((jAnnotation = jClass.getAnnotation(Binding.class)) != null && Binding.Type.SOAP12.toString().equals(jAnnotation.getValue("value").asString()) && (string = jClass.getAnnotation(SOAPBinding.class)) != null) {
            object2 = JamUtil.getAnnotationStringValue((JAnnotation)string, "style");
            object = JamUtil.getAnnotationStringValue((JAnnotation)string, "use");
            if ("rpc".equalsIgnoreCase((String)object2) && "encoded".equalsIgnoreCase((String)object)) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "bindingType.soap12", new Object[0]));
            }
        }
    }

    private boolean isAnnotationPresent(JClass jClass, Class clazz) {
        if (jClass.getAnnotation(clazz) != null) {
            return true;
        }
        JMethod[] jMethodArray = jClass.getMethods();
        for (int i = 0; i < jMethodArray.length; ++i) {
            if (jMethodArray[i].getAnnotation(clazz) == null) continue;
            return true;
        }
        return false;
    }

    private void checkPackage(JClass jClass) {
        if (!StringUtil.isLowerCase(jClass.getContainingPackage().getQualifiedName())) {
            this.getLogger().log(EventLevel.WARNING, new JwsLogEvent((JElement)jClass, "type.pkg.upperCasedPackage", jClass.getQualifiedName()));
        }
    }

    private void checkEI(JClass jClass) {
        if (!StringUtil.isEmpty(((WebServiceSEIDecl)this.webService).getEndPointInterface())) {
            String string;
            String string2;
            JAnnotation jAnnotation;
            String string3;
            if (!this.eiValid) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.sb.EIInvalid", ((WebServiceSEIDecl)this.webService).getEndPointInterface()));
            }
            if (!StringUtil.isEmpty(string3 = JamUtil.getAnnotationStringValue(jAnnotation = jClass.getAnnotation(WebService.class), "name"))) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.sb.EICheck", new Object[0]));
            }
            if (!(StringUtil.isEmpty(string2 = JamUtil.getAnnotationStringValue(jAnnotation, "wsdlLocation")) || StringUtil.isEmpty(string = JamUtil.getAnnotationStringValue(jAnnotation = ((WebServiceSEIDecl)this.webService).getEIClass().getAnnotation(WebService.class), "wsdlLocation")) || string.equals(string2))) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.sb.wsdlLocationDeclaredTwice", new Object[0]));
            }
        }
    }

    private void chceckForOrphans(JMethod jMethod) {
        for (Class clazz : orphanAnns) {
            if (jMethod.getAnnotation(clazz) == null) continue;
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.noWebMethod", clazz.getName()));
        }
    }

    private void checkClass(JClass jClass) {
        if (jClass.isInterface()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.class.SBNotFound", new Object[0]));
        }
        if (!jClass.isPublic()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.class.isNotPublic", new Object[0]));
        }
        if (jClass.isAbstract()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.class.isAbstract", new Object[0]));
        }
        if (jClass.isFinal()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.class.isFinal", new Object[0]));
        }
        if (!BaseSBValidator.hasDefaultConstructor(jClass)) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.class.noDefaultConstructor", new Object[0]));
        }
        if (BaseSBValidator.hasFinalizeMethod(jClass)) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.class.hasFinalize", new Object[0]));
        }
    }

    private static boolean hasFinalizeMethod(JClass jClass) {
        int n = 0;
        JMethod[] jMethodArray = jClass.getDeclaredMethods();
        JMethod[] jMethodArray2 = jMethodArray;
        int n2 = jMethodArray2.length;
        if (n < n2) {
            JMethod jMethod = jMethodArray2[n];
            return JamUtil.isFinalizeMethod(jMethod);
        }
        return false;
    }

    private static boolean hasDefaultConstructor(JClass jClass) {
        JConstructor[] jConstructorArray = jClass.getConstructors();
        for (int i = 0; i < jConstructorArray.length; ++i) {
            JConstructor jConstructor = jConstructorArray[i];
            JParameter[] jParameterArray = jConstructor.getParameters();
            if (!jConstructor.isPublic() || jParameterArray != null && jParameterArray.length != 0) continue;
            return true;
        }
        return false;
    }

    private void checkPorts(JClass jClass) {
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        HashSet<String> hashSet2 = new HashSet<String>();
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        Iterator<PortDecl> iterator = ((WebServiceSEIDecl)this.webService).getPorts();
        while (iterator.hasNext()) {
            String string2;
            PortDecl portDecl = iterator.next();
            if (hashSet.contains(portDecl.getPortName())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ports.portNameNotUnique", portDecl.getProtocol(), portDecl.getPortName()));
            }
            hashSet.add(portDecl.getPortName());
            if (!((WebServiceSEIDecl)this.webService).isEjb()) {
                if (string == null) {
                    string = portDecl.getContextPath();
                } else if (!string.equals(portDecl.getContextPath())) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ports.contextPathNotIdentical", new Object[0]));
                }
            }
            if (hashSet2.contains(string2 = portDecl.getURI())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ports.uriNotUnique", string2));
            }
            hashSet2.add(string2);
            if (((WebServiceSEIDecl)this.webService).getCallbackService() != null) {
                this.checkPortPath(portDecl, hashMap, jClass, "type.ports.callback.contextPathServiceUriNotUnique");
                continue;
            }
            this.checkPortPath(portDecl, hashMap, jClass, "type.ports.contextPathServiceUriNotUnique");
        }
    }

    private void checkPortPath(PortDecl portDecl, Map<String, Set<String>> map, JClass jClass, String string) {
        String string2 = portDecl.getNormalizedPath();
        if (map.keySet().contains(string2) && (map.get(string2).contains("http") && portDecl.getProtocol().equals("https") || map.get(string2).contains("https") && portDecl.getProtocol().equals("http"))) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, string, string2));
        }
        if (!map.keySet().contains(string2)) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(portDecl.getProtocol());
            map.put(string2, hashSet);
        } else {
            Set<String> set = map.get(string2);
            set.add(portDecl.getProtocol());
            map.put(string2, set);
        }
    }

    @Override
    protected JClass getVisitee() {
        return ((WebServiceSEIDecl)this.webService).getJClass();
    }
}

