/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation;

import com.bea.util.jam.JClass;
import com.bea.util.jam.visitor.JVisitor;
import com.bea.util.jam.visitor.TraversingJVisitor;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.validation.HandlerChainValidator;
import weblogic.wsee.tools.jws.validation.Validator;
import weblogic.wsee.tools.jws.validation.annotation.NoAnnotationValidator;
import weblogic.wsee.tools.logging.CompositeLogger;
import weblogic.wsee.tools.logging.CountLogger;
import weblogic.wsee.tools.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseValidator<T extends WebServiceDecl>
extends JVisitor
implements Validator {
    protected final T webService;
    private final JwsBuildContext ctx;
    private CountLogger countLogger = new CountLogger();
    private CompositeLogger compositeLogger = new CompositeLogger();

    protected BaseValidator(JwsBuildContext jwsBuildContext, T t) {
        this.ctx = jwsBuildContext;
        this.webService = t;
        this.compositeLogger.addLogger(jwsBuildContext.getLogger());
        this.compositeLogger.addLogger(this.countLogger);
    }

    protected void checkHandlerChain(JClass jClass) {
        HandlerChainValidator handlerChainValidator = new HandlerChainValidator((WebServiceDecl)this.webService, this.compositeLogger, this.ctx.getClassLoader(), this.ctx.getSourcepath());
        handlerChainValidator.validate(jClass);
    }

    @Override
    public boolean validate() {
        TraversingJVisitor traversingJVisitor = new TraversingJVisitor((JVisitor)this);
        this.getVisitee().accept((JVisitor)traversingJVisitor);
        NoAnnotationValidator noAnnotationValidator = this.getNoAnnotationValidator(this.compositeLogger);
        if (noAnnotationValidator != null && !noAnnotationValidator.isEmpty()) {
            traversingJVisitor = new TraversingJVisitor((JVisitor)noAnnotationValidator);
            this.getVisitee().accept((JVisitor)traversingJVisitor);
        }
        return this.countLogger.getErrorCount() == 0;
    }

    protected Logger getLogger() {
        return this.compositeLogger;
    }

    protected ClassLoader getClassLoader() {
        return this.ctx.getClassLoader();
    }

    protected abstract NoAnnotationValidator getNoAnnotationValidator(Logger var1);

    protected abstract JClass getVisitee();
}

