/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation;

import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.soap.SOAPMessageHandlers;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;

class HandlerChainValidator {
    private final Logger logger;
    private final WebServiceDecl webService;
    private final ClassLoader classLoader;
    private final String[] sourcepath;

    HandlerChainValidator(WebServiceDecl webServiceDecl, Logger logger, ClassLoader classLoader, String[] stringArray) {
        this.logger = logger;
        this.webService = webServiceDecl;
        this.classLoader = classLoader;
        this.sourcepath = stringArray;
    }

    void validate(JClass jClass) {
        if (jClass.getAnnotation(HandlerChain.class) != null && jClass.getAnnotation(SOAPMessageHandlers.class) != null) {
            this.logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.handlerchain.duplicate", new Object[0]));
        }
        Map<EventLevel, List<JwsLogEvent>> map = this.webService.getHandlerChainDecl().getLogEvents();
        for (EventLevel eventLevel : map.keySet()) {
            for (JwsLogEvent object : map.get((Object)eventLevel)) {
                this.logger.log(eventLevel, object);
            }
        }
        for (String string : this.webService.getHandlerChainDecl().getHandlerClassNames()) {
            if (this.findHandlerClass(string)) continue;
            this.logger.log(EventLevel.WARNING, new JwsLogEvent((JElement)jClass, "type.handlerchain.classNotFound", string));
        }
    }

    private boolean findHandlerClass(String string) {
        boolean bl = false;
        if (this.classLoader != null) {
            bl = this.findClass(string);
        }
        if (!bl && this.sourcepath != null) {
            bl = this.findSource(string);
        }
        return bl;
    }

    private boolean findSource(String string) {
        String string2 = string.replace('.', '/') + ".java";
        for (String string3 : this.sourcepath) {
            File file = new File(string3, string2);
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    private boolean findClass(String string) {
        try {
            this.classLoader.loadClass(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

