/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation.annotation;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JField;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.JParameter;
import com.bea.util.jam.visitor.JVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.validation.annotation.MatchingRule;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;

public class NoAnnotationValidator
extends JVisitor {
    private final Logger logger;
    private List<MatchingRuleValidator> matchingRules = new ArrayList<MatchingRuleValidator>();
    private Set<String> excludeClasses = new HashSet<String>();
    private final String defaultKey;

    public NoAnnotationValidator(Logger logger) {
        this(logger, "annotation.notAllowed");
    }

    public NoAnnotationValidator(Logger logger, String string) {
        assert (logger != null) : "Logger not specified";
        assert (string != null) : "Error defaultKey not specified";
        this.logger = logger;
        this.defaultKey = string;
    }

    public boolean isEmpty() {
        return this.matchingRules.isEmpty();
    }

    public void addMatchingRule(MatchingRule matchingRule) {
        this.addMatchingRule(this.defaultKey, matchingRule);
    }

    public void addMatchingRule(String string, MatchingRule matchingRule) {
        assert (matchingRule != null) : "No rule specified";
        this.matchingRules.add(new MatchingRuleValidator(string, matchingRule));
    }

    public void addExcludeClass(JClass jClass) {
        assert (jClass != null) : "No exclude class specified";
        for (JClass jClass2 = jClass; jClass2 != null; jClass2 = jClass2.getSuperclass()) {
            this.excludeClasses.add(jClass2.getQualifiedName());
            for (JClass jClass3 : jClass.getInterfaces()) {
                this.excludeClasses.add(jClass3.getQualifiedName());
            }
        }
    }

    public void visit(JClass jClass) {
        if (!this.isExcluded(jClass)) {
            this.findAnnotations((JAnnotatedElement)jClass);
        }
    }

    public void visit(JMethod jMethod) {
        if (!this.isExcluded(jMethod.getContainingClass())) {
            this.findAnnotations((JAnnotatedElement)jMethod);
        }
    }

    public void visit(JParameter jParameter) {
        JMethod jMethod;
        JElement jElement = jParameter.getParent();
        if (jElement instanceof JMethod && !this.isExcluded((jMethod = (JMethod)jElement).getContainingClass())) {
            this.findAnnotations((JAnnotatedElement)jParameter);
        }
    }

    public void visit(JField jField) {
        if (!this.isExcluded(jField.getContainingClass())) {
            this.findAnnotations((JAnnotatedElement)jField);
        }
    }

    private boolean isExcluded(JClass jClass) {
        return this.excludeClasses.contains(jClass.getQualifiedName());
    }

    private void findAnnotations(JAnnotatedElement jAnnotatedElement) {
        JAnnotation[] jAnnotationArray;
        for (JAnnotation jAnnotation : jAnnotationArray = jAnnotatedElement.getAnnotations()) {
            for (MatchingRuleValidator matchingRuleValidator : this.matchingRules) {
                matchingRuleValidator.validate(jAnnotatedElement, jAnnotation);
            }
        }
    }

    private class MatchingRuleValidator {
        private MatchingRule rule;
        private String key;

        private MatchingRuleValidator(String string, MatchingRule matchingRule) {
            this.key = string;
            this.rule = matchingRule;
        }

        private void validate(JAnnotatedElement jAnnotatedElement, JAnnotation jAnnotation) {
            if (this.rule.isMatch(jAnnotation)) {
                JAnnotatedElement jAnnotatedElement2 = this.getLogElement(jAnnotatedElement);
                NoAnnotationValidator.this.logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement2, this.key, jAnnotation.getQualifiedName(), jAnnotatedElement2.getQualifiedName()));
            }
        }

        private JAnnotatedElement getLogElement(JAnnotatedElement jAnnotatedElement) {
            if (jAnnotatedElement instanceof JParameter) {
                return (JAnnotatedElement)((JParameter)jAnnotatedElement).getParent();
            }
            return jAnnotatedElement;
        }
    }
}

