/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation.annotation;

import com.bea.util.jam.JAnnotation;
import java.util.HashSet;
import java.util.Set;
import weblogic.wsee.tools.jws.validation.annotation.MatchingRule;
import weblogic.wsee.util.StringUtil;

public class PackageMatchingRule
implements MatchingRule {
    private final String packageName;
    private final boolean recursive;
    private final Set<String> excludeAnnotations = new HashSet<String>();

    public PackageMatchingRule(String string) {
        this(string, false);
    }

    public PackageMatchingRule(String string, boolean bl) {
        this(string, null, bl);
    }

    public PackageMatchingRule(String string, Class[] classArray) {
        this(string, classArray, false);
    }

    public PackageMatchingRule(String string, Class[] classArray, boolean bl) {
        assert (string != null) : "Package name not specified";
        this.packageName = string;
        this.recursive = bl;
        if (classArray != null) {
            for (Class clazz : classArray) {
                this.excludeAnnotations.add(clazz.getName());
            }
        }
    }

    public boolean isMatch(JAnnotation jAnnotation) {
        if (this.excludeAnnotations.contains(jAnnotation.getQualifiedName())) {
            return false;
        }
        String string = StringUtil.getPackage(jAnnotation.getQualifiedName());
        boolean bl = string.equals(this.packageName);
        if (!bl && this.recursive) {
            bl = string.startsWith(this.packageName + '.');
        }
        return bl;
    }
}

