/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation.jaxrpc;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JMethod;
import java.util.HashSet;
import java.util.Iterator;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import weblogic.jws.Binding;
import weblogic.jws.BufferQueue;
import weblogic.jws.CallbackService;
import weblogic.jws.Conversation;
import weblogic.jws.Conversational;
import weblogic.jws.MessageBuffer;
import weblogic.jws.wlw.UseWLW81BindingTypes;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.CallbackServiceDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.validation.annotation.AnnotationMatchingRule;
import weblogic.wsee.tools.jws.validation.annotation.NoAnnotationValidator;
import weblogic.wsee.tools.jws.validation.annotation.PackageMatchingRule;
import weblogic.wsee.tools.jws.validation.jaxrpc.EIValidator;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wsdl.soap11.SoapBinding;

public class CallbackValidator
extends EIValidator {
    private final WebServiceDecl parentWebServiceDecl;

    public CallbackValidator(JwsBuildContext jwsBuildContext, CallbackServiceDecl callbackServiceDecl) {
        super(jwsBuildContext, callbackServiceDecl);
        this.parentWebServiceDecl = callbackServiceDecl.getParentWebService();
    }

    protected void checkTypeAnnotation(JClass jClass) {
        JAnnotation jAnnotation = jClass.getAnnotation(CallbackService.class);
        if (jAnnotation == null) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.callback.noCallbackService", jClass.getQualifiedName()));
        }
        if (!this.parentWebServiceDecl.getTargetNamespace().equals(((WebServiceSEIDecl)this.webService).getTargetNamespace())) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.callback.invalidTargetNamespace", jClass.getQualifiedName(), this.parentWebServiceDecl.getTargetNamespace(), this.parentWebServiceDecl.getJClass().getQualifiedName()));
        }
    }

    protected void visitImpl(WebMethodDecl webMethodDecl) {
        this.validateConversation(webMethodDecl.getJMethod());
        this.validateOperation(webMethodDecl.getJMethod());
    }

    protected void visitImpl(JClass jClass) {
        super.visitImpl(jClass);
        this.addParentSoapDispatchNames();
        this.checkDuplicateOperations(jClass);
    }

    protected void checkParam(WebParamDecl webParamDecl, JMethod jMethod, WebMethodDecl webMethodDecl) {
        super.checkParam(webParamDecl, jMethod, webMethodDecl);
        if (webParamDecl.isHolderType()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "parameter.callback.invalidHolder", webParamDecl.getName(), jMethod.getQualifiedName(), jMethod.getContainingClass().getQualifiedName()));
        }
    }

    private void checkDuplicateOperations(JClass jClass) {
        if (!(this.parentWebServiceDecl instanceof WebServiceSEIDecl)) {
            return;
        }
        WebServiceSEIDecl webServiceSEIDecl = (WebServiceSEIDecl)this.parentWebServiceDecl;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<WebMethodDecl> iterator = webServiceSEIDecl.getWebMethods();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next().getName());
        }
        iterator = ((WebServiceSEIDecl)this.webService).getWebMethods();
        while (iterator.hasNext()) {
            WebMethodDecl webMethodDecl = iterator.next();
            if (hashSet.contains(webMethodDecl.getName())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "method.callback.parentDuplicate", ((WebServiceSEIDecl)this.webService).getSimpleName(), this.parentWebServiceDecl.getSimpleName(), webMethodDecl.getName()));
            }
            hashSet.add(webMethodDecl.getName());
        }
    }

    private void validateOperation(JMethod jMethod) {
        String string;
        String string2;
        JAnnotation jAnnotation = jMethod.getAnnotation(WebMethod.class);
        if (jAnnotation != null && !StringUtil.isEmpty(string2 = JamUtil.getAnnotationStringValue(jAnnotation, "operationName")) && !string2.equals(string = jMethod.getSimpleName())) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "type.callback.operationNameChanged", jMethod.getContainingClass().getQualifiedName(), string, string2));
        }
    }

    private void validateConversation(JMethod jMethod) {
        JAnnotation jAnnotation = jMethod.getAnnotation(Conversation.class);
        if (jAnnotation != null) {
            if (this.parentWebServiceDecl.isConversational() && jMethod.getContainingClass().getParent() != null) {
                String string = JamUtil.getAnnotationStringValue(jAnnotation, "value");
                if (string != null && Conversation.Phase.START.equals((Object)Conversation.Phase.valueOf(string))) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "type.callback.conversationStartNotAllowed", jMethod.getContainingClass().getQualifiedName(), jMethod.getQualifiedName()));
                }
            } else {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "type.callback.annotationNotAllowed.dependent", jAnnotation.getQualifiedName(), jMethod.getQualifiedName(), Conversational.class.getName()));
            }
        }
    }

    private void addParentSoapDispatchNames() {
        if (!(this.parentWebServiceDecl instanceof WebServiceSEIDecl)) {
            return;
        }
        WebServiceSEIDecl webServiceSEIDecl = (WebServiceSEIDecl)this.parentWebServiceDecl;
        Iterator<WebMethodDecl> iterator = webServiceSEIDecl.getWebMethods();
        while (iterator.hasNext()) {
            WebMethodDecl webMethodDecl = iterator.next();
            QName qName = webMethodDecl.getSoapDispatchName();
            if (qName != null) {
                String string = webMethodDecl.getAction();
                HashSet<QName> hashSet = (HashSet<QName>)this.soapDispatchNames.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<QName>();
                    this.soapDispatchNames.put(string, hashSet);
                }
                hashSet.add(qName);
            }
            if (!webMethodDecl.getSoapBinding().isDocumentStyle() || !webMethodDecl.getWebResult().hasReturn()) continue;
            this.resultElementNames.put(webMethodDecl.getResultElementQName(), webMethodDecl.getWebResult().getType());
        }
    }

    String getNoAnnotationKey() {
        return "type.callback.annotationNotAllowed";
    }

    protected NoAnnotationValidator getNoAnnotationValidator(Logger logger) {
        NoAnnotationValidator noAnnotationValidator = new NoAnnotationValidator(logger, "type.callback.annotationNotAllowed");
        noAnnotationValidator.addMatchingRule(new AnnotationMatchingRule(WebService.class));
        noAnnotationValidator.addMatchingRule(new AnnotationMatchingRule(HandlerChain.class));
        noAnnotationValidator.addMatchingRule(new PackageMatchingRule(SOAPBinding.class.getPackage().getName(), new Class[]{SOAPBinding.class}));
        noAnnotationValidator.addMatchingRule(new PackageMatchingRule("weblogic.ejbgen"));
        noAnnotationValidator.addMatchingRule(new PackageMatchingRule(CallbackService.class.getPackage().getName(), new Class[]{CallbackService.class, SoapBinding.class, Conversation.class, Binding.class, UseWLW81BindingTypes.class, MessageBuffer.class, BufferQueue.class}, true));
        return noAnnotationValidator;
    }
}

