/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation.jaxrpc;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JMethod;
import java.util.Iterator;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.MTOM;
import weblogic.jws.Binding;
import weblogic.jws.Types;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicies;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicy;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.TypesUtil;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.SOAPBindingDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.WebTypeDecl;
import weblogic.wsee.tools.jws.validation.BaseEIValidator;
import weblogic.wsee.tools.jws.validation.annotation.AnnotationMatchingRule;
import weblogic.wsee.tools.jws.validation.annotation.NoAnnotationValidator;
import weblogic.wsee.tools.jws.validation.annotation.PackageMatchingRule;
import weblogic.wsee.tools.jws.validation.jaxrpc.TypeValidator;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.PolicyValidateUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.XBeanUtil;

public class EIValidator
extends BaseEIValidator {
    private int noOfNonHeaderParams = 0;

    public EIValidator(JwsBuildContext jwsBuildContext, WebServiceSEIDecl webServiceSEIDecl) {
        super(jwsBuildContext, webServiceSEIDecl);
    }

    protected NoAnnotationValidator getNoAnnotationValidator(Logger logger) {
        NoAnnotationValidator noAnnotationValidator = new NoAnnotationValidator(logger);
        if (this.isSeparateEI()) {
            noAnnotationValidator.addMatchingRule(new PackageMatchingRule("weblogic.jws", new Class[]{Binding.class, Types.class}));
            noAnnotationValidator.addMatchingRule(new PackageMatchingRule("weblogic.ejbgen"));
            noAnnotationValidator.addMatchingRule("annotation.jaxrpc.notAllowed", new AnnotationMatchingRule(new Class[]{SecurityPolicies.class, SecurityPolicy.class, MTOM.class, Addressing.class}));
        }
        return noAnnotationValidator;
    }

    protected void visitImpl(JClass jClass) {
        if (((WebServiceSEIDecl)this.webService).getCowReader() != null && StringUtil.isEmpty(((WebServiceSEIDecl)this.webService).getWsdlLocation())) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.cow.noWsdlLocation", new Object[0]));
        }
        PolicyValidateUtil.checkIllegalPolicyMixUp((WebServiceSEIDecl)this.webService, this.getLogger());
    }

    protected void visitImpl(WebMethodDecl webMethodDecl) {
        this.checkResult(webMethodDecl);
        this.checkTypes(webMethodDecl);
        this.checkTypesAnnotation(webMethodDecl);
        this.noOfNonHeaderParams = 0;
    }

    protected void visitImpl(WebParamDecl webParamDecl) {
        if (webParamDecl.getMode() != WebParam.Mode.IN) {
            this.checkOutParam(webParamDecl);
        }
        this.checkXmlBeans(webParamDecl);
    }

    private void checkOutParam(WebParamDecl webParamDecl) {
        WebMethodDecl webMethodDecl = webParamDecl.getWebMethodDecl();
        if (webMethodDecl.getSoapBinding().isDocumentStyle() && !webParamDecl.isHeader()) {
            ++this.noOfNonHeaderParams;
            if (webMethodDecl.isOneway() || webMethodDecl.getWebResult().hasReturn() || this.noOfNonHeaderParams > 1) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "parameter.binding.invalidModeForDoc", new Object[0]));
            }
        }
    }

    private void checkXmlBeans(WebParamDecl webParamDecl) {
        if (webParamDecl.getTypeFamily() != WebTypeDecl.TypeFamily.POJO) {
            SOAPBindingDecl sOAPBindingDecl = webParamDecl.getWebMethodDecl().getSoapBinding();
            if (!sOAPBindingDecl.isDocumentStyle() && sOAPBindingDecl.isLiteral()) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webParamDecl.getWebMethodDecl().getJMethod(), "method.rpc.xmlBeanNotSupported", new Object[0]));
            } else {
                JAnnotation jAnnotation = webParamDecl.getJParameter().getAnnotation(WebParam.class);
                if (webParamDecl.getTypeFamily() == WebTypeDecl.TypeFamily.XML_BEAN_DOCUMENT && jAnnotation != null) {
                    this.checkXmlBeanDocument((JAnnotatedElement)webParamDecl.getWebMethodDecl().getJMethod(), webParamDecl.getJParameter().getType(), jAnnotation);
                }
            }
        }
    }

    private void checkResult(WebMethodDecl webMethodDecl) {
        JMethod jMethod = webMethodDecl.getJMethod();
        if (webMethodDecl.getWebResult().isHeader()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "result.jaxrpc.headerNotSupported", jMethod.getQualifiedName()));
        }
        if (webMethodDecl.getWebResult().getTypeFamily() != WebTypeDecl.TypeFamily.POJO) {
            if (!webMethodDecl.getSoapBinding().isDocumentStyle() && webMethodDecl.getSoapBinding().isLiteral()) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.rpc.xmlBeanNotSupported", new Object[0]));
            } else {
                JAnnotation jAnnotation = jMethod.getAnnotation(WebResult.class);
                if (webMethodDecl.getWebResult().getTypeFamily() == WebTypeDecl.TypeFamily.XML_BEAN_DOCUMENT && jAnnotation != null) {
                    this.checkXmlBeanDocument((JAnnotatedElement)jMethod, jMethod.getReturnType(), jAnnotation);
                }
            }
        }
    }

    private void checkTypes(WebMethodDecl webMethodDecl) {
        if (((WebServiceSEIDecl)this.webService).getCowReader() != null) {
            return;
        }
        TypeValidator typeValidator = new TypeValidator(this.getLogger(), webMethodDecl);
        if (webMethodDecl.getWebResult().hasReturn()) {
            typeValidator.validate(webMethodDecl.getWebResult());
        }
        int n = 0;
        Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
        while (iterator.hasNext()) {
            if (!iterator.next().getType().equals(SOAPELEMENT_CLASSNAME)) continue;
            ++n;
        }
        if (n > 1) {
            this.getLogger().log(EventLevel.WARNING, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "MultipleSoapElements.InputParam", webMethodDecl.getJMethod().getQualifiedName()));
        }
        iterator = webMethodDecl.getWebParams();
        while (iterator.hasNext()) {
            typeValidator.validate(iterator.next());
        }
    }

    private void checkXmlBeanDocument(JAnnotatedElement jAnnotatedElement, JClass jClass, JAnnotation jAnnotation) {
        QName qName = XBeanUtil.getQNameFromXmlBean(this.getClassLoader(), jClass.getQualifiedName());
        if (qName != null) {
            String string = JamUtil.getAnnotationStringValue(jAnnotation, "name");
            String string2 = JamUtil.getAnnotationStringValue(jAnnotation, "targetNamespace");
            if (!StringUtil.isEmpty(string) && !string.equals(qName.getLocalPart())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "parameter.xmlbean.invalidName", jAnnotation.getQualifiedName(), string, qName.getLocalPart()));
            }
            if (!StringUtil.isEmpty(string2) && !string2.equals(qName.getNamespaceURI())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "parameter.xmlbean.invalidNamespace", jAnnotation.getQualifiedName(), string2, qName.getNamespaceURI()));
            }
        }
    }

    private void checkTypesAnnotation(WebMethodDecl webMethodDecl) {
        JClass jClass = webMethodDecl.getJMethod().getContainingClass();
        TypesUtil.ProcessStrategy processStrategy = new TypesUtil.ProcessStrategy(){

            public void process(JClass jClass, JClass jClass2, int n) {
            }
        };
        TypesUtil.ReportStrategy reportStrategy = new TypesUtil.ReportStrategy(){

            public void report(JwsLogEvent jwsLogEvent) {
                EventLevel eventLevel = null;
                eventLevel = !((WebServiceSEIDecl)EIValidator.this.webService).isWlw81UpgradedService() ? EventLevel.ERROR : EventLevel.WARNING;
                EIValidator.this.getLogger().log(eventLevel, jwsLogEvent);
            }
        };
        try {
            TypesUtil.processParamTypes(jClass, webMethodDecl, 0, processStrategy, reportStrategy);
            TypesUtil.processReturnTypes(jClass, webMethodDecl, 0, processStrategy, reportStrategy);
        }
        catch (WsBuildException wsBuildException) {
            wsBuildException.printStackTrace();
        }
    }
}

