/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation.jaxrpc;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JField;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.internal.elements.UnresolvedClassImpl;
import com.bea.xbean.common.XMLChar;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.MTOM;
import weblogic.ejbgen.RoleMappings;
import weblogic.ejbgen.SecurityRoleRefs;
import weblogic.ejbgen.ServiceEndpointMethod;
import weblogic.ejbgen.Session;
import weblogic.jws.CallbackMethod;
import weblogic.jws.Context;
import weblogic.jws.Conversation;
import weblogic.jws.Conversational;
import weblogic.jws.MessageBuffer;
import weblogic.jws.ServiceClient;
import weblogic.jws.WLHttpTransport;
import weblogic.jws.WLHttpsTransport;
import weblogic.jws.WLJmsTransport;
import weblogic.jws.WLLocalTransport;
import weblogic.jws.security.CallbackRolesAllowed;
import weblogic.jws.security.RolesAllowed;
import weblogic.jws.security.RolesReferenced;
import weblogic.jws.security.RunAs;
import weblogic.jws.security.UserDataConstraint;
import weblogic.wsee.jaxrpc.StubImpl;
import weblogic.wsee.jws.container.Duration;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicies;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicy;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.PolicyDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.validation.BaseSBValidator;
import weblogic.wsee.tools.jws.validation.annotation.AnnotationMatchingRule;
import weblogic.wsee.tools.jws.validation.annotation.NoAnnotationValidator;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.PolicyValidateUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBValidator
extends BaseSBValidator {
    public SBValidator(JwsBuildContext jwsBuildContext, WebServiceSEIDecl webServiceSEIDecl, boolean bl) {
        super(jwsBuildContext, webServiceSEIDecl, bl);
    }

    @Override
    protected void visitImpl(JClass jClass) {
        this.checkEI(jClass);
        this.checkConversational(jClass);
        this.checkTypeSecurity(jClass);
        this.checkPolicies((JAnnotatedElement)jClass, ((WebServiceSEIDecl)this.webService).getPoilices());
        this.checkEJB(jClass);
        this.checkSOAPPortAvailability(jClass);
        PolicyValidateUtil.checkIllegalPolicyMixUp((WebServiceSEIDecl)this.webService, this.getLogger());
    }

    private void checkEI(JClass jClass) {
        if (!StringUtil.isEmpty(((WebServiceSEIDecl)this.webService).getEndPointInterface()) && jClass == ((WebServiceSEIDecl)this.webService).getEIClass()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ei.noEI", ((WebServiceSEIDecl)this.webService).getEndPointInterface()));
        }
    }

    @Override
    protected void visitImpl(JField jField) {
        this.checkServiceClient(jField);
        this.checkCallbackRolesAllowed(jField);
        this.checkConversational(jField);
    }

    @Override
    protected void visitImpl(WebMethodDecl webMethodDecl) {
        JMethod jMethod = webMethodDecl.getJMethod();
        this.checkBuffered(webMethodDecl);
        this.checkPolicies((JAnnotatedElement)jMethod, webMethodDecl.getPoilices());
        this.checkMethodSecurity(jMethod);
        this.checkCallbackRolesAllowed(jMethod);
        this.checkWildcards(webMethodDecl);
        this.checkOperationName(webMethodDecl);
    }

    @Override
    protected NoAnnotationValidator getNoAnnotationValidator(Logger logger) {
        NoAnnotationValidator noAnnotationValidator = super.getNoAnnotationValidator(logger);
        noAnnotationValidator.addMatchingRule("annotation.jaxrpc.notAllowed", new AnnotationMatchingRule(new Class[]{SecurityPolicies.class, SecurityPolicy.class, MTOM.class, Addressing.class}));
        return noAnnotationValidator;
    }

    private void checkWildcards(WebMethodDecl webMethodDecl) {
        if (webMethodDecl.getSoapBinding().isDocLiteralWrapped()) {
            Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
            while (iterator.hasNext()) {
                WebParamDecl webParamDecl = iterator.next();
                if (!webParamDecl.isWildcardType() || !webParamDecl.isArray() || !iterator.hasNext()) continue;
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "parameter.wildcard.unboundedNotLast", webParamDecl.getName(), webMethodDecl.getMethodName(), ((WebServiceSEIDecl)this.webService).getJClass().getQualifiedName()));
            }
        } else if (this.hasInvalidWildcardBinding(webMethodDecl)) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "method.wildcard.anyNotAllowed", webMethodDecl.getMethodName(), ((WebServiceSEIDecl)this.webService).getJClass().getQualifiedName()));
        }
    }

    private boolean hasInvalidWildcardBinding(WebMethodDecl webMethodDecl) {
        if (webMethodDecl.getWebResult().isWildcardType() && !webMethodDecl.getWebResult().isBoundToAnyType()) {
            return true;
        }
        Iterator<WebParamDecl> iterator = webMethodDecl.getWebParams();
        while (iterator.hasNext()) {
            WebParamDecl webParamDecl = iterator.next();
            if (!webParamDecl.isWildcardType() || webParamDecl.isBoundToAnyType()) continue;
            return true;
        }
        return false;
    }

    private void checkCallbackRolesAllowed(JMethod jMethod) {
        if (jMethod.getAnnotation(CallbackRolesAllowed.class) != null && jMethod.getAnnotation(CallbackMethod.class) == null) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "type.sb.noCallbackMethod", jMethod.getQualifiedName()));
        }
    }

    private void checkEJB(JClass jClass) {
        if (((WebServiceSEIDecl)this.webService).isEjb() && ((WebServiceSEIDecl)this.webService).isComplex()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ejb.notAllowed", jClass.getQualifiedName(), SBValidator.getComplexAnnotations()));
        }
    }

    private static String getComplexAnnotations() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : WebServiceSEIDecl.getComplexAnnotations()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void checkTypeSecurity(JClass jClass) {
        JAnnotation jAnnotation = jClass.getAnnotation(RunAs.class);
        if (jAnnotation != null && jAnnotation.getValue("mapToPrincipal") == null) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "security.mapToPrincipalsMissing", "@RunAs"));
        }
        if (((WebServiceSEIDecl)this.webService).isEjb()) {
            JAnnotationValue jAnnotationValue;
            JAnnotation jAnnotation2;
            JAnnotation jAnnotation3 = jClass.getAnnotation(RunAs.class);
            if (jAnnotation3 != null && (jAnnotation2 = jClass.getAnnotation(Session.class)) != null && !(jAnnotationValue = jAnnotation2.getValue("runAs")).asString().equals("UNSPECIFIED")) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "security.noSessionRunAs", new Object[0]));
            }
            if (jClass.getAnnotation(RolesReferenced.class) != null && jClass.getAnnotation(SecurityRoleRefs.class) != null) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "security.noSecurityRoleRefsRolesRefereneced", new Object[0]));
            }
            if (jClass.getAnnotation(RolesAllowed.class) != null && jClass.getAnnotation(RoleMappings.class) != null) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "security.noRolesAllowedRoleMappings", new Object[0]));
            }
        }
    }

    private void checkMethodSecurity(JMethod jMethod) {
        JAnnotation jAnnotation;
        JAnnotation jAnnotation2;
        String string = "";
        if (jMethod.getAnnotation(RunAs.class) != null) {
            string = "@RunAs";
        } else if (jMethod.getAnnotation(RolesReferenced.class) != null) {
            string = "@RolesReferenced";
        } else if (jMethod.getAnnotation(UserDataConstraint.class) != null) {
            string = "@UserDataConstraint";
        }
        if (((WebServiceSEIDecl)this.webService).isEjb() && (jAnnotation2 = jMethod.getAnnotation(RolesAllowed.class)) != null && (jAnnotation = jMethod.getAnnotation(ServiceEndpointMethod.class)) != null && jAnnotation.getValue("roles").asString().equals("UNSPECIFIED")) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod.getContainingClass(), "security.noRolesAllowedServiceEndpointMethod", new Object[0]));
        }
        if (string.length() > 0) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "security.noAnntMethod", string, jMethod.getQualifiedName()));
        }
    }

    private void checkPolicies(JAnnotatedElement jAnnotatedElement, Iterator<PolicyDecl> iterator) {
        JAnnotation jAnnotation = jAnnotatedElement.getAnnotation("weblogic.jws.Policy");
        JAnnotation jAnnotation2 = jAnnotatedElement.getAnnotation("weblogic.jws.Policies");
        if (jAnnotation != null && jAnnotation2 != null) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.bothAnnotations", new Object[0]));
        }
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            UserDataConstraint.Transport transport;
            JAnnotation jAnnotation3;
            PolicyDecl policyDecl = iterator.next();
            if (hashSet.contains(policyDecl.getUri())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.duplicateUri", policyDecl.getUri()));
            } else {
                hashSet.add(policyDecl.getUri());
            }
            if (!StringUtil.isEmpty(policyDecl.getUriError())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.uriInError", policyDecl.getUri(), policyDecl.getUriError()));
            } else if (!policyDecl.isBuiltInPolicy()) {
                this.checkConnection(policyDecl, jAnnotatedElement);
            }
            if ((jAnnotation3 = jAnnotatedElement.getAnnotation(UserDataConstraint.class)) == null || (transport = JamUtil.getAnnotationEnumValue(jAnnotation3, "transport", UserDataConstraint.Transport.class, UserDataConstraint.Transport.NONE)) != UserDataConstraint.Transport.NONE) continue;
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.withUserDataConstraint", policyDecl.getUri()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection(PolicyDecl policyDecl, JAnnotatedElement jAnnotatedElement) {
        InputStream inputStream = null;
        try {
            inputStream = policyDecl.getPolicyURI().toURL().openStream();
            if (inputStream == null) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.notFound", policyDecl.getPolicyURI().toString()));
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.uriInError", policyDecl.getUri(), malformedURLException.getMessage()));
        }
        catch (IOException iOException) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.notFound", policyDecl.getPolicyURI().toString(), iOException.getMessage()));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void checkCallbackRolesAllowed(JField jField) {
        if (jField.getAnnotation(CallbackRolesAllowed.class) != null && jField.getAnnotation(ServiceClient.class) == null) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jField, "type.field.noServiceClient", jField.getSimpleName()));
        }
    }

    private void checkServiceClient(JField jField) {
        JClass jClass = jField.getContainingClass().getClassLoader().loadClass(StubImpl.class.getName());
        if (jField.getAnnotation(ServiceClient.class) != null) {
            JClass jClass2 = jField.getType();
            if (jField.getType().isInterface()) {
                String string = jClass2.getQualifiedName() + "_Stub";
                JClass jClass3 = jField.getContainingClass().getClassLoader().loadClass(string);
                if (!(jClass3 instanceof UnresolvedClassImpl)) {
                    jClass2 = jClass3;
                }
            }
            if (!jClass.isAssignableFrom(jClass2)) {
                this.getLogger().log(EventLevel.WARNING, new JwsLogEvent((JElement)jField, "type.field.notStub", jField.getSimpleName()));
            }
        }
    }

    private void checkConversational(JField jField) {
    }

    private boolean isContextField(JField jField) {
        return jField.getAnnotation(Context.class) != null || jField.getAnnotation("weblogic.controls.jws.Common.Context") != null;
    }

    private boolean isControlField(JField jField) {
        return jField.getAnnotation("org.apache.beehive.controls.api.bean.Control") != null;
    }

    private void checkConversational(JClass jClass) {
        if (((WebServiceSEIDecl)this.webService).isConversational()) {
            this.checkPhases(jClass);
            this.checkSerializable(jClass);
            this.checkConversationalAnn(jClass);
        }
    }

    private void checkPhases(JClass jClass) {
        int n = 0;
        Iterator<WebMethodDecl> iterator = ((WebServiceSEIDecl)this.webService).getWebMethods();
        while (iterator.hasNext()) {
            WebMethodDecl webMethodDecl = iterator.next();
            if (webMethodDecl.getConverationPhase() != Conversation.Phase.START) continue;
            ++n;
        }
        if (n < 1) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "method.conversation.wrongNumOfPhases", new Object[]{Conversation.Phase.START}));
        }
    }

    private void checkSerializable(JClass jClass) {
        JClass jClass2 = jClass.getClassLoader().loadClass(Serializable.class.getName());
        if (!jClass2.isAssignableFrom(jClass)) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.conversation.notSerializable", new Object[0]));
        }
    }

    private void checkConversationalAnn(JClass jClass) {
        JAnnotation jAnnotation = jClass.getAnnotation(Conversational.class);
        if (jAnnotation != null) {
            try {
                new Duration(JamUtil.getAnnotationStringValue(jAnnotation, "maxAge"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.conversational.invalidMaxAge", illegalArgumentException.getMessage()));
            }
            try {
                new Duration(JamUtil.getAnnotationStringValue(jAnnotation, "maxIdleTime"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.conversational.invalidMaxIdleTime", illegalArgumentException.getMessage()));
            }
        }
    }

    private void checkBuffered(WebMethodDecl webMethodDecl) {
        JAnnotation jAnnotation = webMethodDecl.getJMethod().getAnnotation(MessageBuffer.class);
        if (jAnnotation != null) {
            if (webMethodDecl.getWebResult().getType() != null) {
                this.getLogger().log(EventLevel.WARNING, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "method.buffered.void", new Object[0]));
            }
            try {
                new Duration(JamUtil.getAnnotationStringValue(jAnnotation, "retryDelay"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "method.buffered.invalidRetryDelay", illegalArgumentException.getMessage()));
            }
        }
    }

    private void checkSOAPPortAvailability(JClass jClass) {
        if (((WebServiceSEIDecl)this.webService).getCowReader() != null && !StringUtil.isEmpty(((WebServiceSEIDecl)this.webService).getWsdlLocation())) {
            WsdlDefinitions wsdlDefinitions = null;
            try {
                wsdlDefinitions = ((WebServiceSEIDecl)this.webService).getCowReader().getWsdl(((WebServiceSEIDecl)this.webService).getWsdlLocation());
            }
            catch (WsdlException wsdlException) {
                // empty catch block
            }
            if (wsdlDefinitions != null) {
                String string;
                String string2 = ((WebServiceSEIDecl)this.webService).getTargetNamespace();
                JAnnotation jAnnotation = jClass.getAnnotation(WLJmsTransport.class);
                String string3 = string = jAnnotation == null ? null : jAnnotation.getValue("portName").asString();
                if (!StringUtil.isEmpty(string) && wsdlDefinitions.getPorts().get(new QName(string2, string)) == null) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "port.name.not.found", string, jAnnotation.toString()));
                }
                String string4 = string = (jAnnotation = jClass.getAnnotation(WLHttpsTransport.class)) == null ? null : jAnnotation.getValue("portName").asString();
                if (!StringUtil.isEmpty(string) && wsdlDefinitions.getPorts().get(new QName(string2, string)) == null) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "port.name.not.found", string, jAnnotation.toString()));
                }
                String string5 = string = (jAnnotation = jClass.getAnnotation(WLLocalTransport.class)) == null ? null : jAnnotation.getValue("portName").asString();
                if (!StringUtil.isEmpty(string) && wsdlDefinitions.getPorts().get(new QName(string2, string)) == null) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "port.name.not.found", string, jAnnotation.toString()));
                }
                String string6 = string = (jAnnotation = jClass.getAnnotation(WLHttpTransport.class)) == null ? null : jAnnotation.getValue("portName").asString();
                if (!StringUtil.isEmpty(string) && wsdlDefinitions.getPorts().get(new QName(string2, string)) == null) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "port.name.not.found", string, jAnnotation.toString()));
                }
            }
        }
    }

    private void checkOperationName(WebMethodDecl webMethodDecl) {
        if (!XMLChar.isValidNCName((String)webMethodDecl.getName())) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "operation.name.invalid", webMethodDecl.getName()));
        }
    }
}

