/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation.jaxrpc;

import com.bea.staxb.buildtime.internal.bts.BindingLoader;
import com.bea.staxb.buildtime.internal.bts.BuiltinBindingLoader;
import com.bea.staxb.buildtime.internal.bts.JavaTypeName;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JConstructor;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JProperty;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.holders.Holder;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebResultDecl;
import weblogic.wsee.tools.jws.decl.WebTypeDecl;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.util.XBeanUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeValidator {
    private BindingLoader bindingLoader = BuiltinBindingLoader.getBuiltinBindingLoader((boolean)true);
    private final Logger logger;
    private final WebMethodDecl method;

    TypeValidator(Logger logger, WebMethodDecl webMethodDecl) {
        this.logger = logger;
        this.method = webMethodDecl;
    }

    void validate(WebTypeDecl webTypeDecl) {
        this.validate(webTypeDecl, null, webTypeDecl.getJClass(), new HashSet<JClass>());
    }

    private void validate(WebTypeDecl webTypeDecl, JClass jClass, JClass jClass2, Set<JClass> set) {
        JClass jClass3 = TypeValidator.getRealType(jClass2);
        if (set.contains(jClass3)) {
            return;
        }
        set.add(jClass3);
        if (this.isBuiltinType(jClass3)) {
            return;
        }
        this.checkUnsupportedTypes(jClass3, webTypeDecl);
        if (this.checkXmlBean(jClass3, jClass)) {
            this.checkJavaBean(jClass3, webTypeDecl);
            this.checkChildren(jClass3, webTypeDecl, set);
        }
    }

    private void checkChildren(JClass jClass, WebTypeDecl webTypeDecl, Set<JClass> set) {
        for (JProperty jProperty : jClass.getProperties()) {
            if (jProperty.getSetter() == null || jProperty.getGetter() == null) continue;
            this.validate(webTypeDecl, jClass, jProperty.getType(), set);
        }
        for (JProperty jProperty : jClass.getFields()) {
            if (!jProperty.isPublic() || jProperty.isStatic() || jProperty.isFinal()) continue;
            this.validate(webTypeDecl, jClass, jProperty.getType(), set);
        }
    }

    private boolean checkXmlBean(JClass jClass, JClass jClass2) {
        if (XBeanUtil.isXmlBean(jClass)) {
            if (jClass2 == null) {
                return false;
            }
            if (XBeanUtil.isXmlBean(jClass2)) {
                return false;
            }
            JClass jClass3 = jClass2.getClassLoader().loadClass(Holder.class.getName());
            if (jClass3.isAssignableFrom(jClass2)) {
                return false;
            }
            this.logError("binding.javaBeanWithXmlBeanPropertyOrField", jClass2.getQualifiedName(), jClass.getQualifiedName());
        }
        return true;
    }

    private void checkJavaBean(JClass jClass, WebTypeDecl webTypeDecl) {
        if (!jClass.isInterface() && !TypeValidator.hasDefaultConstructor(jClass)) {
            if (webTypeDecl instanceof WebResultDecl) {
                this.logWarning("parameter.binding.invalidReturn", jClass.getQualifiedName(), this.method.getJMethod().getSimpleName());
            } else {
                this.logWarning("parameter.binding.invalidParameter", jClass.getQualifiedName(), webTypeDecl.getName(), this.method.getJMethod().getSimpleName());
            }
        }
    }

    private void checkUnsupportedTypes(JClass jClass, WebTypeDecl webTypeDecl) {
        JClass jClass2 = jClass.getClassLoader().loadClass(Map.class.getName());
        if (jClass.isAssignableFrom(jClass2)) {
            this.logError("binding.invalidType", jClass.getQualifiedName());
        }
        if (jClass.isEnumType()) {
            this.logError("unsupported.enumTypes", jClass.getQualifiedName());
        }
    }

    private static JClass getRealType(JClass jClass) {
        JClass jClass2 = jClass;
        if (jClass.isArrayType()) {
            jClass2 = jClass.getArrayComponentType();
        }
        return jClass2;
    }

    private boolean isBuiltinType(JClass jClass) {
        return this.bindingLoader.lookupTypeFor(JavaTypeName.forJClass((JClass)jClass)) != null;
    }

    private static boolean hasDefaultConstructor(JClass jClass) {
        for (JConstructor jConstructor : jClass.getConstructors()) {
            if (!jConstructor.isPublic() || jConstructor.getParameters().length != 0) continue;
            return true;
        }
        return false;
    }

    private void logError(String string, Object ... objectArray) {
        this.logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)this.method.getJMethod(), string, objectArray));
    }

    private void logWarning(String string, Object ... objectArray) {
        this.logger.log(EventLevel.WARNING, new JwsLogEvent((JElement)this.method.getJMethod(), string, objectArray));
    }
}

