/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation.jaxws;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicies;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicy;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.SOAPBindingDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.WebTypeDecl;
import weblogic.wsee.tools.jws.validation.BaseEIValidator;
import weblogic.wsee.tools.jws.validation.annotation.NoAnnotationValidator;
import weblogic.wsee.tools.jws.validation.annotation.PackageMatchingRule;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.util.PolicyValidateUtil;

public class EIValidator
extends BaseEIValidator {
    public EIValidator(JwsBuildContext jwsBuildContext, WebServiceSEIDecl webServiceSEIDecl) {
        super(jwsBuildContext, webServiceSEIDecl);
    }

    protected NoAnnotationValidator getNoAnnotationValidator(Logger logger) {
        NoAnnotationValidator noAnnotationValidator = new NoAnnotationValidator(logger);
        if (this.isSeparateEI()) {
            noAnnotationValidator.addMatchingRule("annotation.jaxws.ei.notAllowed", new PackageMatchingRule("weblogic", new Class[]{SecurityPolicy.class, SecurityPolicies.class}, true));
        }
        return noAnnotationValidator;
    }

    protected void visitImpl(JClass jClass) {
        this.checkSoapBinding(((WebServiceSEIDecl)this.webService).getSoapBinding(), (JAnnotatedElement)jClass);
        PolicyValidateUtil.checkClassScopedOWSMPolicy(jClass, this.getLogger());
        PolicyValidateUtil.checkClassScopedWebLogicProprietaryPolicy((WebServiceSEIDecl)this.webService, this.getLogger());
    }

    protected void visitImpl(WebMethodDecl webMethodDecl) {
        this.checkSoapBinding(webMethodDecl.getSoapBinding(), (JAnnotatedElement)webMethodDecl.getJMethod());
        this.checkResult(webMethodDecl);
        PolicyValidateUtil.checkMethodScopedWebLogicProprietaryPolicy(webMethodDecl, this.getLogger());
    }

    protected void visitImpl(WebParamDecl webParamDecl) {
        if (webParamDecl.getTypeFamily() != WebTypeDecl.TypeFamily.POJO) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webParamDecl.getWebMethodDecl().getJMethod(), "method.jaxws.xmlBeanNotSupported", new Object[0]));
        }
    }

    private void checkSoapBinding(SOAPBindingDecl sOAPBindingDecl, JAnnotatedElement jAnnotatedElement) {
        if (!sOAPBindingDecl.isDocumentStyle() && !sOAPBindingDecl.isLiteral() && ((WebServiceSEIDecl)this.webService).getType() == WebServiceType.JAXWS) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "type.ei.jaxws.rpcEncodedNotSupported", new Object[0]));
        }
    }

    private void checkResult(WebMethodDecl webMethodDecl) {
        if (webMethodDecl.getWebResult().getTypeFamily() != WebTypeDecl.TypeFamily.POJO) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)webMethodDecl.getJMethod(), "method.jaxws.xmlBeanNotSupported", new Object[0]));
        }
    }
}

