/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation.jaxws;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JField;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import weblogic.jws.Policies;
import weblogic.jws.Policy;
import weblogic.jws.security.WssConfiguration;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicies;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicy;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.PolicyDecl;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.jws.validation.BaseSBValidator;
import weblogic.wsee.tools.jws.validation.annotation.NoAnnotationValidator;
import weblogic.wsee.tools.jws.validation.annotation.PackageMatchingRule;
import weblogic.wsee.tools.jws.validation.jaxws.WSATValidator;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.util.PolicyValidateUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wstx.wsat.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBValidator
extends BaseSBValidator {
    WSATValidator wsatValidator = new WSATValidator();

    public SBValidator(JwsBuildContext jwsBuildContext, WebServiceSEIDecl webServiceSEIDecl, boolean bl) {
        super(jwsBuildContext, webServiceSEIDecl, bl);
    }

    @Override
    protected void visitImpl(JClass jClass) {
        int n = 0;
        Iterator<PortDecl> iterator = ((WebServiceSEIDecl)this.webService).getPorts();
        while (iterator.hasNext()) {
            PortDecl portDecl = iterator.next();
            if (!"http".equals(portDecl.getProtocol())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ports.jaxws.notHttp", jClass.getQualifiedName()));
            }
            ++n;
        }
        if (n > 1) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.ports.jaxws.moreThanOne", jClass.getQualifiedName()));
        }
        PolicyValidateUtil.checkClassScopedOWSMPolicy(jClass, this.getLogger());
        PolicyValidateUtil.checkClassScopedWebLogicProprietaryPolicy((WebServiceSEIDecl)this.webService, this.getLogger());
        this.checkPolicies((JAnnotatedElement)jClass, ((WebServiceSEIDecl)this.webService).getPoilices());
        this.wsatValidator.visitImpl(jClass, this.getLogger());
    }

    @Override
    protected NoAnnotationValidator getNoAnnotationValidator(Logger logger) {
        NoAnnotationValidator noAnnotationValidator = super.getNoAnnotationValidator(logger);
        noAnnotationValidator.addMatchingRule("annotation.jaxws.notAllowed", new PackageMatchingRule("weblogic", new Class[]{Policy.class, Policies.class, WssConfiguration.class, SecurityPolicy.class, SecurityPolicies.class, Transactional.class}, true));
        return noAnnotationValidator;
    }

    @Override
    protected void visitImpl(JField jField) {
    }

    @Override
    protected void visitImpl(WebMethodDecl webMethodDecl) {
        PolicyValidateUtil.checkMethodScopedWebLogicProprietaryPolicy(webMethodDecl, this.getLogger());
        this.checkPolicies((JAnnotatedElement)webMethodDecl.getJMethod(), webMethodDecl.getPoilices());
        this.wsatValidator.visitImpl(webMethodDecl, this.getLogger());
    }

    private void checkPolicies(JAnnotatedElement jAnnotatedElement, Iterator<PolicyDecl> iterator) {
        PolicyDecl policyDecl;
        JAnnotation jAnnotation = jAnnotatedElement.getAnnotation("weblogic.jws.Policy");
        JAnnotation jAnnotation2 = jAnnotatedElement.getAnnotation("weblogic.jws.Policies");
        if (jAnnotation != null && jAnnotation2 != null) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.bothAnnotations", new Object[0]));
        }
        JAnnotation jAnnotation3 = jAnnotatedElement.getAnnotation(SecurityPolicy.class.getName());
        JAnnotation jAnnotation4 = jAnnotatedElement.getAnnotation(SecurityPolicies.class.getName());
        if (jAnnotation3 != null && jAnnotation4 != null) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.bothSecurityAnnotations", new Object[0]));
        }
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            policyDecl = iterator.next();
            if (hashSet.contains(policyDecl.getUri())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.duplicateUri", policyDecl.getUri()));
            } else {
                hashSet.add(policyDecl.getUri());
            }
            if (!StringUtil.isEmpty(policyDecl.getUriError())) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.uriInError", policyDecl.getUri(), policyDecl.getUriError()));
                continue;
            }
            if (policyDecl.isBuiltInPolicy()) continue;
            this.checkConnection(policyDecl, jAnnotatedElement);
        }
        hashSet.clear();
        if (jAnnotation4 != null) {
            policyDecl = jAnnotation4.getValue("value");
            for (JAnnotation jAnnotation5 : policyDecl.asAnnotationArray()) {
                String string = jAnnotation5.getValue("uri").asString();
                if (hashSet.contains(string)) {
                    this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.duplicateUri", string));
                    continue;
                }
                hashSet.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection(PolicyDecl policyDecl, JAnnotatedElement jAnnotatedElement) {
        InputStream inputStream = null;
        try {
            inputStream = policyDecl.getPolicyURI().toURL().openStream();
            if (inputStream == null) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.notFound", policyDecl.getPolicyURI().toString()));
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.uriInError", policyDecl.getUri(), malformedURLException.getMessage()));
        }
        catch (IOException iOException) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "policy.notFound", policyDecl.getPolicyURI().toString(), iOException.getMessage()));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

