/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation.jaxws;

import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import com.bea.util.jam.JMethod;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.validation.TXAttributesValidator;

public class WSATValidator {
    JAnnotation firstWsatAnno;
    JAnnotation classLevelEJBTxAnno;
    JAnnotation classLevelWsatAnno;
    JAnnotatedElement firstTransactionalEle;
    boolean isStatelessEJB;

    public void visitImpl(JClass jClass, Logger logger) {
        this.isStatelessEJB = jClass.getAnnotation(Stateless.class) != null;
        this.classLevelEJBTxAnno = jClass.getAnnotation(TransactionAttribute.class);
        this.firstWsatAnno = this.classLevelWsatAnno = jClass.getAnnotation(Transactional.class);
        this.firstTransactionalEle = jClass;
    }

    public void visitProvider(JClass jClass, Logger logger) {
        JMethod[] jMethodArray;
        this.isStatelessEJB = jClass.getAnnotation(Stateless.class) != null;
        this.classLevelEJBTxAnno = jClass.getAnnotation(TransactionAttribute.class);
        this.firstWsatAnno = this.classLevelWsatAnno = jClass.getAnnotation(Transactional.class);
        this.firstTransactionalEle = jClass;
        for (JMethod jMethod : jMethodArray = jClass.getMethods()) {
            String string = jMethod.getQualifiedName();
            if (!"public javax.xml.transform.Source invoke(javax.xml.transform.Source)".equals(string) && !"public javax.xml.soap.SOAPMessage invoke(javax.xml.soap.SOAPMessage)".equals(string)) continue;
            this.checkEJBTransactionaAttributes((JAnnotatedElement)jMethod, logger);
        }
    }

    public void visitImpl(WebMethodDecl webMethodDecl, Logger logger) {
        this.checkEJBTransactionaAttributes((JAnnotatedElement)webMethodDecl.getJMethod(), logger);
        this.checkWSATAnnotations(webMethodDecl, logger);
    }

    private static TransactionAttributeType getEjbTransactionaAttributeValue(JAnnotation jAnnotation) {
        if (jAnnotation == null) {
            return TransactionAttributeType.REQUIRED;
        }
        return TransactionAttributeType.valueOf((String)jAnnotation.getValue("value").asString());
    }

    private static Transactional.TransactionFlowType getWSATValue(JAnnotation jAnnotation) {
        if (jAnnotation == null || !jAnnotation.getValue("enabled").asBoolean()) {
            return Transactional.TransactionFlowType.NEVER;
        }
        return Transactional.TransactionFlowType.valueOf((String)jAnnotation.getValue("value").asString());
    }

    private void checkEJBTransactionaAttributes(JAnnotatedElement jAnnotatedElement, Logger logger) {
        Transactional.TransactionFlowType transactionFlowType;
        TransactionAttributeType transactionAttributeType;
        if (!this.isStatelessEJB) {
            return;
        }
        JAnnotation jAnnotation = jAnnotatedElement.getAnnotation(Transactional.class);
        JAnnotation jAnnotation2 = jAnnotatedElement.getAnnotation(TransactionAttribute.class);
        if (jAnnotation2 == null) {
            jAnnotation2 = this.classLevelEJBTxAnno;
        }
        if (jAnnotation == null) {
            jAnnotation = this.classLevelWsatAnno;
        }
        if (!TXAttributesValidator.isValid(transactionAttributeType = WSATValidator.getEjbTransactionaAttributeValue(jAnnotation2), transactionFlowType = WSATValidator.getWSATValue(jAnnotation))) {
            logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)jAnnotatedElement, "method.wsat.ejbtransaction.invalidCombination", transactionFlowType, transactionAttributeType, jAnnotatedElement));
        }
    }

    private void checkWSATAnnotations(WebMethodDecl webMethodDecl, Logger logger) {
        boolean bl;
        JMethod jMethod = webMethodDecl.getJMethod();
        JAnnotation jAnnotation = jMethod.getAnnotation(Transactional.class);
        Transactional.TransactionFlowType transactionFlowType = WSATValidator.getWSATValue(jAnnotation);
        boolean bl2 = bl = Transactional.TransactionFlowType.NEVER != transactionFlowType;
        if (!bl) {
            return;
        }
        if (webMethodDecl.isOneway()) {
            logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.oneway.wsatnotAllowed", webMethodDecl.getName()));
            return;
        }
        String string = jAnnotation.getValue("version").asString();
        if (this.classLevelWsatAnno != null) {
            if (!this.classLevelWsatAnno.getValue("version").asString().equals(string) && !"DEFAULT".equals(string)) {
                logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.wsat.differentVersion", webMethodDecl.getName(), this.firstTransactionalEle));
            }
        } else if (this.firstWsatAnno == null) {
            this.firstWsatAnno = jAnnotation;
            this.firstTransactionalEle = jMethod;
        } else if (!this.firstWsatAnno.getValue("version").asString().equals(string)) {
            logger.log(EventLevel.ERROR, new JwsLogEvent((JElement)jMethod, "method.wsat.differentVersion", webMethodDecl.getName(), this.firstTransactionalEle));
        }
    }
}

