/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.validation.jaxws;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import weblogic.jws.Policies;
import weblogic.jws.Policy;
import weblogic.jws.security.WssConfiguration;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicies;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicy;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.WebServiceProviderDecl;
import weblogic.wsee.tools.jws.validation.BaseValidator;
import weblogic.wsee.tools.jws.validation.annotation.NoAnnotationValidator;
import weblogic.wsee.tools.jws.validation.annotation.PackageMatchingRule;
import weblogic.wsee.tools.jws.validation.jaxws.WSATValidator;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.PolicyValidateUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wstx.wsat.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceProviderValidator
extends BaseValidator<WebServiceProviderDecl> {
    WSATValidator wsatValidator = new WSATValidator();

    public WebServiceProviderValidator(JwsBuildContext jwsBuildContext, WebServiceProviderDecl webServiceProviderDecl) {
        super(jwsBuildContext, webServiceProviderDecl);
    }

    @Override
    protected NoAnnotationValidator getNoAnnotationValidator(Logger logger) {
        NoAnnotationValidator noAnnotationValidator = new NoAnnotationValidator(logger);
        noAnnotationValidator.addMatchingRule("annotation.jaxws.notAllowed", new PackageMatchingRule("weblogic", new Class[]{Policy.class, Policies.class, WssConfiguration.class, SecurityPolicy.class, SecurityPolicies.class, Transactional.class}, true));
        return noAnnotationValidator;
    }

    public void visit(JClass jClass) {
        if (jClass == null || jClass.isUnresolvedType()) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.class.unknown", jClass.getQualifiedName()));
        } else {
            JAnnotation jAnnotation;
            if (((WebServiceProviderDecl)this.webService).getType() != WebServiceType.JAXWS) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.provider.notJAXWS", jClass.getQualifiedName()));
            }
            if ((jAnnotation = jClass.getAnnotation(WebServiceProvider.class)) == null) {
                this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.provider.noWebServiceProvider", jClass.getQualifiedName()));
            } else {
                this.checkWsdlLocation(jAnnotation, jClass);
                this.wsatValidator.visitProvider(jClass, this.getLogger());
                this.checkImplementsProvider(jClass);
                this.checkHandlerChain(jClass);
                PolicyValidateUtil.checkClassScopedOWSMPolicy(jClass, this.getLogger());
            }
        }
    }

    private void checkImplementsProvider(JClass jClass) {
        for (JClass jClass2 : jClass.getInterfaces()) {
            if (!Provider.class.getName().equals(jClass2.getQualifiedName())) continue;
            return;
        }
        this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.provider.ProviderNotImplemented", jClass.getQualifiedName(), Provider.class.getName()));
    }

    private void checkWsdlLocation(JAnnotation jAnnotation, JClass jClass) {
        JAnnotation jAnnotation2;
        String string = JamUtil.getAnnotationStringValue(jAnnotation, "wsdlLocation");
        if (StringUtil.isEmpty(string) && ((jAnnotation2 = jClass.getAnnotation(BindingType.class)) == null || !"http://www.w3.org/2004/08/wsdl/http".equals(JamUtil.getAnnotationStringValue(jAnnotation2, "value")))) {
            this.getLogger().log(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.provider.noWsdlLocation", jClass.getQualifiedName()));
        }
    }

    @Override
    protected JClass getVisitee() {
        return ((WebServiceProviderDecl)this.webService).getJClass();
    }
}

