/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.war;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.AuthConstraintBean;
import weblogic.j2ee.descriptor.LoginConfigBean;
import weblogic.j2ee.descriptor.RunAsBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.SecurityRoleRefBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.ServletMappingBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.jws.security.UserDataConstraint;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.JWSProcessor;
import weblogic.wsee.tools.jws.ModuleInfo;
import weblogic.wsee.tools.jws.WebServiceInfo;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSecurityDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppProcessor
implements JWSProcessor {
    private ModuleInfo moduleInfo = null;

    @Override
    public void init(ModuleInfo moduleInfo) throws WsBuildException {
        this.moduleInfo = moduleInfo;
    }

    @Override
    public void finish() throws WsBuildException {
    }

    @Override
    public void process(WebServiceInfo webServiceInfo) throws WsBuildException {
        Object object;
        Object object2;
        String[] stringArray;
        if (this.moduleInfo.isWsdlOnly()) {
            return;
        }
        if (((WebServiceDecl)webServiceInfo.getWebService()).isEjb()) {
            return;
        }
        WebAppBean webAppBean = this.getWebAppBean(this.moduleInfo);
        Object t = webServiceInfo.getWebService();
        String[] stringArray2 = webAppBean.getDisplayNames();
        if (stringArray2 == null || stringArray2.length == 0) {
            stringArray = new String[]{((WebServiceDecl)t).getArtifactName() + "WebApp"};
            webAppBean.setDisplayNames(stringArray);
        }
        stringArray = new ArrayList();
        Iterator<PortDecl> iterator = ((WebServiceDecl)t).getDDPorts();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = WebAppProcessor.createServlet(webAppBean, t, (PortDecl)object2);
            WebAppProcessor.createServletMappings(webAppBean, (PortDecl)object2, object.getServletName());
            stringArray.add(object);
        }
        if (t instanceof WebServiceSEIDecl) {
            object2 = (WebServiceSEIDecl)t;
            object = ((WebServiceDecl)object2).getWebServiceSecurityDecl();
            if (((WebServiceSecurityDecl)object).isSecurityRolesDefined()) {
                WebAppProcessor.createBasicAuth(webAppBean);
                WebAppProcessor.createSecurityConstraints(webAppBean, (WebServiceSEIDecl)object2, (WebServiceSecurityDecl)object);
                WebAppProcessor.createSecurityRoles(webAppBean, (WebServiceSecurityDecl)object);
                WebAppProcessor.createSecurityRoleRefs((WebServiceSecurityDecl)object, (List<ServletBean>)stringArray);
            } else if (((WebServiceSecurityDecl)object).isUserDataConstraintDefined()) {
                WebAppProcessor.createSecurityConstraints(webAppBean, (WebServiceSEIDecl)object2, (WebServiceSecurityDecl)object);
            }
            WebAppProcessor.createRunAs(webAppBean, (List<ServletBean>)stringArray, (WebServiceSecurityDecl)object);
        }
    }

    private WebAppBean getWebAppBean(ModuleInfo moduleInfo) {
        WebAppBean webAppBean = moduleInfo.getWebAppBean();
        if (webAppBean == null) {
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            webAppBean = (WebAppBean)editableDescriptorManager.createDescriptorRoot(WebAppBean.class).getRootBean();
            webAppBean.setVersion("2.5");
            moduleInfo.setWebAppBean(webAppBean);
        }
        return webAppBean;
    }

    private static ServletBean createServlet(WebAppBean webAppBean, WebServiceDecl webServiceDecl, PortDecl portDecl) {
        ServletBean servletBean = webAppBean.createServlet();
        servletBean.setServletName(webServiceDecl.getDeployedName() + portDecl.getProtocol());
        servletBean.setServletClass(webServiceDecl.getJClass().getQualifiedName());
        servletBean.setLoadOnStartup("0");
        return servletBean;
    }

    private static ServletMappingBean createServletMappings(WebAppBean webAppBean, PortDecl portDecl, String string) {
        ServletMappingBean servletMappingBean = webAppBean.createServletMapping();
        servletMappingBean.setServletName(string);
        servletMappingBean.setUrlPatterns(new String[]{portDecl.getServiceUri()});
        return servletMappingBean;
    }

    private static void createBasicAuth(WebAppBean webAppBean) {
        LoginConfigBean[] loginConfigBeanArray = webAppBean.getLoginConfigs();
        if (loginConfigBeanArray != null && loginConfigBeanArray.length > 0) {
            return;
        }
        LoginConfigBean loginConfigBean = webAppBean.createLoginConfig();
        loginConfigBean.setAuthMethod("BASIC");
        loginConfigBean.setRealmName("default");
    }

    private static void createSecurityRoles(WebAppBean webAppBean, WebServiceSecurityDecl webServiceSecurityDecl) {
        for (String string : webServiceSecurityDecl.getSecurityRoles()) {
            if (WebAppProcessor.hasRoleDefined(webAppBean, string)) continue;
            webAppBean.createSecurityRole().setRoleName(string);
        }
    }

    private static boolean hasRoleDefined(WebAppBean webAppBean, String string) {
        for (SecurityRoleBean securityRoleBean : webAppBean.getSecurityRoles()) {
            if (!string.equals(securityRoleBean.getRoleName())) continue;
            return true;
        }
        return false;
    }

    private static void createSecurityRoleRefs(WebServiceSecurityDecl webServiceSecurityDecl, List<ServletBean> list) {
        for (ServletBean servletBean : list) {
            if (!webServiceSecurityDecl.hasSecurityRoleRefs()) continue;
            HashMap<String, String> hashMap = webServiceSecurityDecl.getSecurityRoleRefs();
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                SecurityRoleRefBean securityRoleRefBean = servletBean.createSecurityRoleRef();
                securityRoleRefBean.setRoleName(entry.getKey());
                securityRoleRefBean.setRoleLink(entry.getValue());
            }
        }
    }

    private static void createSecurityConstraints(WebAppBean webAppBean, WebServiceSEIDecl webServiceSEIDecl, WebServiceSecurityDecl webServiceSecurityDecl) {
        String string2;
        AuthConstraintBean authConstraintBean;
        Object object;
        Iterator<PortDecl> iterator = webServiceSEIDecl.getDDPorts();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            object = iterator.next();
            arrayList.add(object.getServiceUri());
        }
        object = webAppBean.createSecurityConstraint();
        ArrayList<String> arrayList2 = webServiceSecurityDecl.getSecurityRoles();
        if (arrayList2.size() > 0) {
            authConstraintBean = object.createAuthConstraint();
            for (String string2 : arrayList2) {
                authConstraintBean.addRoleName(string2);
            }
        }
        authConstraintBean = object.createWebResourceCollection();
        authConstraintBean.setWebResourceName(webServiceSEIDecl.getArtifactName());
        authConstraintBean.setUrlPatterns(arrayList.toArray(new String[0]));
        Object object2 = webServiceSecurityDecl.getTransport();
        if (object2 == UserDataConstraint.Transport.INTEGRAL) {
            string2 = object.createUserDataConstraint();
            string2.setTransportGuarantee("INTEGRAL");
        } else if (object2 == UserDataConstraint.Transport.CONFIDENTIAL) {
            string2 = object.createUserDataConstraint();
            string2.setTransportGuarantee("CONFIDENTIAL");
        }
    }

    private static void createRunAs(WebAppBean webAppBean, List<ServletBean> list, WebServiceSecurityDecl webServiceSecurityDecl) {
        for (ServletBean servletBean : list) {
            if (!webServiceSecurityDecl.isRunAsEnabled()) continue;
            RunAsBean runAsBean = servletBean.createRunAs();
            runAsBean.setRoleName(webServiceSecurityDecl.getRunAsRole());
            if (webServiceSecurityDecl.isSecurityRolesDefined()) continue;
            WebAppProcessor.createSecurityRoles(webAppBean, webServiceSecurityDecl);
        }
    }
}

