/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.jws.war;

import java.util.Iterator;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.RunAsRoleAssignmentBean;
import weblogic.j2ee.descriptor.wl.SecurityRoleAssignmentBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.ModuleInfo;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSecurityDecl;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCProcessor;
import weblogic.wsee.tools.jws.jaxrpc.JAXRPCWebServiceInfo;

public class WeblogicWeb
extends JAXRPCProcessor {
    protected void processImpl(JAXRPCWebServiceInfo jAXRPCWebServiceInfo) throws WsBuildException {
        if (this.moduleInfo.isWsdlOnly()) {
            return;
        }
        if (jAXRPCWebServiceInfo.getWebService().isEjb()) {
            return;
        }
        WeblogicWebAppBean weblogicWebAppBean = this.getWeblogicWebAppBean(this.moduleInfo);
        WebServiceSEIDecl webServiceSEIDecl = jAXRPCWebServiceInfo.getWebService();
        Iterator<PortDecl> iterator = webServiceSEIDecl.getDDPorts();
        assert (iterator.hasNext());
        weblogicWebAppBean.setContextRoots(new String[]{iterator.next().getContextPath()});
        WebServiceSecurityDecl webServiceSecurityDecl = webServiceSEIDecl.getWebServiceSecurityDecl();
        if (!webServiceSecurityDecl.delegateToPolicyRoleConsumer()) {
            WeblogicWeb.addSecurityRoleAssignments(weblogicWebAppBean, webServiceSecurityDecl);
            WeblogicWeb.addRunAsRoleAssignment(weblogicWebAppBean, webServiceSecurityDecl);
        }
    }

    private WeblogicWebAppBean getWeblogicWebAppBean(ModuleInfo moduleInfo) {
        WeblogicWebAppBean weblogicWebAppBean = moduleInfo.getWeblogicWebAppBean();
        if (weblogicWebAppBean == null) {
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            weblogicWebAppBean = (WeblogicWebAppBean)editableDescriptorManager.createDescriptorRoot(WeblogicWebAppBean.class).getRootBean();
            moduleInfo.setWeblogicWebAppBean(weblogicWebAppBean);
        }
        return weblogicWebAppBean;
    }

    private static void addSecurityRoleAssignments(WeblogicWebAppBean weblogicWebAppBean, WebServiceSecurityDecl webServiceSecurityDecl) {
        if (webServiceSecurityDecl.isSecurityRolesDefined()) {
            for (String string : webServiceSecurityDecl.getSecurityRoles()) {
                if (!WeblogicWeb.needToCreateSecurityRoleAssignments(weblogicWebAppBean, string)) continue;
                String[] stringArray = webServiceSecurityDecl.getPrincipals(string);
                SecurityRoleAssignmentBean securityRoleAssignmentBean = weblogicWebAppBean.createSecurityRoleAssignment();
                securityRoleAssignmentBean.setRoleName(string);
                if (stringArray == null) {
                    securityRoleAssignmentBean.createExternallyDefined();
                    continue;
                }
                securityRoleAssignmentBean.setPrincipalNames(stringArray);
            }
        }
    }

    private static boolean needToCreateSecurityRoleAssignments(WeblogicWebAppBean weblogicWebAppBean, String string) {
        SecurityRoleAssignmentBean[] securityRoleAssignmentBeanArray;
        for (SecurityRoleAssignmentBean securityRoleAssignmentBean : securityRoleAssignmentBeanArray = weblogicWebAppBean.getSecurityRoleAssignments()) {
            if (!securityRoleAssignmentBean.getRoleName().equals(string)) continue;
            return false;
        }
        return true;
    }

    private static void addRunAsRoleAssignment(WeblogicWebAppBean weblogicWebAppBean, WebServiceSecurityDecl webServiceSecurityDecl) {
        if (webServiceSecurityDecl.isRunAsEnabled()) {
            RunAsRoleAssignmentBean runAsRoleAssignmentBean = weblogicWebAppBean.createRunAsRoleAssignment();
            runAsRoleAssignmentBean.setRoleName(webServiceSecurityDecl.getRunAsRole());
            runAsRoleAssignmentBean.setRunAsPrincipalName(webServiceSecurityDecl.getRunAsPrincipal());
        }
    }
}

